/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.llm.endpoints.functions;

import com.jetbrains.toolbox.platform.llm.endpoints.functions.FunctionResultContent;
import com.jetbrains.toolbox.platform.llm.endpoints.functions.LlmFunctionUpdateEvent;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LlmFunctionCallProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Flow<LlmFunctionUpdateEvent> updates;

    public LlmFunctionCallProcess(@NotNull Flow<? extends LlmFunctionUpdateEvent> updates2) {
        Intrinsics.checkNotNullParameter(updates2, (String)"updates");
        this.updates = updates2;
    }

    @NotNull
    public final Flow<LlmFunctionUpdateEvent> getUpdates() {
        return this.updates;
    }

    @NotNull
    public String toString() {
        return "LlmFunctionCallProcess(updates=" + this.updates + ")";
    }

    public int hashCode() {
        return this.updates.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LlmFunctionCallProcess)) {
            return false;
        }
        LlmFunctionCallProcess llmFunctionCallProcess = (LlmFunctionCallProcess)other;
        return Intrinsics.areEqual(this.updates, llmFunctionCallProcess.updates);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LlmFunctionCallProcess failed(@NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new LlmFunctionCallProcess((Flow<? extends LlmFunctionUpdateEvent>)FlowKt.flowOf((Object)new LlmFunctionUpdateEvent.Error(reason)));
        }

        @NotNull
        public final LlmFunctionCallProcess textResponse(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return new LlmFunctionCallProcess((Flow<? extends LlmFunctionUpdateEvent>)FlowKt.flowOf((Object)new LlmFunctionUpdateEvent.Response(CollectionsKt.listOf((Object)new FunctionResultContent.Text(text2)))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

