/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.images.assets;

import com.jetbrains.toolbox.platform.image.ImageKey;
import com.jetbrains.toolbox.platform.image.ImageKeyKt;
import com.jetbrains.toolbox.platform.images.assets.vector.AiAssistantKt;
import com.jetbrains.toolbox.platform.images.assets.vector.CwmKt;
import com.jetbrains.toolbox.platform.images.internal.JetBrainsImageKeys;
import com.jetbrains.toolbox.platform.resource.ResourceReader;
import com.jetbrains.toolbox.platform.resource.jvm.JvmResourceReaderKt;
import com.jetbrains.toolbox.platform.ui.images.ImageProvider;
import com.jetbrains.toolbox.platform.ui.images.ImageProviderKt;
import com.jetbrains.toolbox.platform.ui.images.SourceImage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JetBrainsImageProvider
implements ImageProvider {
    @NotNull
    private final ResourceReader reader = JvmResourceReaderKt.jvmResourceReader((Object)this, (String)"images/jb/");
    public static final int $stable = 8;

    @Override
    @Nullable
    public SourceImage resolveImage(@NotNull ImageKey key, boolean isDark) {
        String shortName;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!ImageKeyKt.isQualifiedBy((ImageKey)key, (KClass)Reflection.getOrCreateKotlinClass(JetBrainsImageKeys.class))) {
            return null;
        }
        return switch (shortName = ImageKeyKt.shortName((ImageKey)key)) {
            case "ai-assistant" -> ImageProviderKt.getSourceImage(AiAssistantKt.getAiAssistant());
            case "cwm" -> ImageProviderKt.getSourceImage(CwmKt.getCwm());
            case "jetbrains" -> ImageProviderKt.resourceImage(this.reader, "jetbrains.svg", false);
            case "teamcity" -> ImageProviderKt.resourceImage$default(this.reader, "teamcity.svg", false, 4, null);
            case "toolbox" -> ImageProviderKt.resourceImage(this.reader, "toolbox.svg", false);
            default -> throw new IllegalStateException(("Unknown image key: " + key).toString());
        };
    }
}

