/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.packageextractor;

import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.packageextractor.SevenZipLocator;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;

public final class NearExecutable7zLocator
implements SevenZipLocator {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final WellKnownPaths wellKnownPaths;

    public NearExecutable7zLocator(@NotNull FileSystem fileSystem, @NotNull WellKnownPaths wellKnownPaths) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)wellKnownPaths, (String)"wellKnownPaths");
        this.fileSystem = fileSystem;
        this.wellKnownPaths = wellKnownPaths;
    }

    @Override
    @NotNull
    public Path getExecutablePath() {
        Path inAppDir = this.wellKnownPaths.getApplicationDir().resolve("7z.exe");
        if (this.fileSystem.exists(inAppDir)) {
            return inAppDir;
        }
        String string = System.getProperty("user.dir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path inUserDir = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null).resolve("7z.exe");
        if (this.fileSystem.exists(inUserDir)) {
            return inUserDir;
        }
        throw new IllegalStateException("Failed to find 7zip executable".toString());
    }
}

