/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import com.jetbrains.toolbox.openssh.SshExecutableType;
import com.jetbrains.toolbox.openssh.SshExecutableValidator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class SshExecutableValidatorImpl
implements SshExecutableValidator {
    @Override
    @NotNull
    public SshExecutableValidator.Result validate(@NotNull String executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Logger.INSTANCE.debug("Testing OpenSSH client in path: " + executable);
        try {
            SshExecutableValidator.Result result2;
            Object object;
            try {
                object = new String[]{executable, "-V"};
                object = new ProcessBuilder((String[])object).start();
            }
            catch (IOException e) {
                Logger.INSTANCE.debug("Starting " + executable + " failed: " + e.getMessage());
                return SshExecutableValidator.Result.Failure.INSTANCE;
            }
            Object process2 = object;
            Process finished = ((Process)process2).onExit().get(5L, TimeUnit.SECONDS);
            if (finished.exitValue() != 0) {
                return SshExecutableValidator.Result.Failure.INSTANCE;
            }
            byte[] byArray = finished.getErrorStream().readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            byte[] byArray2 = byArray;
            Object object2 = Charsets.UTF_8;
            String errorOutput2 = ((Object)StringsKt.trim((CharSequence)new String(byArray2, (Charset)object2))).toString();
            byte[] byArray3 = finished.getInputStream().readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"readAllBytes(...)");
            object2 = byArray3;
            Charset charset = Charsets.UTF_8;
            String stdoutOutput = ((Object)StringsKt.trim((CharSequence)new String((byte[])object2, charset))).toString();
            Logger.INSTANCE.debug("STDERR: " + errorOutput2);
            Logger.INSTANCE.debug("STDOUT: " + stdoutOutput);
            if (StringsKt.contains$default((CharSequence)errorOutput2, (CharSequence)"OpenSSH_for_Windows", (boolean)false, (int)2, null)) {
                type = SshExecutableType.OPENSSH_WINDOWS;
                result2 = new SshExecutableValidator.Result.Success(type, errorOutput2);
            } else if (StringsKt.contains$default((CharSequence)errorOutput2, (CharSequence)"OpenSSH", (boolean)false, (int)2, null)) {
                type = SshExecutableType.OPENSSH;
                result2 = new SshExecutableValidator.Result.Success(type, errorOutput2);
            } else {
                result2 = SshExecutableValidator.Result.Failure.INSTANCE;
            }
            return result2;
        }
        catch (Exception e) {
            Logger.INSTANCE.debug((Throwable)e, "Testing " + executable + " failed");
            return SshExecutableValidator.Result.Failure.INSTANCE;
        }
    }
}

