/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network.util;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.util.ProxyUtil;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.network.ProxyAuthenticator;
import com.jetbrains.toolbox.settings.ProxySettings;
import com.jetbrains.toolbox.settings.ProxyType;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class OkHttpClientProxyKt {
    @NotNull
    public static final OkHttpClient.Builder setupProxy(@NotNull OkHttpClient.Builder $this$setupProxy, @NotNull ProxySettings proxySettings2, @NotNull ProxyAuthenticator proxyAuthenticator) {
        Intrinsics.checkNotNullParameter((Object)$this$setupProxy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proxySettings2, (String)"proxySettings");
        Intrinsics.checkNotNullParameter((Object)proxyAuthenticator, (String)"proxyAuthenticator");
        if (proxySettings2.getType() == ProxyType.Disabled) {
            return $this$setupProxy;
        }
        try {
            if (proxySettings2.getType() == ProxyType.System || proxySettings2.getType() == ProxyType.Automatic) {
                ProxySelector proxySelector;
                if (proxySettings2.getType() == ProxyType.System) {
                    ProxySearch proxySearch;
                    ProxySearch proxySearch2 = proxySearch = new ProxySearch();
                    boolean bl = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
                        case 1: {
                            proxySearch2.addStrategy(ProxySearch.Strategy.GNOME);
                            proxySearch2.addStrategy(ProxySearch.Strategy.KDE);
                            proxySearch2.addStrategy(ProxySearch.Strategy.ENV_VAR);
                            proxySearch2.addStrategy(ProxySearch.Strategy.FIREFOX);
                            break;
                        }
                        case 2: {
                            proxySearch2.addStrategy(ProxySearch.Strategy.WIN);
                            proxySearch2.addStrategy(ProxySearch.Strategy.FIREFOX);
                            proxySearch2.addStrategy(ProxySearch.Strategy.JAVA);
                            break;
                        }
                        case 3: {
                            proxySearch2.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    proxySelector = proxySearch.getProxySelector();
                } else {
                    proxySelector = (ProxySelector)ProxyUtil.buildPacSelectorForUrl((String)proxySettings2.getConfigurationUrl());
                }
                if (proxySelector == null) {
                    return $this$setupProxy;
                }
                ProxySelector selector = proxySelector;
                v1 = $this$setupProxy.proxySelector(selector);
            } else {
                v1 = $this$setupProxy.proxy(new Proxy(OkHttpClientProxyKt.toJavaType(proxySettings2.getType()), new InetSocketAddress(proxySettings2.getHost(), proxySettings2.getPort())));
            }
            $this$setupProxy.proxyAuthenticator(proxyAuthenticator);
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to evaluate proxy");
        }
        return $this$setupProxy;
    }

    private static final Proxy.Type toJavaType(ProxyType $this$toJavaType) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toJavaType.ordinal()]) {
            case 1 -> Proxy.Type.DIRECT;
            case 2 -> Proxy.Type.HTTP;
            case 3 -> Proxy.Type.SOCKS;
            default -> throw new IllegalStateException("Unsupported".toString());
        };
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProxyType.values().length];
            try {
                nArray[ProxyType.Disabled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.HTTP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyType.SOCKS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

