/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network.httpServer.websocket;

import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketOutlet;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketReceiver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nWebSocketProtocolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketProtocolHandler.kt\ncom/jetbrains/toolbox/network/httpServer/websocket/WebSocketProtocolHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1869#2,2:77\n1869#2,2:79\n*S KotlinDebug\n*F\n+ 1 WebSocketProtocolHandler.kt\ncom/jetbrains/toolbox/network/httpServer/websocket/WebSocketProtocolHandler\n*L\n40#1:77,2\n68#1:79,2\n*E\n"})
public final class WebSocketProtocolHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    private final Channel channel;
    @NotNull
    private final List<WebsocketReceiver> receivers;
    @NotNull
    private final WebsocketOutlet outlet;

    public WebSocketProtocolHandler(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this.receivers = new ArrayList();
        this.outlet = new WebsocketOutlet(this){
            final /* synthetic */ WebSocketProtocolHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void send(String msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                this.this$0.sendText(msg);
            }
        };
    }

    @NotNull
    public final WebsocketOutlet getOutlet() {
        return this.outlet;
    }

    public final void registerReceiver(@NotNull WebsocketReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        this.receivers.add(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(@NotNull ChannelHandlerContext context2, @NotNull Object message2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Object object = message2;
        if (!(object instanceof WebSocketFrame) || object instanceof PongWebSocketFrame) {
            ReferenceCountUtil.release(message2);
        } else if (object instanceof PingWebSocketFrame) {
            context2.channel().writeAndFlush(new PongWebSocketFrame(((PingWebSocketFrame)message2).content()));
        } else if (object instanceof CloseWebSocketFrame) {
            Channel channel = context2.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            this.closeFrameReceived(channel, (CloseWebSocketFrame)message2);
        } else if (object instanceof TextWebSocketFrame) {
            try {
                Iterable $this$forEach$iv = this.receivers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WebsocketReceiver it = (WebsocketReceiver)element$iv;
                    boolean bl = false;
                    String string = ((TextWebSocketFrame)message2).text();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                    it.receive(string);
                }
            }
            finally {
                if (((TextWebSocketFrame)message2).refCnt() > 0) {
                    ((TextWebSocketFrame)message2).release();
                }
            }
        } else {
            throw new UnsupportedOperationException(message2.getClass().getName() + " frame types not supported");
        }
    }

    @NotNull
    public final ChannelFuture sendFrame(@NotNull ByteBuf message2, boolean binary) {
        ChannelFuture channelFuture;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (this.channel.isOpen()) {
            ChannelFuture channelFuture2 = this.channel.writeAndFlush(binary ? (WebSocketFrame)new BinaryWebSocketFrame(message2) : (WebSocketFrame)new TextWebSocketFrame(message2));
            Intrinsics.checkNotNull((Object)channelFuture2);
            channelFuture = channelFuture2;
        } else {
            ChannelFuture channelFuture3 = this.channel.newFailedFuture(new ClosedChannelException());
            Intrinsics.checkNotNull((Object)channelFuture3);
            channelFuture = channelFuture3;
        }
        return channelFuture;
    }

    @NotNull
    public final ChannelFuture sendText(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        String string = message2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(...)");
        return this.sendFrame(byteBuf, false);
    }

    private final void closeFrameReceived(Channel channel, CloseWebSocketFrame message2) {
        channel.close();
        message2.release();
        Iterable $this$forEach$iv = this.receivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebsocketReceiver it = (WebsocketReceiver)element$iv;
            boolean bl = false;
            it.disconnected();
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext context2, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Logger.INSTANCE.warn(cause, "Caught exception during Http request processing");
    }
}

