/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.inline;

import androidx.compose.foundation.text.InlineTextContent;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontStyle;
import androidx.compose.ui.text.font.FontWeight;
import com.jetbrains.toolbox.markdown.renderer.inline.MarkdownInlineElementProcessor;
import com.jetbrains.toolbox.markdown.renderer.inline.MarkdownInlineElementProcessorKt;
import com.jetbrains.toolbox.markdown.renderer.inline.MarkdownRenderedText;
import com.jetbrains.toolbox.markdown.renderer.inline.MarkdownRenderedTextKt;
import com.jetbrains.toolbox.markdown.skeleton.MarkdownSkeletonBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMarkdownInlineElementProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownInlineElementProcessor.kt\ncom/jetbrains/toolbox/markdown/renderer/inline/MarkdownInlineStyleElementProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,268:1\n827#2:269\n855#2,2:270\n1565#3:272\n1359#3,6:273\n*S KotlinDebug\n*F\n+ 1 MarkdownInlineElementProcessor.kt\ncom/jetbrains/toolbox/markdown/renderer/inline/MarkdownInlineStyleElementProcessor\n*L\n103#1:269\n103#1:270,2\n106#1:272\n107#1:273,6\n*E\n"})
final class MarkdownInlineStyleElementProcessor
implements MarkdownInlineElementProcessor {
    @NotNull
    public static final MarkdownInlineStyleElementProcessor INSTANCE = new MarkdownInlineStyleElementProcessor();

    private MarkdownInlineStyleElementProcessor() {
    }

    @Override
    public boolean isApplicable(@NotNull MarkdownSkeletonBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return MarkdownInlineElementProcessorKt.access$getINLINE_STYLE_ELEMENTS$p().contains(block.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MarkdownRenderedText Process(@NotNull MarkdownSkeletonBlock block, @Nullable Composer $composer, int $changed) {
        void $this$withStyle$iv;
        void $this$filterNotTo$iv$iv;
        TextStyle textStyle;
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        $composer.startReplaceGroup(1248532045);
        ComposerKt.sourceInformation($composer, "C(Process)103@4375L17:MarkdownInlineElementProcessor.kt#ic5x5n");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart(1248532045, $changed, -1, "com.jetbrains.toolbox.markdown.renderer.inline.MarkdownInlineStyleElementProcessor.Process (MarkdownInlineElementProcessor.kt:95)");
        }
        if (Intrinsics.areEqual((Object)(iElementType = block.getType()), (Object)MarkdownElementTypes.EMPH)) {
            textStyle = new TextStyle(0L, 0L, null, FontStyle.box-impl(FontStyle.Companion.getItalic-_-LCdwA()), null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFFFF7, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.STRONG)) {
            textStyle = new TextStyle(0L, 0L, FontWeight.Companion.getBold(), null, null, null, null, 0L, null, null, null, 0L, null, null, null, 0, 0, 0L, null, null, null, 0, 0, null, 0xFFFFFB, null);
        } else {
            throw new IllegalStateException(("Unknown type: " + block.getType()).toString());
        }
        SpanStyle style = textStyle.toSpanStyle();
        Iterable $this$filterNot$iv = block.getChildren();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Object object = $this$filterNotTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            MarkdownSkeletonBlock it = (MarkdownSkeletonBlock)element$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EMPH)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List children = (List)destination$iv$iv;
        MarkdownRenderedText markdownRenderedText = MarkdownInlineElementProcessor.Companion.Process(children, $composer, 48);
        AnnotatedString annotatedString = markdownRenderedText.component1();
        Map<String, InlineTextContent> inlineTextContent = markdownRenderedText.component2();
        boolean $i$f$buildAnnotatedString = false;
        Object $this$Process_u24lambda_u241 = object = new AnnotatedString.Builder(0, 1, null);
        boolean bl = false;
        Object bl2 = $this$Process_u24lambda_u241;
        SpanStyle style$iv = style;
        boolean $i$f$withStyle = false;
        int index$iv = $this$withStyle$iv.pushStyle(style$iv);
        try {
            void $this$Process_u24lambda_u241_u240 = $this$withStyle$iv;
            boolean bl3 = false;
            $this$Process_u24lambda_u241_u240.append(annotatedString);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withStyle$iv.pop(index$iv);
        }
        MarkdownRenderedText markdownRenderedText2 = MarkdownRenderedTextKt.toMarkdownRenderedText(((AnnotatedString.Builder)object).toAnnotatedString(), inlineTextContent);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return markdownRenderedText2;
    }
}

