/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.code.higlighting;

import com.jetbrains.toolbox.common.code.LanguageId;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.CodeHighlightingToken;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CodeHighlightingEngine {
    @NotNull
    public HighlightedCode highlight(@NotNull LanguageId var1, @NotNull String var2, @NotNull HighlightedCode var3);

    public static final class Empty
    implements CodeHighlightingEngine {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        @NotNull
        public HighlightedCode highlight(@NotNull LanguageId languageId, @NotNull String code, @NotNull HighlightedCode previous) {
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
            return previous;
        }
    }

    public static final class HighlightedCode {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String code;
        @NotNull
        private final LanguageId languageId;
        @NotNull
        private final List<CodeHighlightingToken> tokens;
        public static final int $stable = 8;

        public HighlightedCode(@NotNull String code, @NotNull LanguageId languageId, @NotNull List<CodeHighlightingToken> tokens) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            this.code = code;
            this.languageId = languageId;
            this.tokens = tokens;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @NotNull
        public final List<CodeHighlightingToken> getTokens() {
            return this.tokens;
        }

        @NotNull
        public String toString() {
            return "HighlightedCode(code=" + this.code + ", languageId=" + this.languageId + ", tokens=" + this.tokens + ")";
        }

        public int hashCode() {
            int result2 = this.code.hashCode();
            result2 = result2 * 31 + this.languageId.hashCode();
            result2 = result2 * 31 + ((Object)this.tokens).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HighlightedCode)) {
                return false;
            }
            HighlightedCode highlightedCode = (HighlightedCode)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)highlightedCode.code)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.languageId, (Object)highlightedCode.languageId)) {
                return false;
            }
            return Intrinsics.areEqual(this.tokens, highlightedCode.tokens);
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final HighlightedCode empty(@NotNull LanguageId languageId) {
                Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
                return new HighlightedCode("", languageId, CollectionsKt.emptyList());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

