/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.animation.typing;

import androidx.compose.animation.core.Animatable;
import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.AnimationVector1D;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.ui.text.AnnotatedString;
import com.jetbrains.toolbox.markdown.utils.UtilsKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class AnimatedTextChunk {
    @NotNull
    private final Instant start;
    @NotNull
    private final AnnotatedString text;
    private final long duration;
    private final long delay;
    @NotNull
    private final Animatable<Float, AnimationVector1D> animatable;
    @NotNull
    private final Instant whenThisChunkAnimationEnds;
    @NotNull
    private final Instant whenNextChunkAnimationStarts;
    public static final int $stable = 8;

    private AnimatedTextChunk(Instant start2, AnnotatedString text2, long duration, long delay, Animatable<Float, AnimationVector1D> animatable) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(animatable, (String)"animatable");
        this.start = start2;
        this.text = text2;
        this.duration = duration;
        this.delay = delay;
        this.animatable = animatable;
        this.whenThisChunkAnimationEnds = this.start.plus-LRDsOJo(this.duration);
        this.whenNextChunkAnimationStarts = this.start.plus-LRDsOJo(this.delay);
    }

    @NotNull
    public final Instant getStart() {
        return this.start;
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    public final long getDelay-UwyO8pc() {
        return this.delay;
    }

    @NotNull
    public final Animatable<Float, AnimationVector1D> getAnimatable() {
        return this.animatable;
    }

    @NotNull
    public final Instant getWhenNextChunkAnimationStarts() {
        return this.whenNextChunkAnimationStarts;
    }

    @Nullable
    public final Object animate(@NotNull Continuation<? super Unit> $completion) {
        Object object = Animatable.animateTo$default(this.animatable, Boxing.boxFloat((float)1.0f), AnimationSpecKt.tween((int)Duration.getInWholeMilliseconds-impl((long)this.duration), (int)Duration.getInWholeMilliseconds-impl((long)UtilsKt.getDelayUntilThisPoint(this.start)), EasingKt.getLinearEasing()), null, null, $completion, 12, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        return "AnimatedTextChunk(start=" + this.start + ", text=" + this.text + ", duration=" + Duration.toString-impl((long)this.duration) + ", delay=" + Duration.toString-impl((long)this.delay) + ", animatable=" + this.animatable + ")";
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = result2 * 31 + this.text.hashCode();
        result2 = result2 * 31 + Duration.hashCode-impl((long)this.duration);
        result2 = result2 * 31 + Duration.hashCode-impl((long)this.delay);
        result2 = result2 * 31 + this.animatable.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnimatedTextChunk)) {
            return false;
        }
        AnimatedTextChunk animatedTextChunk = (AnimatedTextChunk)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)animatedTextChunk.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)animatedTextChunk.text)) {
            return false;
        }
        if (!Duration.equals-impl0((long)this.duration, (long)animatedTextChunk.duration)) {
            return false;
        }
        if (!Duration.equals-impl0((long)this.delay, (long)animatedTextChunk.delay)) {
            return false;
        }
        return Intrinsics.areEqual(this.animatable, animatedTextChunk.animatable);
    }

    public /* synthetic */ AnimatedTextChunk(Instant start2, AnnotatedString text2, long duration, long delay, Animatable animatable, DefaultConstructorMarker $constructor_marker) {
        this(start2, text2, duration, delay, animatable);
    }
}

