/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers.product;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.feed.AdditionalInstallAction;
import com.jetbrains.toolbox.feed.ApplicationMajorVersion;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.FileAssociationsSupport;
import com.jetbrains.toolbox.feed.RemoteFeedItemLicensing;
import com.jetbrains.toolbox.feed.RevisionInfo;
import com.jetbrains.toolbox.managers.product.ToolProductHandler;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.AvailableTool;
import com.jetbrains.toolbox.tools.model.AvailableVersion;
import com.jetbrains.toolbox.tools.model.DetectedProductInfo;
import com.jetbrains.toolbox.tools.model.DetectedToolInstance;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import com.jetbrains.toolbox.tools.model.VscodeProductInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDate;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nVscodeToolProductHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VscodeToolProductHandler.kt\ncom/jetbrains/toolbox/managers/product/VscodeToolProductHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n295#3,2:101\n1563#3:103\n1634#3,3:104\n295#3,2:107\n*S KotlinDebug\n*F\n+ 1 VscodeToolProductHandler.kt\ncom/jetbrains/toolbox/managers/product/VscodeToolProductHandler\n*L\n78#1:101,2\n97#1:103\n97#1:104,3\n97#1:107,2\n*E\n"})
public final class VscodeToolProductHandler
implements ToolProductHandler {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final List<String> launchCommandByOs;
    @NotNull
    private final List<String> cliCommandByOs;

    public VscodeToolProductHandler(@NotNull OS.Type os, @NotNull FileSystem fileSystem) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.launchCommandByOs = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1 -> CollectionsKt.listOf((Object)"Contents/Resources/app/bin/code");
            case 2 -> CollectionsKt.listOf((Object)"code.exe");
            case 3 -> {
                objectArray = new String[]{"/code", "VSCode-linux-arm64/code", "VSCode-linux-x64/code"};
                yield CollectionsKt.listOf((Object[])objectArray);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        this.cliCommandByOs = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1 -> CollectionsKt.emptyList();
            case 2 -> CollectionsKt.listOf((Object)"bin/code.cmd");
            case 3 -> {
                objectArray = new String[]{"bin/code", "VSCode-linux-arm64/bin/code", "VSCode-linux-x64/bin/code"};
                yield CollectionsKt.listOf((Object[])objectArray);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean supports(@NotNull DetectedProductInfo productInfo) {
        Intrinsics.checkNotNullParameter((Object)productInfo, (String)"productInfo");
        return productInfo instanceof VscodeProductInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object createInstalledTool(@NotNull DetectedToolInstance detectedToolInstance, @NotNull AvailableTool availableTool2, @Nullable AvailableVersion version, @Nullable AvailableBuild build2, @NotNull Continuation<? super InstalledTool> $completion) {
        Object object;
        Object object2;
        Object object3;
        String icon2;
        DetectedProductInfo detectedProductInfo = detectedToolInstance.getProductInfo();
        Intrinsics.checkNotNull((Object)detectedProductInfo, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.tools.model.VscodeProductInfo");
        VscodeProductInfo productInfo = (VscodeProductInfo)detectedProductInfo;
        String string = detectedToolInstance.getIcon-CQRfofY();
        if (string == null) {
            AvailableVersion availableVersion = version;
            string = icon2 = availableVersion != null ? availableVersion.getIcon-CQRfofY() : null;
        }
        if ((object3 = productInfo.getExecutablePath()) == null) {
            AvailableBuild availableBuild = build2;
            object3 = availableBuild != null ? availableBuild.getCommand() : null;
            if (object3 == null) {
                object3 = this.findExistingPath(detectedToolInstance.getInstallationDirectory(), this.launchCommandByOs);
            }
        }
        Path launchCommand = object3;
        Path cliCommand = this.findExistingPath(detectedToolInstance.getInstallationDirectory(), this.cliCommandByOs);
        String string2 = availableTool2.getApplicationType-UtVBrGo();
        String string3 = availableTool2.getName();
        String string4 = icon2;
        String string5 = null;
        Object object4 = version;
        if (object4 == null || (object4 = ((AvailableVersion)object4).getName()) == null) {
            object4 = productInfo.getVersion();
        }
        AvailableVersion availableVersion = version;
        ApplicationMajorVersion applicationMajorVersion = availableVersion != null ? availableVersion.getMajorVersion() : null;
        LocalDate localDate = null;
        Object object5 = version;
        if (object5 != null && (object5 = ((AvailableVersion)object5).getLicensing()) != null && (object5 = ((RemoteFeedItemLicensing)object5).getSalesCode()) != null) {
            void it;
            Object object6;
            Object object7 = object6 = object5;
            LocalDate localDate2 = localDate;
            ApplicationMajorVersion applicationMajorVersion2 = applicationMajorVersion;
            Object object8 = object4;
            String string6 = string5;
            String string7 = string4;
            String string8 = string3;
            String string9 = string2;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            string2 = string9;
            string3 = string8;
            string4 = string7;
            string5 = string6;
            object4 = object8;
            applicationMajorVersion = applicationMajorVersion2;
            localDate = localDate2;
            object2 = bl2 ? object6 : null;
        } else {
            object2 = null;
        }
        String string10 = productInfo.getBuildNumber-Y_E1uuk();
        AvailableBuild availableBuild = build2;
        FileAssociationsSupport fileAssociationsSupport = availableBuild != null ? availableBuild.getFileAssociationsSupport() : null;
        Object object9 = build2;
        if (object9 == null || (object9 = ((AvailableBuild)object9).getPostInstall()) == null) {
            object9 = new AdditionalInstallAction(null, 1, null);
        }
        if ((object = build2) == null || (object = ((AvailableBuild)object).getPreUninstall()) == null) {
            object = new AdditionalInstallAction(null, 1, null);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 1053704;
        List list2 = CollectionsKt.emptyList();
        List list3 = null;
        Object object10 = object;
        Object object11 = object9;
        FileAssociationsSupport fileAssociationsSupport2 = fileAssociationsSupport;
        boolean bl = true;
        Path path2 = null;
        Boolean bl3 = null;
        Path path3 = cliCommand;
        List list4 = null;
        Path path4 = launchCommand;
        RevisionInfo revisionInfo = null;
        String string11 = null;
        String string12 = string10;
        Object object12 = object2;
        LocalDate localDate3 = localDate;
        ApplicationMajorVersion applicationMajorVersion3 = applicationMajorVersion;
        Object object13 = object4;
        String string13 = string5;
        String string14 = string4;
        String string15 = string3;
        String string16 = string2;
        return new InstalledTool(string16, string15, string14, string13, (String)object13, applicationMajorVersion3, localDate3, (String)object12, string12, string11, revisionInfo, path4, list4, path3, bl3, path2, bl, fileAssociationsSupport2, (AdditionalInstallAction)object11, (AdditionalInstallAction)object10, list3, list2, n, defaultConstructorMarker);
    }

    @Override
    @Nullable
    public Object updateToolFromProductInfo(@NotNull InstalledTool installedTool2, @NotNull DetectedToolInstance detectedToolInstance, @NotNull Continuation<? super InstalledTool> $completion) {
        Path path2;
        Path path3 = installedTool2.getLaunchCommandDefault();
        if (path3 == null) {
            path3 = this.findExistingPath(detectedToolInstance.getInstallationDirectory(), this.launchCommandByOs);
        }
        if ((path2 = installedTool2.getCliCommandDefault()) == null) {
            path2 = this.findExistingPath(detectedToolInstance.getInstallationDirectory(), this.cliCommandByOs);
        }
        return InstalledTool.copy-B5SJSoI$default(installedTool2, null, null, null, null, null, null, null, null, null, null, null, path3, null, path2, null, null, false, null, null, null, null, null, 4184063, null);
    }

    @Override
    @Nullable
    public ToolWithVersions findTool(@NotNull Collection<ToolWithVersions> availableTools2, @NotNull DetectedToolInstance detectedToolInstance) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter(availableTools2, (String)"availableTools");
            Intrinsics.checkNotNullParameter((Object)detectedToolInstance, (String)"detectedToolInstance");
            DetectedProductInfo detectedProductInfo = detectedToolInstance.getProductInfo();
            Intrinsics.checkNotNull((Object)detectedProductInfo, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.tools.model.VscodeProductInfo");
            VscodeProductInfo info = (VscodeProductInfo)detectedProductInfo;
            Iterable $this$firstOrNull$iv = availableTools2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ToolWithVersions it = (ToolWithVersions)element$iv;
                boolean bl = false;
                if (!ApplicationType.equals-impl0(info.getApplicationId-UtVBrGo(), it.getTool().getApplicationType-UtVBrGo())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    private final Path findExistingPath(Path parent, List<String> paths) {
        Object v0;
        block2: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = paths;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(parent.resolve((String)it).normalized());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!this.fileSystem.exists(it)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Mac.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

