/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.manager;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.Progress;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ProgressNotification {

    public static final class Finished
    implements ProgressNotification {
        @NotNull
        public static final Finished INSTANCE = new Finished();

        private Finished() {
        }

        @NotNull
        public String toString() {
            return "Finished";
        }

        public int hashCode() {
            return 1051386279;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Finished)) {
                return false;
            }
            Finished cfr_ignored_0 = (Finished)other;
            return true;
        }
    }

    public static final class InProgress
    implements ProgressNotification {
        @NotNull
        private final LocalizableString title;
        @Nullable
        private final Progress progress;
        private final boolean isCancelable;

        public InProgress(@NotNull LocalizableString title2, @Nullable Progress progress2, boolean isCancelable) {
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            this.title = title2;
            this.progress = progress2;
            this.isCancelable = isCancelable;
        }

        @NotNull
        public final LocalizableString getTitle() {
            return this.title;
        }

        @Nullable
        public final Progress getProgress() {
            return this.progress;
        }

        public final boolean isCancelable() {
            return this.isCancelable;
        }

        @NotNull
        public String toString() {
            return "InProgress(title=" + this.title + ", progress=" + this.progress + ", isCancelable=" + this.isCancelable + ")";
        }

        public int hashCode() {
            int result2 = this.title.hashCode();
            result2 = result2 * 31 + (this.progress == null ? 0 : this.progress.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isCancelable);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InProgress)) {
                return false;
            }
            InProgress inProgress = (InProgress)other;
            if (!Intrinsics.areEqual((Object)this.title, (Object)inProgress.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.progress, (Object)inProgress.progress)) {
                return false;
            }
            return this.isCancelable == inProgress.isCancelable;
        }
    }
}

