/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.macos;

import com.jetbrains.toolbox.desktop.EdtKt;
import com.jetbrains.toolbox.interop.Foundation;
import com.jetbrains.toolbox.interop.ID;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class WindowKt {
    public static final void updateColors(@NotNull Window awtWindow) {
        Intrinsics.checkNotNullParameter((Object)awtWindow, (String)"awtWindow");
        EdtKt.invokeLaterIfNeeded((Function0<Unit>)((Function0)() -> WindowKt.updateColors$lambda$0(awtWindow)));
    }

    public static final void updateFullScreenButtons(@NotNull Window awtWindow) {
        Intrinsics.checkNotNullParameter((Object)awtWindow, (String)"awtWindow");
        EdtKt.invokeLaterIfNeeded((Function0<Unit>)((Function0)() -> WindowKt.updateFullScreenButtons$lambda$0(awtWindow)));
    }

    @NotNull
    public static final ID macosWindowPtr(@NotNull Window w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        try {
            Object cPlatformWindow = WindowKt.getPlatformWindow(w);
            if (cPlatformWindow != null) {
                Field ptr = cPlatformWindow.getClass().getSuperclass().getDeclaredField("ptr");
                ptr.setAccessible(true);
                return new ID(ptr.getLong(cPlatformWindow));
            }
        }
        catch (Throwable e) {
            Logger.INSTANCE.warn(e, "Fail to get platform window from awt window.");
        }
        ID iD = ID.NIL;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)iD), (String)"NIL");
        return iD;
    }

    private static final Object getPlatformWindow(Window w) {
        try {
            Class<?> cWindowPeerClass;
            Method getPlatformWindowMethod;
            Object cPlatformWindow;
            Class<?> awtAccessor = Class.forName("sun.awt.AWTAccessor");
            Object componentAccessor = awtAccessor.getMethod("getComponentAccessor", new Class[0]).invoke(null, new Object[0]);
            Class[] classArray = new Class[]{Component.class};
            Method getPeer = componentAccessor.getClass().getMethod("getPeer", classArray);
            getPeer.setAccessible(true);
            Object[] objectArray = new Object[]{w};
            Object peer = getPeer.invoke(componentAccessor, objectArray);
            if (peer != null && (cPlatformWindow = (getPlatformWindowMethod = (cWindowPeerClass = peer.getClass()).getDeclaredMethod("getPlatformWindow", new Class[0])).invoke(peer, new Object[0])) != null) {
                return cPlatformWindow;
            }
        }
        catch (Throwable e) {
            Logger.INSTANCE.warn(e, "Fail to get cPlatformWindow from awt window.");
        }
        return null;
    }

    private static final Unit updateColors$lambda$0(Window $awtWindow) {
        ID window = WindowKt.macosWindowPtr($awtWindow);
        ID delegate = Foundation.invoke(window, "delegate", new Object[0]);
        Object[] objectArray = new Object[]{Foundation.createSelector("updateColors")};
        if (Foundation.invoke(delegate, "respondsToSelector:", objectArray).toBoolean()) {
            Foundation.invoke(delegate, "updateColors", new Object[0]);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateFullScreenButtons$lambda$0(Window $awtWindow) {
        Pointer selector = Foundation.createSelector("updateFullScreenButtons");
        ID window = WindowKt.macosWindowPtr($awtWindow);
        ID delegate = Foundation.invoke(window, "delegate", new Object[0]);
        Object[] objectArray = new Object[]{selector};
        if (Foundation.invoke(delegate, "respondsToSelector:", objectArray).toBoolean()) {
            Foundation.invoke(delegate, "updateFullScreenButtons", new Object[0]);
        }
        return Unit.INSTANCE;
    }
}

