/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.jbclient.clientLink.websocket;

import com.intellij.remoteDev.thinClientLink.ClientToGtwMessage;
import com.intellij.remoteDev.thinClientLink.GtwToClientMessage;
import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.jbclient.clientLink.ClientMessageReceiver;
import com.jetbrains.toolbox.jbclient.clientLink.GatewayMessageSender;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketOutlet;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketReceiver;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;

public final class ClientLinkWebsocketHandler
implements GatewayMessageSender,
WebsocketReceiver {
    @NotNull
    private final WebsocketOutlet outlet;
    @NotNull
    private final ClientMessageReceiver receiver;

    public ClientLinkWebsocketHandler(@NotNull WebsocketOutlet outlet2, @NotNull ClientMessageReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)outlet2, (String)"outlet");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        this.outlet = outlet2;
        this.receiver = receiver;
    }

    @Override
    public void connected() {
        this.receiver.connected(this);
    }

    @Override
    public void receive(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.receiver.receive((ClientToGtwMessage)JsonKt.getJsonx().decodeFromString((DeserializationStrategy)ClientToGtwMessage.Companion.serializer(), msg));
    }

    @Override
    public void disconnected() {
        this.receiver.disconnected(this);
    }

    @Override
    public void send(@NotNull GtwToClientMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.outlet.send(JsonKt.getJsonx().encodeToString((SerializationStrategy)GtwToClientMessage.Companion.serializer(), (Object)message2));
    }
}

