/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ipc;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.ipc.XSISemaphoreConstants;
import com.jetbrains.toolbox.ipc.XSISemaphoreSysCalls;
import com.jetbrains.toolbox.ipc.darwin_semid_ds;
import com.jetbrains.toolbox.ipc.linux_semid_ds;
import com.jetbrains.toolbox.ipc.sembuf;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XSISemaphore {
    private final int semid;

    public XSISemaphore(int semid) {
        this.semid = semid;
    }

    public final int getSemid() {
        return this.semid;
    }

    public final int setValue(int value2) {
        return this.semctlUniversal(XSISemaphoreSysCalls.Companion.getINSTANCE(), this.semid, XSISemaphoreConstants.INSTANCE.getSETVAL(), Pointer.createConstant((int)value2));
    }

    public final int getValue() {
        return this.semctlUniversal(XSISemaphoreSysCalls.Companion.getINSTANCE(), this.semid, XSISemaphoreConstants.INSTANCE.getGETVAL(), null);
    }

    @Nullable
    public final NativeLong getOtime() {
        boolean success2;
        Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1 -> {
                Structure result = new linux_semid_ds();
                yield TuplesKt.to((Object)result, () -> XSISemaphore.getOtime$lambda$0((linux_semid_ds)result));
            }
            case 2 -> {
                Structure result = new darwin_semid_ds();
                yield TuplesKt.to((Object)result, () -> XSISemaphore.getOtime$lambda$1((darwin_semid_ds)result));
            }
            default -> throw new IllegalStateException("Unsupported OS".toString());
        };
        Structure semidDs = (Structure)pair.component1();
        Function0 sem_otime = (Function0)pair.component2();
        semidDs.write();
        boolean bl = success2 = this.semctlUniversal(XSISemaphoreSysCalls.Companion.getINSTANCE(), this.semid, 2, semidDs.getPointer()) != -1;
        if (!success2) {
            return null;
        }
        semidDs.read();
        return (NativeLong)sem_otime.invoke();
    }

    public final int take() {
        short[] sArray = new short[]{-1};
        return this.semop(sArray);
    }

    public final int noopWithOtimeChange() {
        short[] sArray = new short[]{1, -1};
        return this.semop(sArray);
    }

    private final int semop(short ... ops) {
        Structure[] opsStructs = new sembuf().toArray(ops.length);
        int n = ops.length;
        for (int j = 0; j < n; ++j) {
            sembuf sembuf2;
            int i2 = j;
            short op = ops[j];
            Structure structure = opsStructs[i2];
            Intrinsics.checkNotNull((Object)structure, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.ipc.sembuf");
            sembuf $this$semop_u24lambda_u240 = sembuf2 = (sembuf)structure;
            boolean bl = false;
            $this$semop_u24lambda_u240.sem_num = 0;
            $this$semop_u24lambda_u240.sem_op = op;
            $this$semop_u24lambda_u240.sem_flg = (short)6144;
        }
        XSISemaphoreSysCalls xSISemaphoreSysCalls = XSISemaphoreSysCalls.Companion.getINSTANCE();
        Intrinsics.checkNotNull((Object)opsStructs);
        return xSISemaphoreSysCalls.semop(this.semid, opsStructs, opsStructs.length);
    }

    private final int semctlUniversal(XSISemaphoreSysCalls $this$semctlUniversal, int semid, int cmd, Pointer arg) {
        int n;
        if (OS.INSTANCE.isMac() && Platform.isARM()) {
            n = $this$semctlUniversal.semctl(semid, 0, cmd, new NativeLong(0L), new NativeLong(0L), new NativeLong(0L), new NativeLong(0L), new NativeLong(0L), arg);
        } else if (OS.INSTANCE.isLinux() || OS.INSTANCE.isMac()) {
            n = $this$semctlUniversal.semctl(semid, 0, cmd, arg);
        } else {
            throw new IllegalStateException("Unsupported OS or platform".toString());
        }
        return n;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.semid);
    }

    private static final NativeLong getOtime$lambda$0(linux_semid_ds $result) {
        return $result.sem_otime;
    }

    private static final NativeLong getOtime$lambda$1(darwin_semid_ds $result) {
        return $result.sem_otime;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

