/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ipc;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.ipc.ApplicationStartLock;
import com.jetbrains.toolbox.log.BootstrapLogger;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.ExceptionsKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nWin32ApplicationStartLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Win32ApplicationStartLock.kt\ncom/jetbrains/toolbox/ipc/Win32ApplicationStartLock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BootstrapLogger.kt\ncom/jetbrains/toolbox/log/BootstrapLogger\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,121:1\n1#2:122\n1#2:140\n1#2:168\n1#2:195\n1#2:209\n79#3,7:123\n124#3,10:130\n134#3,3:141\n79#3,7:144\n79#3,7:151\n124#3,10:158\n134#3,3:169\n79#3,7:178\n109#3,10:185\n119#3,3:196\n109#3,10:199\n119#3,3:210\n434#4:172\n507#4,5:173\n*S KotlinDebug\n*F\n+ 1 Win32ApplicationStartLock.kt\ncom/jetbrains/toolbox/ipc/Win32ApplicationStartLock\n*L\n42#1:140\n57#1:168\n113#1:195\n116#1:209\n25#1:123,7\n42#1:130,10\n42#1:141,3\n48#1:144,7\n51#1:151,7\n57#1:158,10\n57#1:169,3\n110#1:178,7\n113#1:185,10\n113#1:196,3\n116#1:199,10\n116#1:210,3\n102#1:172\n102#1:173,5\n*E\n"})
public final class Win32ApplicationStartLock
extends ApplicationStartLock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private WinNT.HANDLE mainInstanceFileMapping;
    private static final int PAGE_READWRITE = 4;

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean tryAcquireMainInstance(@NotNull BootstrapLogger bootstrapLogger) {
        Intrinsics.checkNotNullParameter((Object)bootstrapLogger, (String)"bootstrapLogger");
        if (!OS.INSTANCE.isWindows()) {
            boolean $i$a$-require-Win32ApplicationStartLock$tryAcquireMainInstance$22 = false;
            String $i$a$-require-Win32ApplicationStartLock$tryAcquireMainInstance$22 = "This is a Windows-specific implementation";
            throw new IllegalArgumentException($i$a$-require-Win32ApplicationStartLock$tryAcquireMainInstance$22.toString());
        }
        WinNT.HANDLE fileMapping = null;
        try {
            boolean mappingAlreadyExists;
            BootstrapLogger this_$iv;
            void this_$iv2;
            String uniqueKey = this.makeSingleApplicationKey();
            String mappingName = this.makeFileName(uniqueKey, "qipc_sharedmemory_");
            BootstrapLogger bootstrapLogger2 = bootstrapLogger;
            Object message$iv = "Trying to acquire file mapping: " + mappingName;
            boolean $i$f$info2 = false;
            if (this_$iv2.isTinylogEnabled()) {
                Logger.INSTANCE.info((String)message$iv);
            } else {
                this_$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, (String)message$iv, null, 4, null));
                this_$iv2.writeln(Level.INFO, (String)message$iv);
            }
            fileMapping = Kernel32.INSTANCE.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, null, 4, 0, 65535, mappingName + "\u0000");
            if (fileMapping == null) {
                int error2 = Kernel32.INSTANCE.GetLastError();
                message$iv = bootstrapLogger;
                Object $i$f$info2 = null;
                String message$iv2 = "Failed to access file mapping: " + error2;
                boolean $i$f$error = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.error(message$iv2);
                } else {
                    void exception$iv;
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.ERROR, message$iv2, (Throwable)exception$iv));
                    String exceptionInfo$iv = "";
                    this_$iv.writeln(Level.ERROR, message$iv2 + exceptionInfo$iv);
                }
                return false;
            }
            boolean bl = mappingAlreadyExists = Kernel32.INSTANCE.GetLastError() == 183;
            if (mappingAlreadyExists) {
                this_$iv = bootstrapLogger;
                String message$iv3 = "instance type: SECONDARY";
                boolean $i$f$info3 = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.info(message$iv3);
                } else {
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv3, null, 4, null));
                    this_$iv.writeln(Level.INFO, message$iv3);
                }
                this.safeCloseHandle(bootstrapLogger, fileMapping);
            } else {
                this_$iv = bootstrapLogger;
                String message$iv4 = "instance type: MAIN";
                boolean $i$f$info4 = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.info(message$iv4);
                } else {
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv4, null, 4, null));
                    this_$iv.writeln(Level.INFO, message$iv4);
                }
                this.mainInstanceFileMapping = fileMapping;
            }
            return !mappingAlreadyExists;
        }
        catch (Throwable e) {
            block21: {
                Object object;
                void this_$iv;
                String message$iv;
                block23: {
                    block22: {
                        void exception$iv;
                        block20: {
                            BootstrapLogger mappingAlreadyExists = bootstrapLogger;
                            Throwable this_$iv3 = e;
                            message$iv = "Unexpected error while checking the file mapping";
                            boolean $i$f$error = false;
                            if (!this_$iv.isTinylogEnabled()) break block20;
                            if (exception$iv == null) {
                                Logger.INSTANCE.error(message$iv);
                            } else {
                                Logger.INSTANCE.error((Throwable)exception$iv, message$iv);
                            }
                            break block21;
                        }
                        this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.ERROR, message$iv, (Throwable)exception$iv));
                        object = exception$iv;
                        if (object == null) break block22;
                        void it$iv = object;
                        boolean bl = false;
                        String string = "\n" + ExceptionsKt.stackTraceToString((Throwable)it$iv);
                        object = string;
                        if (string != null) break block23;
                    }
                    object = "";
                }
                String exceptionInfo$iv = object;
                this_$iv.writeln(Level.ERROR, message$iv + exceptionInfo$iv);
            }
            this.safeCloseHandle(bootstrapLogger, fileMapping);
            if (Intrinsics.areEqual(fileMapping, (Object)this.mainInstanceFileMapping)) {
                this.mainInstanceFileMapping = null;
            }
            throw e;
        }
    }

    @Override
    protected void releaseMainInstance(@NotNull BootstrapLogger bootstrapLogger) {
        Intrinsics.checkNotNullParameter((Object)bootstrapLogger, (String)"bootstrapLogger");
        this.safeCloseHandle(bootstrapLogger, this.mainInstanceFileMapping);
        this.mainInstanceFileMapping = null;
    }

    @NotNull
    public final String makeSingleApplicationKey() {
        String homeStr;
        String uuid;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String string = uuid = "6CB3F228-C947-4507-AB81-7E65EFA92B87";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        digest.update(byArray);
        String string2 = System.getenv("USERPROFILE");
        if (string2 == null) {
            throw new IllegalStateException("USERPROFILE environment variable is not set".toString());
        }
        String home = string2;
        String string3 = homeStr = StringsKt.replace$default((String)home, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        byte[] byArray2 = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        digest.update(byArray2);
        byte[] hashBytes = digest.digest();
        Intrinsics.checkNotNull((Object)hashBytes);
        return ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, Win32ApplicationStartLock::makeSingleApplicationKey$lambda$0, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeFileName(@NotNull String key, @NotNull String prefix) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (((CharSequence)key).length() == 0) {
            return "";
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hashBytes = digest.digest(byArray);
        Intrinsics.checkNotNull((Object)hashBytes);
        String hex = ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, Win32ApplicationStartLock::makeFileName$lambda$0, (int)30, null);
        String $this$filter$iv = key;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isLetter(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String keyWithoutNonLetters = ((StringBuilder)destination$iv$iv).toString();
        return prefix + keyWithoutNonLetters + hex;
    }

    /*
     * WARNING - void declaration
     */
    private final void safeCloseHandle(BootstrapLogger bootstrapLogger, WinNT.HANDLE fileMapping) {
        block13: {
            WinNT.HANDLE hANDLE = fileMapping;
            if (hANDLE == null) break block13;
            WinNT.HANDLE handle2 = hANDLE;
            boolean bl = false;
            try {
                void exception$iv;
                void this_$iv;
                if (Kernel32.INSTANCE.CloseHandle(handle2)) {
                    void this_$iv2;
                    BootstrapLogger bootstrapLogger2 = bootstrapLogger;
                    String message$iv = "Successfully closed file mapping handle";
                    boolean $i$f$info = false;
                    if (this_$iv2.isTinylogEnabled()) {
                        Logger.INSTANCE.info(message$iv);
                    } else {
                        this_$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                        this_$iv2.writeln(Level.INFO, message$iv);
                    }
                    break block13;
                }
                int error2 = Kernel32.INSTANCE.GetLastError();
                BootstrapLogger message$iv = bootstrapLogger;
                Object $i$f$info = null;
                String message$iv2 = "Failed to close handle: " + error2;
                boolean $i$f$warn = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.warn(message$iv2);
                    break block13;
                }
                this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, message$iv2, (Throwable)exception$iv));
                String exceptionInfo$iv = "";
                this_$iv.writeln(Level.WARN, message$iv2 + exceptionInfo$iv);
            }
            catch (Exception e) {
                Object object;
                String message$iv;
                BootstrapLogger this_$iv;
                block15: {
                    block14: {
                        this_$iv = bootstrapLogger;
                        Throwable exception$iv = e;
                        message$iv = "Error while closing handle";
                        boolean $i$f$warn = false;
                        if (this_$iv.isTinylogEnabled()) {
                            if (exception$iv == null) {
                                Logger.INSTANCE.warn(message$iv);
                            } else {
                                Logger.INSTANCE.warn(exception$iv, message$iv);
                            }
                            break block13;
                        }
                        this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, message$iv, exception$iv));
                        object = exception$iv;
                        if (object == null) break block14;
                        Throwable it$iv = object;
                        boolean bl2 = false;
                        String string = "\n" + it$iv;
                        object = string;
                        if (string != null) break block15;
                    }
                    object = "";
                }
                Object exceptionInfo$iv = object;
                this_$iv.writeln(Level.WARN, message$iv + (String)exceptionInfo$iv);
            }
        }
    }

    private static final CharSequence makeSingleApplicationKey$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final CharSequence makeFileName$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

