/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ipc;

import com.jetbrains.toolbox.common.BlurTokensKt;
import com.jetbrains.toolbox.ipc.IpcRequestParseException;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nIpcRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpcRequest.kt\ncom/jetbrains/toolbox/ipc/IpcRequest\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,72:1\n37#2,2:73\n*S KotlinDebug\n*F\n+ 1 IpcRequest.kt\ncom/jetbrains/toolbox/ipc/IpcRequest\n*L\n13#1:73,2\n*E\n"})
public abstract sealed class IpcRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private IpcRequest() {
    }

    public abstract long getPid();

    @NotNull
    public abstract String getPrefix();

    @NotNull
    public final String getBlurredMessage() {
        char[] cArray = new char[]{'\u0000'};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.getMessage(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return BlurTokensKt.blurTokens(thisCollection$iv.toArray(new String[0]));
    }

    @NotNull
    public abstract String getMessage();

    public /* synthetic */ IpcRequest(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @SourceDebugExtension(value={"SMAP\nIpcRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpcRequest.kt\ncom/jetbrains/toolbox/ipc/IpcRequest$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,72:1\n37#2,2:73\n*S KotlinDebug\n*F\n+ 1 IpcRequest.kt\ncom/jetbrains/toolbox/ipc/IpcRequest$Companion\n*L\n44#1:73,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IpcRequest parseMessage(@NotNull String fullMessage) {
            String type2;
            Intrinsics.checkNotNullParameter((Object)fullMessage, (String)"fullMessage");
            char[] cArray = new char[]{'\u0000'};
            List splitMessage = StringsKt.split$default((CharSequence)fullMessage, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            Collection $this$toTypedArray$iv = splitMessage;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String blurredMessage = BlurTokensKt.blurTokens(thisCollection$iv.toArray(new String[0]));
            Object object = (String)CollectionsKt.getOrNull((List)splitMessage, (int)0);
            if (object == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
                throw new IpcRequestParseException("Missing or malformed PID in the request, blurredMessage=" + blurredMessage);
            }
            long pid = (Long)object;
            String string = (String)CollectionsKt.getOrNull((List)splitMessage, (int)1);
            if (string == null) {
                throw new IpcRequestParseException("Missing or malformed IPC type in request, blurredMessage=" + blurredMessage);
            }
            return switch (type2 = string) {
                case "SECONDARY_INSTANCE_CLI" -> {
                    boolean isAgent = Intrinsics.areEqual((Object)CollectionsKt.getOrNull((List)splitMessage, (int)2), (Object)"AGENT");
                    yield new SecondaryCliRequest(isAgent, isAgent ? CollectionsKt.drop((Iterable)splitMessage, (int)3) : CollectionsKt.drop((Iterable)splitMessage, (int)2), pid);
                }
                case "HEALTHCHECK" -> {
                    if (splitMessage.size() > 2) {
                        throw new IpcRequestParseException("Malformed IPC request, blurredMessage=" + blurredMessage);
                    }
                    yield new HealthcheckRequest(pid);
                }
                case "PID" -> {
                    if (splitMessage.size() > 2) {
                        throw new IpcRequestParseException("Malformed IPC request, blurredMessage=" + blurredMessage);
                    }
                    yield new HealthcheckResponse(pid);
                }
                default -> throw new IpcRequestParseException("Unknown IpcRequest type: " + type2 + ", blurredMessage=" + blurredMessage);
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class HealthcheckRequest
    extends IpcRequest {
        private final long pid;
        @NotNull
        private final String prefix;

        public HealthcheckRequest(long pid) {
            super(null);
            this.pid = pid;
            this.prefix = "HEALTHCHECK";
        }

        @Override
        public long getPid() {
            return this.pid;
        }

        @Override
        @NotNull
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.getPid() + "\u0000" + this.getPrefix();
        }

        @NotNull
        public final HealthcheckResponse getResponse(long myPid) {
            return new HealthcheckResponse(myPid);
        }

        public final long component1() {
            return this.pid;
        }

        @NotNull
        public final HealthcheckRequest copy(long pid) {
            return new HealthcheckRequest(pid);
        }

        public static /* synthetic */ HealthcheckRequest copy$default(HealthcheckRequest healthcheckRequest, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = healthcheckRequest.pid;
            }
            return healthcheckRequest.copy(l);
        }

        @NotNull
        public String toString() {
            return "HealthcheckRequest(pid=" + this.pid + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.pid);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HealthcheckRequest)) {
                return false;
            }
            HealthcheckRequest healthcheckRequest = (HealthcheckRequest)other;
            return this.pid == healthcheckRequest.pid;
        }
    }

    public static final class HealthcheckResponse
    extends IpcRequest {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long pid;
        @NotNull
        private final String prefix;
        @NotNull
        private static final String myPrefix = "PID";

        public HealthcheckResponse(long pid) {
            super(null);
            this.pid = pid;
            this.prefix = myPrefix;
        }

        @Override
        public long getPid() {
            return this.pid;
        }

        @Override
        @NotNull
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.getPid() + "\u0000PID";
        }

        public final long component1() {
            return this.pid;
        }

        @NotNull
        public final HealthcheckResponse copy(long pid) {
            return new HealthcheckResponse(pid);
        }

        public static /* synthetic */ HealthcheckResponse copy$default(HealthcheckResponse healthcheckResponse, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = healthcheckResponse.pid;
            }
            return healthcheckResponse.copy(l);
        }

        @NotNull
        public String toString() {
            return "HealthcheckResponse(pid=" + this.pid + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.pid);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HealthcheckResponse)) {
                return false;
            }
            HealthcheckResponse healthcheckResponse = (HealthcheckResponse)other;
            return this.pid == healthcheckResponse.pid;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getMyPrefix() {
                return myPrefix;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    public static final class SecondaryCliRequest
    extends IpcRequest {
        private final boolean isAgent;
        @NotNull
        private final List<String> args;
        private final long pid;
        @NotNull
        private final String prefix;

        public SecondaryCliRequest(boolean isAgent, @NotNull List<String> args, long pid) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            super(null);
            this.isAgent = isAgent;
            this.args = args;
            this.pid = pid;
            this.prefix = "SECONDARY_INSTANCE_CLI";
        }

        public final boolean isAgent() {
            return this.isAgent;
        }

        @NotNull
        public final List<String> getArgs() {
            return this.args;
        }

        @Override
        public long getPid() {
            return this.pid;
        }

        @Override
        @NotNull
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        @NotNull
        public String getMessage() {
            String argsSeparated = CollectionsKt.joinToString$default((Iterable)this.args, (CharSequence)"\u0000", null, null, (int)0, null, null, (int)62, null);
            return this.getPid() + "\u0000" + this.getPrefix() + "\u0000" + (this.isAgent ? "AGENT\u0000" : "") + argsSeparated;
        }

        public final boolean component1() {
            return this.isAgent;
        }

        @NotNull
        public final List<String> component2() {
            return this.args;
        }

        public final long component3() {
            return this.pid;
        }

        @NotNull
        public final SecondaryCliRequest copy(boolean isAgent, @NotNull List<String> args, long pid) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return new SecondaryCliRequest(isAgent, args, pid);
        }

        public static /* synthetic */ SecondaryCliRequest copy$default(SecondaryCliRequest secondaryCliRequest, boolean bl, List list2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                bl = secondaryCliRequest.isAgent;
            }
            if ((n & 2) != 0) {
                list2 = secondaryCliRequest.args;
            }
            if ((n & 4) != 0) {
                l = secondaryCliRequest.pid;
            }
            return secondaryCliRequest.copy(bl, list2, l);
        }

        @NotNull
        public String toString() {
            return "SecondaryCliRequest(isAgent=" + this.isAgent + ", args=" + this.args + ", pid=" + this.pid + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isAgent);
            result2 = result2 * 31 + ((Object)this.args).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.pid);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SecondaryCliRequest)) {
                return false;
            }
            SecondaryCliRequest secondaryCliRequest = (SecondaryCliRequest)other;
            if (this.isAgent != secondaryCliRequest.isAgent) {
                return false;
            }
            if (!Intrinsics.areEqual(this.args, secondaryCliRequest.args)) {
                return false;
            }
            return this.pid == secondaryCliRequest.pid;
        }
    }
}

