/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.ipc;

import com.jetbrains.toolbox.AppFlavor;
import com.jetbrains.toolbox.common.UnixDomainSocketsUtil;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.ipc.IpcInstanceFactory;
import com.jetbrains.toolbox.ipc.IpcMainInstanceIsAlreadyRunningException;
import com.jetbrains.toolbox.ipc.IpcUdsNotSupportedException;
import com.jetbrains.toolbox.ipc.MainInstance;
import com.jetbrains.toolbox.ipc.MainInstanceImpl;
import com.jetbrains.toolbox.ipc.MainInstanceNoOpFake;
import com.jetbrains.toolbox.ipc.SecondaryInstance;
import com.jetbrains.toolbox.log.BootstrapLogger;
import java.net.ConnectException;
import java.nio.channels.ServerSocketChannel;
import java.nio.file.Files;
import java.util.Iterator;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nIpcInstanceFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IpcInstanceFactory.kt\ncom/jetbrains/toolbox/ipc/IpcInstanceFactory\n+ 2 BootstrapLogger.kt\ncom/jetbrains/toolbox/log/BootstrapLogger\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n79#2,7:92\n109#2,10:100\n119#2,3:111\n79#2,7:114\n79#2,7:121\n79#2,7:128\n79#2,7:135\n1869#3:99\n1870#3:142\n1#4:110\n*S KotlinDebug\n*F\n+ 1 IpcInstanceFactory.kt\ncom/jetbrains/toolbox/ipc/IpcInstanceFactory\n*L\n43#1:92,7\n50#1:100,10\n50#1:111,3\n58#1:114,7\n59#1:121,7\n64#1:128,7\n68#1:135,7\n46#1:99\n46#1:142\n50#1:110\n*E\n"})
public final class IpcInstanceFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BootstrapLogger logger;
    private final long pid;
    private final long socketTimeout;
    @NotNull
    private final java.nio.file.Path socketPath;
    public static final int BUFFER_CAPACITY = 16384;

    private IpcInstanceFactory(BootstrapLogger logger, long pid, Path socketOkioPath, long socketTimeout) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)socketOkioPath, (String)"socketOkioPath");
        this.logger = logger;
        this.pid = pid;
        this.socketTimeout = socketTimeout;
        this.socketPath = socketOkioPath.toNioPath();
        if (!UnixDomainSocketsUtil.isValidPath$default(UnixDomainSocketsUtil.INSTANCE, socketOkioPath, null, 2, null)) {
            boolean bl = false;
            this.logger.startLoggingWithTinyLog(AppFlavor.SecondaryInstance);
            String string = "Unix domain socket path is too long: " + ((Object)this.socketPath.toAbsolutePath()).toString();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ IpcInstanceFactory(BootstrapLogger bootstrapLogger, long l, Path path2, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Object object = System.getenv("TOOLBOX_IPC_SOCKET_TIMEOUT_OVERRIDE_MS");
            l2 = DurationKt.toDuration((int)(object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 5000), (DurationUnit)DurationUnit.MILLISECONDS);
        }
        this(bootstrapLogger, l, path2, l2, null);
    }

    @NotNull
    public final SecondaryInstance secondary() {
        return new SecondaryInstance(this.logger, this.pid, this.socketPath, this.socketTimeout, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object main-VtjQ1oo(long $v$c$kotlin-time-Duration$-selfCheckInterval$0, @NotNull Continuation<? super MainInstance> $completion) {
        if (!($completion instanceof main.1)) ** GOTO lbl-1000
        var23_3 = $completion;
        if ((var23_3.label & -2147483648) != 0) {
            var23_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                long J$0;
                int I$0;
                int I$1;
                int I$2;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ IpcInstanceFactory this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.main-VtjQ1oo(0L, (Continuation<? super MainInstance>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = this.logger;
                message$iv = "pid: " + this.pid;
                $i$f$info = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.info(message$iv);
                } else {
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                    this_$iv.writeln(Level.INFO, message$iv);
                }
                attemptCount = 10;
                $this$forEach$iv = (Iterable)new IntRange(1, attemptCount);
                $i$f$forEach = 0;
                var7_10 = $this$forEach$iv.iterator();
lbl26:
                // 2 sources

                while (var7_10.hasNext()) {
                    element$iv = var7_10.next();
                    ((Number)element$iv).intValue();
                    $i$a$-forEach-IpcInstanceFactory$main$2 = 0;
                    try {
                        var10_13 = MainInstanceImpl.Companion.tryGetServerChannel(this.logger, this.socketPath);
                    }
                    catch (IpcUdsNotSupportedException e) {
                        var12_19 = this.logger;
                        var13_22 = e;
                        var14_24 = "UDS is not supported on this platform, will use a no-op main instance. No external messages will be received.";
                        $i$f$warn = false;
                        if (!this_$iv.isTinylogEnabled()) ** GOTO lbl47
                        if (exception$iv == null) {
                            Logger.INSTANCE.warn((String)message$iv);
                        } else {
                            Logger.INSTANCE.warn((Throwable)exception$iv, (String)message$iv);
                        }
                        ** GOTO lbl61
lbl47:
                        // 1 sources

                        this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, (String)message$iv, (Throwable)exception$iv));
                        v0 = exception$iv;
                        if (v0 == null) ** GOTO lbl57
                        it$iv = v0;
                        $i$a$-let-BootstrapLogger$warn$exceptionInfo$1$iv = false;
                        v1 = "\n" + (Throwable)it$iv;
                        v0 = v1;
                        if (v1 != null) ** GOTO lbl58
lbl57:
                        // 2 sources

                        v0 = "";
lbl58:
                        // 2 sources

                        exceptionInfo$iv = v0;
                        this_$iv.writeln(Level.WARN, (String)message$iv + exceptionInfo$iv);
lbl61:
                        // 3 sources

                        return new MainInstanceNoOpFake(this.logger);
                    }
                    serverChannel = var10_13;
                    if (serverChannel != null) {
                        var10_13 = this.logger;
                        message$iv = "Instance type: main";
                        $i$f$info = false;
                        if (this_$iv.isTinylogEnabled()) {
                            Logger.INSTANCE.info(message$iv);
                        } else {
                            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                            this_$iv.writeln(Level.INFO, message$iv);
                        }
                        this_$iv = this.logger;
                        message$iv = "Acquired server channel";
                        $i$f$info = false;
                        if (this_$iv.isTinylogEnabled()) {
                            Logger.INSTANCE.info(message$iv);
                        } else {
                            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                            this_$iv.writeln(Level.INFO, message$iv);
                        }
                        return new MainInstanceImpl(this.logger, this.pid, serverChannel, this.socketPath, this.socketTimeout, $v$c$kotlin-time-Duration$-selfCheckInterval$0, null);
                    }
                    this_$iv = this.logger;
                    message$iv = "checking if the main instance is alive";
                    $i$f$info = false;
                    if (this_$iv.isTinylogEnabled()) {
                        Logger.INSTANCE.info(message$iv);
                    } else {
                        this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                        this_$iv.writeln(Level.INFO, message$iv);
                    }
                    secondary = new SecondaryInstance(this.logger, this.pid, this.socketPath, this.socketTimeout, null);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                    $continuation.L$1 = var7_10;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)secondary);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)serverChannel);
                    $continuation.J$0 = $v$c$kotlin-time-Duration$-selfCheckInterval$0;
                    $continuation.I$0 = attemptCount;
                    $continuation.I$1 = $i$f$forEach;
                    $continuation.I$2 = $i$a$-forEach-IpcInstanceFactory$main$2;
                    $continuation.label = 1;
                    v2 = secondary.getMainInstancePid(Level.TRACE, (Continuation<? super Long>)$continuation);
                    ** if (v2 != var24_5) goto lbl111
lbl110:
                    // 1 sources

                    return var24_5;
lbl111:
                    // 1 sources

                    ** GOTO lbl127
                }
                break;
            }
            case 1: {
                $i$a$-forEach-IpcInstanceFactory$main$2 = $continuation.I$2;
                $i$f$forEach = $continuation.I$1;
                attemptCount = $continuation.I$0;
                $v$c$kotlin-time-Duration$-selfCheckInterval$0 = $continuation.J$0;
                serverChannel = (ServerSocketChannel)$continuation.L$4;
                secondary = (SecondaryInstance)$continuation.L$3;
                element$iv = $continuation.L$2;
                var7_10 = (Iterator<T>)$continuation.L$1;
                $this$forEach$iv = (Iterable)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl127:
                    // 2 sources

                    mainInstancePid = ((Number)v2).longValue();
                    exception$iv = this.logger;
                    message$iv = "main instance pid: " + mainInstancePid;
                    $i$f$info = false;
                    if (this_$iv.isTinylogEnabled()) {
                        Logger.INSTANCE.info(message$iv);
                    } else {
                        this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                        this_$iv.writeln(Level.INFO, message$iv);
                    }
                    if (OS.INSTANCE.isWindows()) {
                        throw new IpcMainInstanceIsAlreadyRunningException(mainInstancePid);
                    }
                    throw new IllegalStateException(("main instance is alive (pid=" + mainInstancePid + "), cannot bind twice").toString());
                }
                catch (ConnectException <unused var>) {
                    Files.deleteIfExists(this.socketPath);
                    ** GOTO lbl26
                }
            }
        }
        throw new IllegalStateException(("failed to bind or exchange healthcheck message with the main instance in " + attemptCount + " attempts").toString());
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object main-VtjQ1oo$default(IpcInstanceFactory ipcInstanceFactory, long l, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
        }
        return ipcInstanceFactory.main-VtjQ1oo(l, (Continuation<? super MainInstance>)continuation);
    }

    public /* synthetic */ IpcInstanceFactory(BootstrapLogger logger, long pid, Path socketOkioPath, long socketTimeout, DefaultConstructorMarker $constructor_marker) {
        this(logger, pid, socketOkioPath, socketTimeout);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

