/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.interop.Win32Integration;
import com.jetbrains.toolbox.interop.Win32Registry;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.WinReg;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class Win32RegistryImpl
implements Win32Registry {
    @Override
    @Nullable
    public String readValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName, boolean wow6432) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        return Win32Integration.INSTANCE.readRegValue(hkey, subKey, valueName, wow6432);
    }

    @Override
    public void writeValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName, @NotNull String value2, boolean wow6432) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Win32Integration.INSTANCE.writeRegValue(hkey, subKey, valueName, value2, wow6432);
    }

    @Override
    @Nullable
    public Integer readIntValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName, boolean wow6432) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        return Win32Integration.INSTANCE.readRegIntValue(hkey, subKey, valueName, wow6432);
    }

    @Override
    public void writeIntValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName, int value2, boolean wow6432) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Win32Integration.INSTANCE.writeRegIntValue(hkey, subKey, valueName, value2, wow6432);
    }

    @Override
    public void deleteKeyRecursively(@NotNull Win32Registry.Hive hKey, @NotNull String subKey) {
        Intrinsics.checkNotNullParameter((Object)hKey, (String)"hKey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Win32Integration.INSTANCE.deleteRegKeyRecursively(hKey, subKey);
    }

    @Override
    public void deleteKey(@NotNull Win32Registry.Hive hkey, @NotNull String subKey) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Win32Integration.INSTANCE.deleteRegKey(hkey, subKey);
    }

    @Override
    public void deleteValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Win32Integration.INSTANCE.deleteRegValue(hkey, subKey, valueName);
    }

    @Override
    @NotNull
    public List<String> listKeys(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, boolean wow6432) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        return Win32Integration.INSTANCE.listRegKeys(hkey, subKey, wow6432);
    }

    @Override
    @NotNull
    public List<String> listValues(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, boolean wow6432) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        return Win32Integration.INSTANCE.listRegValues(hkey, subKey, wow6432);
    }

    @Override
    @Nullable
    public Win32Registry.Hive.AppKey loadAppKey(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        WinReg.HKEYByReference result2 = new WinReg.HKEYByReference();
        int status2 = Advapi32.INSTANCE.RegLoadAppKey(file.toString(), result2, 131097, 0, 0);
        return status2 == 0 ? new Win32Registry.Hive.AppKey(Pointer.nativeValue((Pointer)result2.getValue().getPointer())) : null;
    }

    @Override
    public void closeKey(@NotNull Win32Registry.Hive.AppKey hkey) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        int status2 = Advapi32.INSTANCE.RegCloseKey(new WinReg.HKEY(Pointer.createConstant((long)hkey.getHkey())));
        if (status2 != 0) {
            Logger.INSTANCE.error("Failed to close private registry app key: " + status2);
        }
    }

    @Override
    @NotNull
    public AutoCloseable watchValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName, @NotNull Function1<? super String, Unit> callback2) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        return Win32Integration.INSTANCE.watchRegValue(hkey, subKey, valueName, callback2);
    }

    @Override
    @NotNull
    public AutoCloseable watchIntValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName, @NotNull Function1<? super Integer, Unit> callback2) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        return Win32Integration.INSTANCE.watchRegIntValue(hkey, subKey, valueName, callback2);
    }
}

