/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.common.platform.OS;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.jetbrains.annotations.NotNull;
import org.tinylog.Logger;

public interface NativeInteropLinux
extends Library {
    public static final NativeInteropLinux INSTANCE = NativeInteropLinux.createInstance();

    private static NativeInteropLinux createInstance() {
        if (OS.INSTANCE.isLinux()) {
            try {
                return (NativeInteropLinux)Native.load((String)"jetbrains-toolbox-interop", NativeInteropLinux.class);
            }
            catch (Throwable e) {
                Logger.warn((Throwable)e, (String)"Failed to load jetbrains-toolbox-interop lib, will use stubs");
                return NativeInteropLinux.createStub();
            }
        }
        return NativeInteropLinux.createStub();
    }

    @NotNull
    private static NativeInteropLinux createStub() {
        return new NativeInteropLinux(){

            @Override
            public Pointer getDisplay() {
                return Pointer.NULL;
            }

            @Override
            public void closeDisplay(Pointer display) {
            }

            @Override
            public void setWindowProperties(Pointer display, long window) {
            }

            @Override
            public void bringWindowToFront(Pointer display, long window) {
            }
        };
    }

    public Pointer getDisplay();

    public void closeDisplay(Pointer var1);

    public void setWindowProperties(Pointer var1, long var2);

    public void bringWindowToFront(Pointer var1, long var2);
}

