/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.common.platform.OS;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;

public final class JStackThreadDumperKt {
    @NotNull
    private static final Function1<ProcessHandle, String> DEFAULT_NAME_GENERATOR = JStackThreadDumperKt::DEFAULT_NAME_GENERATOR$lambda$0;

    private static final Path defaultJStackPath() {
        Path path2;
        String string = System.getProperty("java.home");
        if (string != null && (path2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)) != null) {
            Path it = path2;
            boolean bl = false;
            Path bin = it.resolve("bin");
            String extension2 = OS.INSTANCE.isWindows() ? ".exe" : "";
            return bin.resolve("jstack" + extension2);
        }
        return null;
    }

    private static final Path createTempDir(FileUtils fileUtils) {
        String timestamp2 = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
        return fileUtils.createTempDirectory("toolbox-freeze-" + timestamp2);
    }

    private static final String DEFAULT_NAME_GENERATOR$lambda$0(ProcessHandle processHandle) {
        Intrinsics.checkNotNullParameter((Object)processHandle, (String)"processHandle");
        String time2 = LocalTime.now().format(DateTimeFormatter.ofPattern("HH-mm-ss"));
        long pid = processHandle.pid();
        return pid + "_" + time2 + "_jstack";
    }

    public static final /* synthetic */ Path access$defaultJStackPath() {
        return JStackThreadDumperKt.defaultJStackPath();
    }

    public static final /* synthetic */ Path access$createTempDir(FileUtils fileUtils) {
        return JStackThreadDumperKt.createTempDir(fileUtils);
    }

    public static final /* synthetic */ Function1 access$getDEFAULT_NAME_GENERATOR$p() {
        return DEFAULT_NAME_GENERATOR;
    }
}

