/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.vmoptions;

import com.jetbrains.toolbox.intellij.vmoptions.VmOption;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.uuid.Uuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nIntellijVmOptionsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijVmOptionsEditor.kt\ncom/jetbrains/toolbox/intellij/vmoptions/IntellijVmOptionsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1208#2,2:107\n1236#2,4:109\n*S KotlinDebug\n*F\n+ 1 IntellijVmOptionsEditor.kt\ncom/jetbrains/toolbox/intellij/vmoptions/IntellijVmOptionsProvider\n*L\n21#1:107,2\n21#1:109,4\n*E\n"})
public class IntellijVmOptionsProvider
implements VmOptionsProvider {
    @NotNull
    private final Map<Key, VmOption> options;

    /*
     * WARNING - void declaration
     */
    public IntellijVmOptionsProvider(@NotNull List<? extends VmOption> options) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Iterable iterable = options;
        IntellijVmOptionsProvider intellijVmOptionsProvider = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            VmOption vmOption = (VmOption)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(this.getKey((VmOption)it), element$iv$iv);
        }
        intellijVmOptionsProvider.options = MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    @NotNull
    protected final Map<Key, VmOption> getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public List<VmOption> getOptions() {
        return CollectionsKt.toList((Iterable)this.options.values());
    }

    @Override
    @Nullable
    public VmOption.Xmx getXmx() {
        VmOption vmOption = this.options.get(Key.Xmx.INSTANCE);
        return vmOption instanceof VmOption.Xmx ? (VmOption.Xmx)vmOption : null;
    }

    @Override
    @Nullable
    public VmOption getSystemProperty(@NotNull String property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.options.get(new Key.System(this.getWithoutSystemPrefix(property)));
    }

    @NotNull
    protected final Key getKey(@NotNull VmOption $this$key) {
        Key key;
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        VmOption vmOption = $this$key;
        if (vmOption instanceof VmOption.Xmx) {
            key = Key.Xmx.INSTANCE;
        } else if (vmOption instanceof VmOption.GC) {
            key = Key.GC.INSTANCE;
        } else if (vmOption instanceof VmOption.System) {
            key = new Key.System(((VmOption.System)$this$key).getName());
        } else if (vmOption instanceof VmOption.Unknown) {
            key = StringsKt.startsWith$default((String)$this$key.getValue(), (String)"#", (boolean)false, (int)2, null) ? (Key)new Key.Comment(null, 1, null) : (Key)new Key.Unknown($this$key.getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return key;
    }

    @NotNull
    protected final String getWithoutSystemPrefix(@NotNull String $this$withoutSystemPrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$withoutSystemPrefix, (String)"<this>");
        return StringsKt.removePrefix((String)$this$withoutSystemPrefix, (CharSequence)"-D");
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.options.values(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    protected static sealed interface Key {

        public static final class Comment
        implements Key {
            @NotNull
            private final String id;

            public Comment(@NotNull String id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.id = id;
            }

            public /* synthetic */ Comment(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = Uuid.Companion.random().toString();
                }
                this(string);
            }

            @NotNull
            public String toString() {
                return "Comment(id=" + this.id + ")";
            }

            public int hashCode() {
                return this.id.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Comment)) {
                    return false;
                }
                Comment comment = (Comment)other;
                return Intrinsics.areEqual((Object)this.id, (Object)comment.id);
            }

            public Comment() {
                this(null, 1, null);
            }
        }

        public static final class GC
        implements Key {
            @NotNull
            public static final GC INSTANCE = new GC();

            private GC() {
            }

            @NotNull
            public String toString() {
                return "GC";
            }

            public int hashCode() {
                return -959438986;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GC)) {
                    return false;
                }
                GC cfr_ignored_0 = (GC)other;
                return true;
            }
        }

        public static final class System
        implements Key {
            @NotNull
            private final String name;

            public System(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                this.name = name2;
            }

            @NotNull
            public String toString() {
                return "System(name=" + this.name + ")";
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof System)) {
                    return false;
                }
                System system = (System)other;
                return Intrinsics.areEqual((Object)this.name, (Object)system.name);
            }
        }

        public static final class Unknown
        implements Key {
            @NotNull
            private final String value;

            public Unknown(@NotNull String value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.value = value2;
            }

            @NotNull
            public String toString() {
                return "Unknown(value=" + this.value + ")";
            }

            public int hashCode() {
                return this.value.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unknown)) {
                    return false;
                }
                Unknown unknown = (Unknown)other;
                return Intrinsics.areEqual((Object)this.value, (Object)unknown.value);
            }
        }

        public static final class Xmx
        implements Key {
            @NotNull
            public static final Xmx INSTANCE = new Xmx();

            private Xmx() {
            }

            @NotNull
            public String toString() {
                return "Xmx";
            }

            public int hashCode() {
                return 322180265;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Xmx)) {
                    return false;
                }
                Xmx cfr_ignored_0 = (Xmx)other;
                return true;
            }
        }
    }
}

