/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.plugins;

import com.jetbrains.toolbox.intellij.plugins.VSCodeCliRunner;
import com.jetbrains.toolbox.intellij.plugins.VSCodeCommand;
import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.tools.ExtensionsKt;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.launcher.ProcessParameters;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.Function;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nVSCodeCliRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSCodeCliRunner.kt\ncom/jetbrains/toolbox/intellij/plugins/VSCodeCliRunnerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class VSCodeCliRunnerImpl
implements VSCodeCliRunner {
    @NotNull
    private final ProcessLauncher processLauncher;

    public VSCodeCliRunnerImpl(@NotNull ProcessLauncher processLauncher) {
        Intrinsics.checkNotNullParameter((Object)processLauncher, (String)"processLauncher");
        this.processLauncher = processLauncher;
    }

    @Override
    public boolean runVSCodeCLICommand(@NotNull ToolInstance toolInstance, @NotNull VSCodeCommand command2, @NotNull ProcessOutputHandler outputHandler) {
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)outputHandler, (String)"outputHandler");
        StringBuilder stderr = new StringBuilder();
        Function1 function1 = (Function1)new Function1<String, Unit>((Object)stderr){

            public final void invoke(String p0) {
                ((StringBuilder)this.receiver).append(p0);
            }
        };
        ProcessParameters params2 = new ProcessParameters(command2.getArgs(), true, false, null, null, outputHandler, new ProcessOutputHandler.ReadLineByLine(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void read(String line) {
                this.function.invoke((Object)line);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ProcessOutputHandler.ReadLineByLine ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 28, null);
        Path cliCommand = ExtensionsKt.getLaunchCommand(toolInstance);
        if (cliCommand != null) {
            String optError;
            String string;
            this.processLauncher.executeProcess(cliCommand, params2);
            String it = string = stderr.toString();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string2 = optError = ((CharSequence)it).length() > 0 ? string : null;
            if (optError != null) {
                Logger.INSTANCE.warn(StringsKt.trimMargin$default((String)("Failed to " + command2.getName() + ", error:\n        |" + optError), null, (int)1, null));
                return false;
            }
            return true;
        }
        return false;
    }
}

