/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.notifications;

import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.intellij.notifications.IntelliJApiNotification;
import com.jetbrains.toolbox.intellij.notifications.IntelliJNotification;
import com.jetbrains.toolbox.intellij.notifications.IntelliJNotificationApiResponse;
import com.jetbrains.toolbox.intellij.notifications.NotificationPayload;
import com.jetbrains.toolbox.intellij.notifications.Update;
import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.launcher.ToolParameters;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class IntelliJUpdatePendingNotification
implements IntelliJNotification {
    @NotNull
    private final ToolInstance toolInstance;
    @NotNull
    private final String channelId;
    @NotNull
    private final ToolBuild build;
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final ProcessLauncher processLauncher;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final ProcessRunner processes;
    @NotNull
    private final CoroutineScope coroutineScope;

    private IntelliJUpdatePendingNotification(ToolInstance toolInstance, String channelId, ToolBuild build2, ToolManager toolManager, ProcessLauncher processLauncher, StatisticsManager statisticsManager, ProcessRunner processes, CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)processLauncher, (String)"processLauncher");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        Intrinsics.checkNotNullParameter((Object)processes, (String)"processes");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.toolInstance = toolInstance;
        this.channelId = channelId;
        this.build = build2;
        this.toolManager = toolManager;
        this.processLauncher = processLauncher;
        this.statisticsManager = statisticsManager;
        this.processes = processes;
        this.coroutineScope = coroutineScope;
    }

    @Override
    @NotNull
    public ToolInstance getToolInstance() {
        return this.toolInstance;
    }

    @Override
    @NotNull
    public String getApiPath() {
        return "restart-notification";
    }

    @Override
    @NotNull
    public IntelliJApiNotification toApiNotification() {
        String buildNumber = this.build.getBuild().getId-Y_E1uuk();
        String versionName = this.build.getVersion().getName();
        return new IntelliJApiNotification(buildNumber, versionName, new NotificationPayload(null, null, false, new Update(buildNumber, versionName, null), 7, null), null);
    }

    @Override
    public void handle(@NotNull IntelliJNotificationApiResponse response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        if (!Intrinsics.areEqual((Object)response2.getStatus(), (Object)"accepted")) {
            Logger.INSTANCE.info("Restart of " + this.getToolInstance().getChannel().getInstallationDirectory() + " declined from IDE");
            return;
        }
        this.statisticsManager.getLogger().logVararg(Fus.Counters.IdeIntegration.INSTANCE.getNotification(), arg_0 -> IntelliJUpdatePendingNotification.handle$lambda$0(this, arg_0));
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(response2, this, null){
            int label;
            final /* synthetic */ IntelliJNotificationApiResponse $response;
            final /* synthetic */ IntelliJUpdatePendingNotification this$0;
            {
                this.$response = $response;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block7: {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Logger.INSTANCE.info("Waiting for " + this.$response.getPid() + " to exit and finishing update for " + this.this$0.getToolInstance().getChannel().getInstallationDirectory());
                            IntelliJUpdatePendingNotification.access$getProcesses$p(this.this$0).waitForPid-CxHxETo(Pid.constructor-impl(this.$response.getPid()), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), false);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            IntelliJUpdatePendingNotification.access$getToolManager$p(this.this$0).update-CH08qv8(IntelliJUpdatePendingNotification.access$getChannelId$p(this.this$0));
                            v1 = IntelliJUpdatePendingNotification.access$getToolManager$p(this.this$0).getChannelState().get(ChannelId.box-impl(IntelliJUpdatePendingNotification.access$getChannelId$p(this.this$0)));
                            if (v1 == null || (v1 = FlowKt.takeWhile((Flow)v1, (Function2)((Function2)new Function2<ChannelState, Continuation<? super Boolean>, Object>(null){
                                int label;
                                /* synthetic */ Object L$0;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    ChannelState channelState2 = (ChannelState)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void it;
                                            ResultKt.throwOnFailure((Object)$result);
                                            return Boxing.boxBoolean((!(it instanceof ChannelState.Idle) ? 1 : 0) != 0);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(ChannelState p1, Continuation<? super Boolean> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }))) == null) break;
                            this.label = 2;
                            v2 = FlowKt.collect((Flow)v1, (Continuation)((Continuation)this));
                            if (v2 == var2_2) {
                                return var2_2;
                            }
                            break block7;
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            break block7;
                        }
                    }
                    return Unit.INSTANCE;
                }
                ProcessLauncher.launch$default(IntelliJUpdatePendingNotification.access$getProcessLauncher$p(this.this$0), ToolParameters.Companion.of(this.this$0.getToolInstance()), null, 2, null);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final Unit handle$lambda$0(IntelliJUpdatePendingNotification this$0, FusFieldDescriptions.Notification $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction("restart");
        $this$logVararg.setTool-sDA0F08(this$0.getToolInstance().getTool().getToolId-UtVBrGo());
        $this$logVararg.setFrom-7xp1vhg(this$0.getToolInstance().getTool().getBuildNumber-Y_E1uuk());
        $this$logVararg.setTo-7xp1vhg(this$0.build.getBuild().getId-Y_E1uuk());
        return Unit.INSTANCE;
    }

    public /* synthetic */ IntelliJUpdatePendingNotification(ToolInstance toolInstance, String channelId, ToolBuild build2, ToolManager toolManager, ProcessLauncher processLauncher, StatisticsManager statisticsManager, ProcessRunner processes, CoroutineScope coroutineScope, DefaultConstructorMarker $constructor_marker) {
        this(toolInstance, channelId, build2, toolManager, processLauncher, statisticsManager, processes, coroutineScope);
    }

    public static final /* synthetic */ ProcessRunner access$getProcesses$p(IntelliJUpdatePendingNotification $this) {
        return $this.processes;
    }

    public static final /* synthetic */ ToolManager access$getToolManager$p(IntelliJUpdatePendingNotification $this) {
        return $this.toolManager;
    }

    public static final /* synthetic */ String access$getChannelId$p(IntelliJUpdatePendingNotification $this) {
        return $this.channelId;
    }

    public static final /* synthetic */ ProcessLauncher access$getProcessLauncher$p(IntelliJUpdatePendingNotification $this) {
        return $this.processLauncher;
    }
}

