/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.notifications;

import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.intellij.notifications.IntelliJApiNotification;
import com.jetbrains.toolbox.intellij.notifications.IntelliJNotification;
import com.jetbrains.toolbox.intellij.notifications.IntelliJNotificationApiResponse;
import com.jetbrains.toolbox.intellij.notifications.NotificationPayload;
import com.jetbrains.toolbox.intellij.notifications.Update;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class IntelliJUpdateAvailableNotification
implements IntelliJNotification {
    @NotNull
    private final ToolInstance toolInstance;
    @NotNull
    private final String channelId;
    @NotNull
    private final ToolBuild build;
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final StatisticsManager statisticsManager;

    private IntelliJUpdateAvailableNotification(ToolInstance toolInstance, String channelId, ToolBuild build2, ToolManager toolManager, StatisticsManager statisticsManager) {
        Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        this.toolInstance = toolInstance;
        this.channelId = channelId;
        this.build = build2;
        this.toolManager = toolManager;
        this.statisticsManager = statisticsManager;
    }

    @Override
    @NotNull
    public ToolInstance getToolInstance() {
        return this.toolInstance;
    }

    @Override
    @NotNull
    public String getApiPath() {
        return "update-notification";
    }

    @Override
    @NotNull
    public IntelliJApiNotification toApiNotification() {
        String buildNumber = this.build.getBuild().getId-Y_E1uuk();
        String versionName = this.build.getVersion().getName();
        return new IntelliJApiNotification(buildNumber, versionName, new NotificationPayload(null, null, false, new Update(buildNumber, versionName, null), 7, null), null);
    }

    @Override
    public void handle(@NotNull IntelliJNotificationApiResponse response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        if (!Intrinsics.areEqual((Object)response2.getStatus(), (Object)"accepted")) {
            Logger.INSTANCE.info("Update of " + this.getToolInstance().getChannel().getInstallationDirectory() + " declined from IDE");
            return;
        }
        this.statisticsManager.getLogger().logVararg(Fus.Counters.IdeIntegration.INSTANCE.getNotification(), arg_0 -> IntelliJUpdateAvailableNotification.handle$lambda$0(this, arg_0));
        Logger.INSTANCE.info("Starting update of " + this.getToolInstance().getChannel().getInstallationDirectory() + " after confirmation from IDE");
        this.toolManager.update-CH08qv8(this.channelId);
    }

    private static final Unit handle$lambda$0(IntelliJUpdateAvailableNotification this$0, FusFieldDescriptions.Notification $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setAction("update");
        $this$logVararg.setTool-sDA0F08(this$0.getToolInstance().getTool().getToolId-UtVBrGo());
        $this$logVararg.setFrom-7xp1vhg(this$0.getToolInstance().getTool().getBuildNumber-Y_E1uuk());
        $this$logVararg.setTo-7xp1vhg(this$0.build.getBuild().getId-Y_E1uuk());
        return Unit.INSTANCE;
    }

    public /* synthetic */ IntelliJUpdateAvailableNotification(ToolInstance toolInstance, String channelId, ToolBuild build2, ToolManager toolManager, StatisticsManager statisticsManager, DefaultConstructorMarker $constructor_marker) {
        this(toolInstance, channelId, build2, toolManager, statisticsManager);
    }
}

