/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij;

import com.jetbrains.toolbox.i18n.UIRegion;
import com.jetbrains.toolbox.intellij.JavaPreferences;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

public final class IntellijPreferenceManager {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<UIRegion> _region;
    @NotNull
    private final StateFlow<UIRegion> region;

    public IntellijPreferenceManager(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this._region = StateFlowKt.MutableStateFlow((Object)((Object)UIRegion.NOT_SPECIFIED));
        this.region = FlowKt.asStateFlow(this._region);
        this.doRefreshRegion();
    }

    @NotNull
    public final StateFlow<UIRegion> getRegion() {
        return this.region;
    }

    public final void setIntelliJUserId(@NotNull String accountUid, @NotNull String idToken) {
        Intrinsics.checkNotNullParameter((Object)accountUid, (String)"accountUid");
        Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
        JavaPreferences.INSTANCE.writeEncodedJavaPreference(JavaPreferences.INSTANCE.getUserIdKeyName(), accountUid);
        JavaPreferences.INSTANCE.writeEncodedJavaPreference(JavaPreferences.INSTANCE.getIdTokenKeyName(), idToken);
    }

    public final void removeIntelliJUserId() {
        JavaPreferences.INSTANCE.removeEncodedJavaPreference(JavaPreferences.INSTANCE.getUserIdKeyName());
        JavaPreferences.INSTANCE.removeEncodedJavaPreference(JavaPreferences.INSTANCE.getIdTokenKeyName());
    }

    public final void updateRegion(@NotNull UIRegion region) {
        Intrinsics.checkNotNullParameter((Object)((Object)region), (String)"region");
        this._region.setValue((Object)region);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, region, null){
            int label;
            final /* synthetic */ IntellijPreferenceManager this$0;
            final /* synthetic */ UIRegion $region;
            {
                this.this$0 = $receiver;
                this.$region = $region;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        IntellijPreferenceManager.access$writeRegion(this.this$0, this.$region);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void refreshRegion() {
        this.doRefreshRegion();
    }

    private final void doRefreshRegion() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ IntellijPreferenceManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        IntellijPreferenceManager.access$get_region$p(this.this$0).setValue((Object)((Object)IntellijPreferenceManager.access$readRegion(this.this$0)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final UIRegion readRegion() {
        return UIRegion.Companion.fromCode(JavaPreferences.INSTANCE.read("region", "code"));
    }

    private final void writeRegion(UIRegion region) {
        if (region == UIRegion.NOT_SPECIFIED) {
            JavaPreferences.INSTANCE.remove("region", "code");
        } else {
            JavaPreferences.INSTANCE.write("region", "code", region.getRegionCode());
        }
    }

    public static final /* synthetic */ void access$writeRegion(IntellijPreferenceManager $this, UIRegion region) {
        $this.writeRegion(region);
    }

    public static final /* synthetic */ MutableStateFlow access$get_region$p(IntellijPreferenceManager $this) {
        return $this._region;
    }

    public static final /* synthetic */ UIRegion access$readRegion(IntellijPreferenceManager $this) {
        return $this.readRegion();
    }
}

