/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij;

import com.jetbrains.toolbox.intellij.IntelliJChannelExtension;
import com.jetbrains.toolbox.intellij.UtilKt;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolUninstallHandler;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class IntelliJUninstallHandler
implements ToolUninstallHandler {
    @NotNull
    private final FileSystem fileSystem;

    public IntelliJUninstallHandler(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @Nullable
    public Object onUninstall(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super UninstallResult> $completion) {
        Path vmoptionsPath;
        IntelliJChannelExtension intelliJChannelExtension = UtilKt.getIntellij(toolInstance.getChannel());
        boolean bl = intelliJChannelExtension != null ? !intelliJChannelExtension.getDefaultVmOptionsLocation() : false;
        if (bl && (vmoptionsPath = com.jetbrains.toolbox.intellij.vmoptions.UtilKt.getVmoptionsPath(toolInstance)) != null) {
            Logger.INSTANCE.info("Removing custom .vmoptions: " + vmoptionsPath);
            this.fileSystem.delete(vmoptionsPath);
            return UninstallResult.Success.INSTANCE;
        }
        return UninstallResult.NotSupported.INSTANCE;
    }
}

