/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.accounts.AccountManager;
import com.jetbrains.toolbox.accounts.AccountManagerKt;
import com.jetbrains.toolbox.accounts.JetBrainsAccount;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.intellij.IntelliJSplitModeHelper;
import com.jetbrains.toolbox.intellij.IntelliJToolExtensionKt;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.EphemeralTool;
import com.jetbrains.toolbox.tools.provider.AvailableToolsFacade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nIntelliJSplitModeHelperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJSplitModeHelperImpl.kt\ncom/jetbrains/toolbox/intellij/IntelliJSplitModeHelperImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n827#2:46\n855#2,2:47\n*S KotlinDebug\n*F\n+ 1 IntelliJSplitModeHelperImpl.kt\ncom/jetbrains/toolbox/intellij/IntelliJSplitModeHelperImpl\n*L\n43#1:46\n43#1:47,2\n*E\n"})
public final class IntelliJSplitModeHelperImpl
implements IntelliJSplitModeHelper {
    @NotNull
    private final AccountManager accountManager;
    @NotNull
    private final String argName;
    @NotNull
    private final StateFlow<Map<ApplicationType, Boolean>> supportsRemoteDev;

    public IntelliJSplitModeHelperImpl(@NotNull AccountManager accountManager, @NotNull AvailableToolsFacade availableTools2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)accountManager, (String)"accountManager");
        Intrinsics.checkNotNullParameter((Object)availableTools2, (String)"availableTools");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.accountManager = accountManager;
        this.argName = "splitMode";
        this.supportsRemoteDev = availableTools2.getTools().observerRemoteDevStatus();
    }

    @Override
    @Nullable
    public Boolean getSplitModeState(@NotNull Channel channel, @NotNull EphemeralTool tool) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        if (!this.isSplitModeAvailable(tool)) {
            return null;
        }
        return channel.getLaunchArguments().contains(this.argName);
    }

    @Override
    @NotNull
    public Channel setSplitModeState(@NotNull Channel channel, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return state2 ? Channel.copy$default(channel, null, null, null, false, null, false, CollectionsKt.plus((Collection)this.getWithoutSplitMode(channel.getLaunchArguments()), (Object)this.argName), false, null, null, null, false, 4031, null) : Channel.copy$default(channel, null, null, null, false, null, false, this.getWithoutSplitMode(channel.getLaunchArguments()), false, null, null, null, false, 4031, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSplitModeAvailable(EphemeralTool $this$isSplitModeAvailable) {
        JetBrainsAccount jetBrainsAccount2 = (JetBrainsAccount)AccountManagerKt.getJba(this.accountManager).getActiveAccount().getValue();
        if (jetBrainsAccount2 == null) return false;
        boolean bl = jetBrainsAccount2.isInternal();
        boolean isInternalAccount = bl;
        if (!isInternalAccount) return false;
        if (IntelliJToolExtensionKt.getIntellijExtension($this$isSplitModeAvailable) == null) return false;
        if (BuildNumber.compareTo-Szkhn3Q($this$isSplitModeAvailable.getBuildNumber-Y_E1uuk(), BuildNumber.constructor-impl("233")) <= 0) return false;
        Boolean bl2 = (Boolean)((Map)this.supportsRemoteDev.getValue()).get(ApplicationType.box-impl($this$isSplitModeAvailable.getToolId-UtVBrGo()));
        if (bl2 == null) return false;
        boolean bl3 = bl2;
        if (!bl3) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getWithoutSplitMode(List<String> $this$withoutSplitMode) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = $this$withoutSplitMode;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)this.argName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

