/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.installCommands;

import com.jetbrains.toolbox.installCommands.InstallCommandFactoryKt;
import com.jetbrains.toolbox.installCommands.InstallCommands;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class InstallCommandFactory {
    @NotNull
    private final Json json = JsonKt.Json$default(null, InstallCommandFactory::json$lambda$0, (int)1, null);

    @Nullable
    public final InstallCommands create(@NotNull String commandBase64) {
        Intrinsics.checkNotNullParameter((Object)commandBase64, (String)"commandBase64");
        try {
            Logger.INSTANCE.info("Decoding install command: " + commandBase64);
            InstallCommands decodedCommand = InstallCommands.Companion.decode(commandBase64, (Function1<? super byte[], ? extends Map<String, ? extends Object>>)((Function1)arg_0 -> InstallCommandFactory.create$lambda$0(this, arg_0)));
            Logger.INSTANCE.info("Decoded install command: " + decodedCommand);
            return decodedCommand;
        }
        catch (Throwable e) {
            Logger.INSTANCE.warn(e, "Failed to decode install command");
            return null;
        }
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setExplicitNulls(false);
        return Unit.INSTANCE;
    }

    private static final Map create$lambda$0(InstallCommandFactory this$0, byte[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = InstallCommandFactoryKt.getExtractedContent(this$0.json.parseToJsonElement(StringsKt.decodeToString((byte[])it)));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map result2 = (Map)object;
        return result2;
    }
}

