/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.installCommands;

import com.jetbrains.toolbox.installCommands.InstallCommandCoder;
import com.jetbrains.toolbox.installCommands.ToolInstallDescriptor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class InstallCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean needsSignatureCheck;

    private InstallCommand() {
        this.needsSignatureCheck = true;
    }

    public boolean getNeedsSignatureCheck() {
        return this.needsSignatureCheck;
    }

    public /* synthetic */ InstallCommand(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class DownloadToolsCommand
    extends InstallCommand {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<ToolInstallDescriptor> tools;
        private final boolean needsSignatureCheck;
        @NotNull
        private static final InstallCommandCoder<DownloadToolsCommand> coder = new InstallCommandCoder<DownloadToolsCommand>(){
            private final String commandId;
            private final String toolsKey;
            {
                this.commandId = "dt";
                this.toolsKey = "t";
            }

            public String getCommandId() {
                return this.commandId;
            }

            /*
             * WARNING - void declaration
             */
            public DownloadToolsCommand decode(Map<String, ? extends Object> command2) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(command2, (String)"command");
                Object object = command2.get(this.toolsKey);
                if (object == null) {
                    throw new IllegalStateException("failed to parse session url".toString());
                }
                List toolsList = (List)object;
                Iterable $this$map$iv = toolsList;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    T item$iv$iv;
                    T t2 = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    collection.add(ToolInstallDescriptor.Companion.fromMap((Map)it));
                }
                List tools2 = (List)destination$iv$iv;
                return new DownloadToolsCommand(tools2);
            }
        };

        public DownloadToolsCommand(@NotNull List<ToolInstallDescriptor> tools2) {
            Intrinsics.checkNotNullParameter(tools2, (String)"tools");
            super(null);
            this.tools = tools2;
        }

        @Override
        public boolean getNeedsSignatureCheck() {
            return this.needsSignatureCheck;
        }

        @NotNull
        public String toString() {
            return "DownloadToolsCommand(tools=" + this.tools + ")";
        }

        public int hashCode() {
            return ((Object)this.tools).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DownloadToolsCommand)) {
                return false;
            }
            DownloadToolsCommand downloadToolsCommand = (DownloadToolsCommand)other;
            return Intrinsics.areEqual(this.tools, downloadToolsCommand.tools);
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final InstallCommandCoder<DownloadToolsCommand> getCoder$install_commands() {
                return coder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    public static final class JoinCwmInTbe
    extends InstallCommand {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final URL machineConfigUrl;
        @NotNull
        private final String sessionId;
        private final boolean needsSignatureCheck;
        @NotNull
        private static final InstallCommandCoder<JoinCwmInTbe> coder = new InstallCommandCoder<JoinCwmInTbe>(){
            private final String commandId;
            private final String machineConfigUrlKey;
            private final String sessionIdKey;
            {
                this.commandId = "jcit";
                this.machineConfigUrlKey = "mc";
                this.sessionIdKey = "sid";
            }

            public String getCommandId() {
                return this.commandId;
            }

            public JoinCwmInTbe decode(Map<String, ? extends Object> command2) {
                Intrinsics.checkNotNullParameter(command2, (String)"command");
                Object object = command2.get(this.machineConfigUrlKey);
                if (object == null) {
                    throw new IllegalStateException("failed to parse machine config url".toString());
                }
                String machineConfig = (String)object;
                Object object2 = command2.get(this.sessionIdKey);
                if (object2 == null) {
                    throw new IllegalStateException("failed to parse session ID".toString());
                }
                String sessionId = (String)object2;
                return new JoinCwmInTbe(new URL(machineConfig), sessionId);
            }
        };

        public JoinCwmInTbe(@NotNull URL machineConfigUrl, @NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)machineConfigUrl, (String)"machineConfigUrl");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            super(null);
            this.machineConfigUrl = machineConfigUrl;
            this.sessionId = sessionId;
        }

        @NotNull
        public final URL getMachineConfigUrl() {
            return this.machineConfigUrl;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public boolean getNeedsSignatureCheck() {
            return this.needsSignatureCheck;
        }

        @NotNull
        public String toString() {
            return "JoinCwmInTbe(machineConfigUrl=" + this.machineConfigUrl + ", sessionId=" + this.sessionId + ")";
        }

        public int hashCode() {
            int result2 = this.machineConfigUrl.hashCode();
            result2 = result2 * 31 + this.sessionId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JoinCwmInTbe)) {
                return false;
            }
            JoinCwmInTbe joinCwmInTbe = (JoinCwmInTbe)other;
            if (!Intrinsics.areEqual((Object)this.machineConfigUrl, (Object)joinCwmInTbe.machineConfigUrl)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sessionId, (Object)joinCwmInTbe.sessionId);
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final InstallCommandCoder<JoinCwmInTbe> getCoder$install_commands() {
                return coder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    public static final class JoinPublicCwm
    extends InstallCommand {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final URI sessionURL;
        private final boolean needsSignatureCheck;
        @NotNull
        private static final InstallCommandCoder<JoinPublicCwm> coder = new InstallCommandCoder<JoinPublicCwm>(){
            private final String commandId;
            private final String sessionUrlKey;
            {
                this.commandId = "jpc";
                this.sessionUrlKey = "surl";
            }

            public String getCommandId() {
                return this.commandId;
            }

            public JoinPublicCwm decode(Map<String, ? extends Object> command2) {
                Intrinsics.checkNotNullParameter(command2, (String)"command");
                Object object = command2.get(this.sessionUrlKey);
                if (object == null) {
                    throw new IllegalStateException("failed to parse session url".toString());
                }
                String sessionUrl = (String)object;
                return new JoinPublicCwm(new URI(sessionUrl));
            }
        };

        public JoinPublicCwm(@NotNull URI sessionURL) {
            Intrinsics.checkNotNullParameter((Object)sessionURL, (String)"sessionURL");
            super(null);
            this.sessionURL = sessionURL;
        }

        @NotNull
        public final URI getSessionURL() {
            return this.sessionURL;
        }

        @Override
        public boolean getNeedsSignatureCheck() {
            return this.needsSignatureCheck;
        }

        @NotNull
        public String toString() {
            return "JoinPublicCwm(sessionURL=" + this.sessionURL + ")";
        }

        public int hashCode() {
            return this.sessionURL.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JoinPublicCwm)) {
                return false;
            }
            JoinPublicCwm joinPublicCwm = (JoinPublicCwm)other;
            return Intrinsics.areEqual((Object)this.sessionURL, (Object)joinPublicCwm.sessionURL);
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final InstallCommandCoder<JoinPublicCwm> getCoder$install_commands() {
                return coder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    public static final class JoinTbe
    extends InstallCommand {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final URL machineConfigUrl;
        private final boolean needsSignatureCheck;
        @NotNull
        private static final InstallCommandCoder<JoinTbe> coder = new InstallCommandCoder<JoinTbe>(){
            private final String commandId;
            private final String machineConfigUrlKey;
            {
                this.commandId = "jt";
                this.machineConfigUrlKey = "mc";
            }

            public String getCommandId() {
                return this.commandId;
            }

            public JoinTbe decode(Map<String, ? extends Object> command2) {
                Intrinsics.checkNotNullParameter(command2, (String)"command");
                Object object = command2.get(this.machineConfigUrlKey);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                return new JoinTbe(new URL((String)object));
            }
        };

        public JoinTbe(@NotNull URL machineConfigUrl) {
            Intrinsics.checkNotNullParameter((Object)machineConfigUrl, (String)"machineConfigUrl");
            super(null);
            this.machineConfigUrl = machineConfigUrl;
        }

        @NotNull
        public final URL getMachineConfigUrl() {
            return this.machineConfigUrl;
        }

        @Override
        public boolean getNeedsSignatureCheck() {
            return this.needsSignatureCheck;
        }

        @NotNull
        public String toString() {
            return "JoinTbe(machineConfigUrl=" + this.machineConfigUrl + ")";
        }

        public int hashCode() {
            return this.machineConfigUrl.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JoinTbe)) {
                return false;
            }
            JoinTbe joinTbe2 = (JoinTbe)other;
            return Intrinsics.areEqual((Object)this.machineConfigUrl, (Object)joinTbe2.machineConfigUrl);
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final InstallCommandCoder<JoinTbe> getCoder$install_commands() {
                return coder;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

