/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.i18n.gettext;

import com.jetbrains.toolbox.i18n.gettext.PluralRuleExpression;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TernaryExpression
implements PluralRuleExpression {
    @NotNull
    private final PluralRuleExpression condition;
    @NotNull
    private final PluralRuleExpression left;
    @NotNull
    private final PluralRuleExpression right;

    public TernaryExpression(@NotNull PluralRuleExpression condition, @NotNull PluralRuleExpression left, @NotNull PluralRuleExpression right) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.condition = condition;
        this.left = left;
        this.right = right;
    }

    @Override
    public int evaluate(int n) {
        return this.condition.evaluate(n) != 0 ? this.left.evaluate(n) : this.right.evaluate(n);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TernaryExpression)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.condition, (Object)((TernaryExpression)other).condition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.left, (Object)((TernaryExpression)other).left)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.right, (Object)((TernaryExpression)other).right);
    }

    public int hashCode() {
        int result2 = this.condition.hashCode();
        result2 = 31 * result2 + this.left.hashCode();
        result2 = 31 * result2 + this.right.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.condition + " ? " + this.left + " : " + this.right;
    }
}

