/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.i18n.gettext;

import com.jetbrains.toolbox.i18n.gettext.PluralRuleExpression;
import com.jetbrains.toolbox.i18n.gettext.PluralRuleKt;
import com.jetbrains.toolbox.i18n.gettext.PoEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PoData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, PoEntry> strings;
    @NotNull
    private final PluralRuleExpression pluralRule;
    private static final char CONTEXT_DELIMITER = (char)4;

    public PoData(@NotNull Map<String, PoEntry> strings, @NotNull PluralRuleExpression pluralRule) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)pluralRule, (String)"pluralRule");
        this.strings = strings;
        this.pluralRule = pluralRule;
    }

    @Nullable
    public final String get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PoEntry poEntry = this.strings.get(id);
        return poEntry != null ? poEntry.getStr() : null;
    }

    @Nullable
    public final String get(@NotNull String id, int n) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PoEntry poEntry = this.strings.get(id);
        if (poEntry == null) {
            return null;
        }
        PoEntry entry = poEntry;
        int n2 = this.pluralRule.evaluate(n);
        if (0 <= n2 && n2 < entry.getCases().length) {
            return entry.getCases()[n2];
        }
        return entry.getPlural();
    }

    @SourceDebugExtension(value={"SMAP\nPoData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoData.kt\ncom/jetbrains/toolbox/i18n/gettext/PoData$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,145:1\n1#2:146\n37#3,2:147\n*S KotlinDebug\n*F\n+ 1 PoData.kt\ncom/jetbrains/toolbox/i18n/gettext/PoData$Companion\n*L\n139#1:147,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final char getCONTEXT_DELIMITER() {
            return CONTEXT_DELIMITER;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final PoData read(@NotNull Source input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Map entries2 = new LinkedHashMap();
            String pluralRule = "";
            Object context2 = null;
            Object id = null;
            Object str = "";
            Object plural = null;
            List cases = new ArrayList();
            Key key = Key.Unknown;
            try (BufferedSource bufferedReader = Okio.buffer((Source)input);){
                block10: while (bufferedReader.readUtf8Line() != null) {
                    Object object;
                    String rawLine;
                    String line = StringsKt.replace$default((String)rawLine, (String)"\\n", (String)"\n", (boolean)false, (int)4, null);
                    if (StringsKt.isBlank((CharSequence)line)) {
                        this.entry(entries2, (String)context2, (String)id, (String)str, (String)plural, cases);
                        context2 = null;
                        id = null;
                        str = "";
                        plural = null;
                        cases = new ArrayList();
                        key = Key.Unknown;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)line, (String)"msgctxt ", (boolean)false, (int)2, null)) {
                        context2 = this.unescape(StringsKt.substringAfter$default((String)line, (String)"msgctxt ", null, (int)2, null));
                        key = Key.Context;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)line, (String)"msgid ", (boolean)false, (int)2, null)) {
                        id = this.unescape(StringsKt.substringAfter$default((String)line, (String)"msgid ", null, (int)2, null));
                        key = Key.Id;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)line, (String)"msgid_plural ", (boolean)false, (int)2, null)) {
                        plural = this.unescape(StringsKt.substringAfter$default((String)line, (String)"msgid_plural ", null, (int)2, null));
                        key = Key.Plural;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)line, (String)"msgstr ", (boolean)false, (int)2, null)) {
                        str = this.unescape(StringsKt.substringAfter$default((String)line, (String)"msgstr ", null, (int)2, null));
                        key = Key.Str;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)line, (String)"msgstr[", (boolean)false, (int)2, null)) {
                        Object object2;
                        Collection collection = cases;
                        object = this.unescape(StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)line, (String)"msgstr[", null, (int)2, null), (String)"] ", null, (int)2, null));
                        if (object.length() == 0) {
                            boolean bl = false;
                            object2 = null;
                        } else {
                            object2 = object;
                        }
                        object = object2;
                        collection.add(object);
                        key = Key.Cases;
                        continue;
                    }
                    object = new char[]{'\"'};
                    String trimmed = StringsKt.trim((String)line, (char[])object);
                    String string = id;
                    boolean bl = string != null ? ((CharSequence)string).length() == 0 : false;
                    if (bl && key == Key.Str && StringsKt.startsWith$default((String)trimmed, (String)"Plural-Forms:", (boolean)false, (int)2, null)) {
                        pluralRule = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)trimmed, (String)"plural=", null, (int)2, null), (char)';', null, (int)2, null);
                        continue;
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[key.ordinal()]) {
                        case 1: {
                            context2 = (String)context2 + trimmed;
                            continue block10;
                        }
                        case 2: {
                            id = (String)id + trimmed;
                            continue block10;
                        }
                        case 3: {
                            str = (String)str + trimmed;
                            continue block10;
                        }
                        case 4: {
                            plural = (String)plural + trimmed;
                            continue block10;
                        }
                        case 5: {
                            if (!(!((Collection)cases).isEmpty())) continue block10;
                            List list2 = cases;
                            int n = cases.size() - 1;
                            list2.set(n, list2.get(n) + trimmed);
                        }
                    }
                }
                this.entry(entries2, (String)context2, (String)id, (String)str, (String)plural, cases);
            }
            return new PoData(entries2, PluralRuleKt.PluralRule(pluralRule));
        }

        private final String unescape(String $this$unescape) {
            String string;
            String trimmed = ((Object)StringsKt.trim((CharSequence)$this$unescape)).toString();
            if (StringsKt.startsWith$default((CharSequence)trimmed, (char)'\"', (boolean)false, (int)2, null)) {
                String string2 = trimmed.substring(1, StringsKt.getLastIndex((CharSequence)trimmed));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = trimmed;
            }
            String unquoted = string;
            return StringsKt.replace$default((String)StringsKt.replace$default((String)unquoted, (String)"\\\"", (String)"\"", (boolean)false, (int)4, null), (String)"\\n", (String)"\n", (boolean)false, (int)4, null);
        }

        private final void entry(Map<String, PoEntry> entries2, String context2, String id, String str, String plural, List<String> cases) {
            Object object = id;
            if (!(object == null || object.length() == 0) && (((CharSequence)str).length() > 0 || !((Collection)cases).isEmpty())) {
                object = entries2;
                String string = context2;
                String string2 = string != null ? string + this.getCONTEXT_DELIMITER() + id : id;
                Collection $this$toTypedArray$iv = cases;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PoEntry poEntry = new PoEntry(str, plural, thisCollection$iv.toArray(new String[0]));
                object.put(string2, poEntry);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Key.values().length];
                try {
                    nArray[Key.Context.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Key.Id.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Key.Str.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Key.Plural.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Key.Cases.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    private static final class Key
    extends Enum<Key> {
        public static final /* enum */ Key Context = new Key();
        public static final /* enum */ Key Id = new Key();
        public static final /* enum */ Key Str = new Key();
        public static final /* enum */ Key Plural = new Key();
        public static final /* enum */ Key Cases = new Key();
        public static final /* enum */ Key Unknown = new Key();
        private static final /* synthetic */ Key[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Key[] values() {
            return (Key[])$VALUES.clone();
        }

        static {
            $VALUES = keyArray = new Key[]{Key.Context, Key.Id, Key.Str, Key.Plural, Key.Cases, Key.Unknown};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

