/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.i18n.gettext;

import com.jetbrains.toolbox.i18n.gettext.BinaryExpression;
import com.jetbrains.toolbox.i18n.gettext.BinaryOp;
import com.jetbrains.toolbox.i18n.gettext.EmptyRule;
import com.jetbrains.toolbox.i18n.gettext.N;
import com.jetbrains.toolbox.i18n.gettext.PluralRuleExpression;
import com.jetbrains.toolbox.i18n.gettext.PluralRuleNumber;
import com.jetbrains.toolbox.i18n.gettext.PluralRuleToken;
import com.jetbrains.toolbox.i18n.gettext.TernaryExpression;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nPluralRuleParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluralRuleParser.kt\ncom/jetbrains/toolbox/i18n/gettext/PluralRuleParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n295#2,2:158\n295#2,2:160\n*S KotlinDebug\n*F\n+ 1 PluralRuleParser.kt\ncom/jetbrains/toolbox/i18n/gettext/PluralRuleParser\n*L\n120#1:158,2\n130#1:160,2\n*E\n"})
public final class PluralRuleParser {
    @NotNull
    private final String rule;

    public PluralRuleParser(@NotNull String rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        this.rule = rule;
    }

    @NotNull
    public final PluralRuleExpression parse() {
        PluralRuleExpression pluralRuleExpression;
        try {
            PluralRuleExpression pluralRuleExpression2 = this.parseExpression(this.lexer());
            if (pluralRuleExpression2 == null) {
                pluralRuleExpression2 = EmptyRule.INSTANCE;
            }
            pluralRuleExpression = pluralRuleExpression2;
        }
        catch (Throwable t2) {
            pluralRuleExpression = EmptyRule.INSTANCE;
        }
        return pluralRuleExpression;
    }

    @NotNull
    public final List<PluralRuleToken> lexer() {
        List list2;
        List $this$lexer_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        int offset = 0;
        block14: while (offset < this.rule.length()) {
            int end;
            if (CharsKt.isWhitespace((char)this.rule.charAt(offset))) {
                ++offset;
                continue;
            }
            switch (this.rule.charAt(offset)) {
                case 'n': {
                    $this$lexer_u24lambda_u240.add(N.INSTANCE);
                    ++offset;
                    continue block14;
                }
                case '(': {
                    $this$lexer_u24lambda_u240.add(PluralRuleToken.LeftParen.INSTANCE);
                    ++offset;
                    continue block14;
                }
                case ')': {
                    $this$lexer_u24lambda_u240.add(PluralRuleToken.RightParen.INSTANCE);
                    ++offset;
                    continue block14;
                }
                case '?': {
                    $this$lexer_u24lambda_u240.add(PluralRuleToken.QuestionMark.INSTANCE);
                    ++offset;
                    continue block14;
                }
                case ':': {
                    $this$lexer_u24lambda_u240.add(PluralRuleToken.Colon.INSTANCE);
                    ++offset;
                    continue block14;
                }
                case '!': {
                    $this$lexer_u24lambda_u240.add(BinaryOp.NotEquals);
                    offset += 2;
                    continue block14;
                }
                case '=': {
                    $this$lexer_u24lambda_u240.add(BinaryOp.Equals);
                    offset += 2;
                    continue block14;
                }
                case '&': {
                    $this$lexer_u24lambda_u240.add(BinaryOp.And);
                    offset += 2;
                    continue block14;
                }
                case '|': {
                    $this$lexer_u24lambda_u240.add(BinaryOp.Or);
                    offset += 2;
                    continue block14;
                }
                case '<': {
                    boolean bl2;
                    if (++offset < this.rule.length() && this.rule.charAt(offset) == '=') {
                        ++offset;
                        bl2 = $this$lexer_u24lambda_u240.add(BinaryOp.LessOrEquals);
                        continue block14;
                    }
                    bl2 = $this$lexer_u24lambda_u240.add(BinaryOp.Less);
                    continue block14;
                }
                case '>': {
                    boolean bl3;
                    if (++offset < this.rule.length() && this.rule.charAt(offset) == '=') {
                        ++offset;
                        bl3 = $this$lexer_u24lambda_u240.add(BinaryOp.GreaterOrEquals);
                        continue block14;
                    }
                    bl3 = $this$lexer_u24lambda_u240.add(BinaryOp.Greater);
                    continue block14;
                }
                case '%': {
                    $this$lexer_u24lambda_u240.add(BinaryOp.Remainder);
                    ++offset;
                    continue block14;
                }
            }
            int result2 = 0;
            for (end = offset; end < this.rule.length() && Character.isDigit(this.rule.charAt(end)); ++end) {
                result2 = result2 * 10 + CharsKt.digitToInt((char)this.rule.charAt(end));
            }
            if (end == offset) continue;
            offset = end;
            $this$lexer_u24lambda_u240.add(new PluralRuleNumber(result2));
        }
        return CollectionsKt.build((List)list2);
    }

    private final PluralRuleExpression parseExpression(List<? extends PluralRuleToken> tokens) {
        PluralRuleExpression braced;
        PluralRuleToken first = (PluralRuleToken)CollectionsKt.firstOrNull(tokens);
        TernaryExpression ternary = this.parseTernaryExpression(tokens);
        if (ternary != null) {
            return ternary;
        }
        if (Intrinsics.areEqual((Object)first, (Object)PluralRuleToken.LeftParen.INSTANCE) && Intrinsics.areEqual((Object)CollectionsKt.last(tokens), (Object)PluralRuleToken.RightParen.INSTANCE) && (braced = this.parseExpression(tokens.subList(1, tokens.size() - 1))) != null) {
            return braced;
        }
        if (tokens.size() > 2) {
            BinaryOp[][] binaryOpArrayArray = new BinaryOp[4][];
            BinaryOp[] binaryOpArray = new BinaryOp[]{BinaryOp.Or};
            binaryOpArrayArray[0] = binaryOpArray;
            binaryOpArray = new BinaryOp[]{BinaryOp.And};
            binaryOpArrayArray[1] = binaryOpArray;
            binaryOpArray = new BinaryOp[]{BinaryOp.NotEquals, BinaryOp.Equals, BinaryOp.Less, BinaryOp.LessOrEquals, BinaryOp.Greater, BinaryOp.GreaterOrEquals};
            binaryOpArrayArray[2] = binaryOpArray;
            binaryOpArray = new BinaryOp[]{BinaryOp.Remainder};
            binaryOpArrayArray[3] = binaryOpArray;
            BinaryOp[][] binaryOpArrayArray2 = binaryOpArrayArray;
            int n = ((Object[])binaryOpArrayArray2).length;
            for (int j = 0; j < n; ++j) {
                BinaryOp[] ops = binaryOpArrayArray2[j];
                BinaryExpression parsed = this.parseBinaryExpression(tokens, Arrays.copyOf(ops, ops.length));
                if (parsed == null) continue;
                return parsed;
            }
        }
        if (first instanceof N && tokens.size() == 1) {
            return (PluralRuleExpression)((Object)first);
        }
        if (first instanceof PluralRuleNumber && tokens.size() == 1) {
            return (PluralRuleExpression)((Object)first);
        }
        return null;
    }

    private final TernaryExpression parseTernaryExpression(List<? extends PluralRuleToken> tokens) {
        Object v3;
        PluralRuleExpression condition;
        int questionMark;
        block12: {
            Object v0;
            int level;
            block11: {
                level = 0;
                Iterable $this$firstOrNull$iv = (Iterable)CollectionsKt.getIndices((Collection)tokens);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    PluralRuleToken token2 = tokens.get(it);
                    if (Intrinsics.areEqual((Object)token2, (Object)PluralRuleToken.LeftParen.INSTANCE)) {
                        ++level;
                    }
                    if (Intrinsics.areEqual((Object)token2, (Object)PluralRuleToken.RightParen.INSTANCE)) {
                        level += -1;
                    }
                    if (!(Intrinsics.areEqual((Object)token2, (Object)PluralRuleToken.QuestionMark.INSTANCE) && level == 0)) continue;
                    v0 = element$iv;
                    break block11;
                }
                v0 = null;
            }
            Integer n = v0;
            if (n == null) {
                return null;
            }
            questionMark = n;
            PluralRuleExpression pluralRuleExpression = this.parseExpression(tokens.subList(0, questionMark));
            if (pluralRuleExpression == null) {
                return null;
            }
            condition = pluralRuleExpression;
            level = 0;
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)(questionMark + 1), (int)tokens.size());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                PluralRuleToken token3 = tokens.get(it);
                if (Intrinsics.areEqual((Object)token3, (Object)PluralRuleToken.LeftParen.INSTANCE)) {
                    ++level;
                }
                if (Intrinsics.areEqual((Object)token3, (Object)PluralRuleToken.RightParen.INSTANCE)) {
                    level += -1;
                }
                if (!(Intrinsics.areEqual((Object)token3, (Object)PluralRuleToken.Colon.INSTANCE) && level == 0)) continue;
                v3 = element$iv;
                break block12;
            }
            v3 = null;
        }
        Integer n = v3;
        if (n == null) {
            return null;
        }
        int colon = n;
        PluralRuleExpression pluralRuleExpression = this.parseExpression(tokens.subList(questionMark + 1, colon));
        if (pluralRuleExpression == null) {
            return null;
        }
        PluralRuleExpression left = pluralRuleExpression;
        PluralRuleExpression pluralRuleExpression2 = this.parseExpression(tokens.subList(colon + 1, tokens.size()));
        if (pluralRuleExpression2 == null) {
            return null;
        }
        PluralRuleExpression right = pluralRuleExpression2;
        return new TernaryExpression(condition, left, right);
    }

    private final BinaryExpression parseBinaryExpression(List<? extends PluralRuleToken> tokens, BinaryOp ... operators) {
        int n = ((Collection)tokens).size();
        for (int i2 = 0; i2 < n; ++i2) {
            PluralRuleExpression left;
            PluralRuleToken token2 = tokens.get(i2);
            if (!(token2 instanceof BinaryOp) || !ArraysKt.contains((Object[])operators, (Object)token2) || this.parseExpression(tokens.subList(0, i2)) == null) continue;
            PluralRuleExpression pluralRuleExpression = this.parseExpression(tokens.subList(i2 + 1, tokens.size()));
            if (pluralRuleExpression == null) continue;
            PluralRuleExpression right = pluralRuleExpression;
            return new BinaryExpression(left, (BinaryOp)token2, right);
        }
        return null;
    }
}

