/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.i18n;

import com.jetbrains.toolbox.i18n.I18nManager;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import java.util.Arrays;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlurableLocalizableString
implements LocalizableStringEx {
    @NotNull
    private final String text;
    @NotNull
    private final String plural;
    private final int n;
    @NotNull
    private final Pair<String, String>[] args;
    @Nullable
    private final I18nManager localI18n;

    public PlurableLocalizableString(@NotNull String text2, @NotNull String plural, int n, @NotNull Pair<String, String>[] args, @Nullable I18nManager localI18n) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)plural, (String)"plural");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.text = text2;
        this.plural = plural;
        this.n = n;
        this.args = args;
        this.localI18n = localI18n;
    }

    public /* synthetic */ PlurableLocalizableString(String string, String string2, int n, Pair[] pairArray, I18nManager i18nManager, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            i18nManager = null;
        }
        this(string, string2, n, pairArray, i18nManager);
    }

    @NotNull
    public final String getText$i18n() {
        return this.text;
    }

    @Override
    @NotNull
    public String localize(@NotNull I18n i18n) {
        Pair<String, String>[] pairArray;
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Object object = this.localI18n;
        if (object == null || (object = object.getState()) == null || (object = (I18n)object.getValue()) == null || (object = object.trn(this.text, this.plural, this.n, Arrays.copyOf(pairArray = this.args, pairArray.length))) == null) {
            pairArray = this.args;
            object = i18n.trn(this.text, this.plural, this.n, Arrays.copyOf(pairArray, pairArray.length));
        }
        return object;
    }

    @NotNull
    public String toString() {
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        if (string == null) {
            string = "";
        }
        return string + "(text=" + this.text + ", plural=" + this.plural + ", n=" + this.n + ArraysKt.joinToString$default((Object[])this.args, (CharSequence)"", null, null, (int)0, null, PlurableLocalizableString::toString$lambda$0, (int)30, null) + ")";
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = 31 * result2 + this.plural.hashCode();
        result2 = 31 * result2 + this.n;
        result2 = 31 * result2 + Arrays.hashCode(this.args);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.i18n.PlurableLocalizableString");
        PlurableLocalizableString cfr_ignored_0 = (PlurableLocalizableString)object2;
        if (!Intrinsics.areEqual((Object)this.text, (Object)((PlurableLocalizableString)other).text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.plural, (Object)((PlurableLocalizableString)other).plural)) {
            return false;
        }
        if (this.n != ((PlurableLocalizableString)other).n) {
            return false;
        }
        return Arrays.equals(this.args, ((PlurableLocalizableString)other).args);
    }

    private static final CharSequence toString$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ", " + it.getFirst() + "=" + it.getSecond();
    }
}

