/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.i18n;

import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.UILanguage;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import java.io.Serializable;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class LocalizableUrl
implements LocalizableStringEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private static final Map<Serializable, String> JbWebsiteLanguages;

    private LocalizableUrl(String url) {
        this.url = url;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public String localize(@NotNull I18n i18n) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        String string = JbWebsiteLanguages.get(i18n.getLocale());
        if (string == null) {
            return this.url;
        }
        String localizedCode = string;
        if (StringsKt.startsWith$default((String)this.url, (String)"https://www.jetbrains.com/", (boolean)false, (int)2, null)) {
            object = StringsKt.replaceFirst$default((String)this.url, (String)"https://www.jetbrains.com/", (String)("https://www.jetbrains.com/" + localizedCode + "/"), (boolean)false, (int)4, null);
        } else if (StringsKt.startsWith$default((String)this.url, (String)"https://jb.gg/", (boolean)false, (int)2, null)) {
            String suffix = StringsKt.removePrefix((String)this.url, (CharSequence)"https://jb.gg/");
            object = "https://jb.gg/" + localizedCode + "/" + suffix;
        } else {
            object = this.url;
        }
        return object;
    }

    public /* synthetic */ LocalizableUrl(String url, DefaultConstructorMarker $constructor_marker) {
        this(url);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)UILanguage.DE.getLocale(), (Object)"de-de"), TuplesKt.to((Object)UILanguage.ES_ES.getLocale(), (Object)"es-es"), TuplesKt.to((Object)UILanguage.FR.getLocale(), (Object)"fr-fr"), TuplesKt.to((Object)UILanguage.JA.getLocale(), (Object)"ja-jp"), TuplesKt.to((Object)((Object)UILanguage.KO), (Object)"ko-kr"), TuplesKt.to((Object)UILanguage.PT_BR.getLocale(), (Object)"pt-br"), TuplesKt.to((Object)UILanguage.RU.getLocale(), (Object)"ru-ru"), TuplesKt.to((Object)UILanguage.ZH_CN.getLocale(), (Object)"zh-cn")};
        JbWebsiteLanguages = MapsKt.mapOf((Pair[])pairArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalizableUrl of(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new LocalizableUrl(url, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

