/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.model;

import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.gateway.ssh.model.Endpoint$;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.ByteArraySerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.JsonNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class Endpoint
implements SshConnectionInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int port;
    @Nullable
    private final String userName;
    @JvmField
    @Nullable
    public String alias;
    private final boolean shouldUseSystemSshAgent;
    @Nullable
    private final List<String> privateKeyPaths;
    @Nullable
    private final String sshConfigPath;
    @JvmField
    @Nullable
    public final List<byte[]> keyInlines;
    @JvmField
    @Nullable
    public final String configInline;
    @JvmField
    @Nullable
    public final String originalConnectionString;
    private final long connectionTimeoutMillis;
    private final boolean shouldUseSystemConfiguration;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public Endpoint(@NotNull String host, int port, @Nullable String userName, @Nullable String alias, boolean shouldUseSystemSshAgent, @Nullable List<String> privateKeyPaths, @Nullable String sshConfigPath, @Nullable List<byte[]> keyInlines, @Nullable String configInline, @Nullable String originalConnectionString, long connectionTimeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.alias = alias;
        this.shouldUseSystemSshAgent = shouldUseSystemSshAgent;
        this.privateKeyPaths = privateKeyPaths;
        this.sshConfigPath = sshConfigPath;
        this.keyInlines = keyInlines;
        this.configInline = configInline;
        this.originalConnectionString = originalConnectionString;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        int n = this.getPort();
        int n2 = 0 <= n ? (n < 65536 ? 1 : 0) : (n = 0);
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.shouldUseSystemConfiguration = true;
    }

    public /* synthetic */ Endpoint(String string, int n, String string2, String string3, boolean bl, List list2, String string4, List list3, String string5, String string6, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            list2 = null;
        }
        if ((n2 & 0x40) != 0) {
            string4 = null;
        }
        if ((n2 & 0x80) != 0) {
            list3 = null;
        }
        if ((n2 & 0x100) != 0) {
            string5 = null;
        }
        if ((n2 & 0x200) != 0) {
            string6 = null;
        }
        if ((n2 & 0x400) != 0) {
            l = 10000L;
        }
        this(string, n, string2, string3, bl, list2, string4, list3, string5, string6, l);
    }

    @NotNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    public boolean getShouldUseSystemSshAgent() {
        return this.shouldUseSystemSshAgent;
    }

    @JsonNames(names={"useAgent"})
    public static /* synthetic */ void getShouldUseSystemSshAgent$annotations() {
    }

    @Nullable
    public List<String> getPrivateKeyPaths() {
        return this.privateKeyPaths;
    }

    @JsonNames(names={"keyPaths"})
    public static /* synthetic */ void getPrivateKeyPaths$annotations() {
    }

    @Nullable
    public String getSshConfigPath() {
        return this.sshConfigPath;
    }

    @JsonNames(names={"configPath"})
    public static /* synthetic */ void getSshConfigPath$annotations() {
    }

    public long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public boolean getShouldUseSystemConfiguration() {
        return this.shouldUseSystemConfiguration;
    }

    @NotNull
    public final String component1() {
        return this.host;
    }

    public final int component2() {
        return this.port;
    }

    @Nullable
    public final String component3() {
        return this.userName;
    }

    @Nullable
    public final String component4() {
        return this.alias;
    }

    public final boolean component5() {
        return this.shouldUseSystemSshAgent;
    }

    @Nullable
    public final List<String> component6() {
        return this.privateKeyPaths;
    }

    @Nullable
    public final String component7() {
        return this.sshConfigPath;
    }

    @Nullable
    public final List<byte[]> component8() {
        return this.keyInlines;
    }

    @Nullable
    public final String component9() {
        return this.configInline;
    }

    @Nullable
    public final String component10() {
        return this.originalConnectionString;
    }

    public final long component11() {
        return this.connectionTimeoutMillis;
    }

    @NotNull
    public final Endpoint copy(@NotNull String host, int port, @Nullable String userName, @Nullable String alias, boolean shouldUseSystemSshAgent, @Nullable List<String> privateKeyPaths, @Nullable String sshConfigPath, @Nullable List<byte[]> keyInlines, @Nullable String configInline, @Nullable String originalConnectionString, long connectionTimeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new Endpoint(host, port, userName, alias, shouldUseSystemSshAgent, privateKeyPaths, sshConfigPath, keyInlines, configInline, originalConnectionString, connectionTimeoutMillis);
    }

    public static /* synthetic */ Endpoint copy$default(Endpoint endpoint, String string, int n, String string2, String string3, boolean bl, List list2, String string4, List list3, String string5, String string6, long l, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = endpoint.host;
        }
        if ((n2 & 2) != 0) {
            n = endpoint.port;
        }
        if ((n2 & 4) != 0) {
            string2 = endpoint.userName;
        }
        if ((n2 & 8) != 0) {
            string3 = endpoint.alias;
        }
        if ((n2 & 0x10) != 0) {
            bl = endpoint.shouldUseSystemSshAgent;
        }
        if ((n2 & 0x20) != 0) {
            list2 = endpoint.privateKeyPaths;
        }
        if ((n2 & 0x40) != 0) {
            string4 = endpoint.sshConfigPath;
        }
        if ((n2 & 0x80) != 0) {
            list3 = endpoint.keyInlines;
        }
        if ((n2 & 0x100) != 0) {
            string5 = endpoint.configInline;
        }
        if ((n2 & 0x200) != 0) {
            string6 = endpoint.originalConnectionString;
        }
        if ((n2 & 0x400) != 0) {
            l = endpoint.connectionTimeoutMillis;
        }
        return endpoint.copy(string, n, string2, string3, bl, list2, string4, list3, string5, string6, l);
    }

    @NotNull
    public String toString() {
        return "Endpoint(host=" + this.host + ", port=" + this.port + ", userName=" + this.userName + ", alias=" + this.alias + ", shouldUseSystemSshAgent=" + this.shouldUseSystemSshAgent + ", privateKeyPaths=" + this.privateKeyPaths + ", sshConfigPath=" + this.sshConfigPath + ", keyInlines=" + this.keyInlines + ", configInline=" + this.configInline + ", originalConnectionString=" + this.originalConnectionString + ", connectionTimeoutMillis=" + this.connectionTimeoutMillis + ")";
    }

    public int hashCode() {
        int result2 = this.host.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.port);
        result2 = result2 * 31 + (this.userName == null ? 0 : this.userName.hashCode());
        result2 = result2 * 31 + (this.alias == null ? 0 : this.alias.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.shouldUseSystemSshAgent);
        result2 = result2 * 31 + (this.privateKeyPaths == null ? 0 : ((Object)this.privateKeyPaths).hashCode());
        result2 = result2 * 31 + (this.sshConfigPath == null ? 0 : this.sshConfigPath.hashCode());
        result2 = result2 * 31 + (this.keyInlines == null ? 0 : ((Object)this.keyInlines).hashCode());
        result2 = result2 * 31 + (this.configInline == null ? 0 : this.configInline.hashCode());
        result2 = result2 * 31 + (this.originalConnectionString == null ? 0 : this.originalConnectionString.hashCode());
        result2 = result2 * 31 + Long.hashCode(this.connectionTimeoutMillis);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)other;
        if (!Intrinsics.areEqual((Object)this.host, (Object)endpoint.host)) {
            return false;
        }
        if (this.port != endpoint.port) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userName, (Object)endpoint.userName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alias, (Object)endpoint.alias)) {
            return false;
        }
        if (this.shouldUseSystemSshAgent != endpoint.shouldUseSystemSshAgent) {
            return false;
        }
        if (!Intrinsics.areEqual(this.privateKeyPaths, endpoint.privateKeyPaths)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sshConfigPath, (Object)endpoint.sshConfigPath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyInlines, endpoint.keyInlines)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configInline, (Object)endpoint.configInline)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalConnectionString, (Object)endpoint.originalConnectionString)) {
            return false;
        }
        return this.connectionTimeoutMillis == endpoint.connectionTimeoutMillis;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$gateway_plugin_ssh(Endpoint self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output2.encodeStringElement(serialDesc, 0, self.getHost());
        output2.encodeIntElement(serialDesc, 1, self.getPort());
        output2.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getUserName());
        if (output2.shouldEncodeElementDefault(serialDesc, 3) ? true : self.alias != null) {
            output2.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.alias);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 4) ? true : self.getShouldUseSystemSshAgent()) {
            output2.encodeBooleanElement(serialDesc, 4, self.getShouldUseSystemSshAgent());
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 5) ? true : self.getPrivateKeyPaths() != null) {
            output2.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), self.getPrivateKeyPaths());
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 6) ? true : self.getSshConfigPath() != null) {
            output2.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.getSshConfigPath());
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 7) ? true : self.keyInlines != null) {
            output2.encodeNullableSerializableElement(serialDesc, 7, (SerializationStrategy)lazyArray[7].getValue(), self.keyInlines);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 8) ? true : self.configInline != null) {
            output2.encodeNullableSerializableElement(serialDesc, 8, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.configInline);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 9) ? true : self.originalConnectionString != null) {
            output2.encodeNullableSerializableElement(serialDesc, 9, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.originalConnectionString);
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 10) ? true : self.getConnectionTimeoutMillis() != 10000L) {
            output2.encodeLongElement(serialDesc, 10, self.getConnectionTimeoutMillis());
        }
        if (output2.shouldEncodeElementDefault(serialDesc, 11) ? true : !self.getShouldUseSystemConfiguration()) {
            output2.encodeBooleanElement(serialDesc, 11, self.getShouldUseSystemConfiguration());
        }
    }

    public /* synthetic */ Endpoint(int seen0, String host, int port, String userName, String alias, boolean shouldUseSystemSshAgent, List privateKeyPaths, String sshConfigPath, List keyInlines, String configInline, String originalConnectionString, long connectionTimeoutMillis, boolean shouldUseSystemConfiguration, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.alias = (seen0 & 8) == 0 ? null : alias;
        this.shouldUseSystemSshAgent = (seen0 & 0x10) == 0 ? false : shouldUseSystemSshAgent;
        this.privateKeyPaths = (seen0 & 0x20) == 0 ? null : privateKeyPaths;
        this.sshConfigPath = (seen0 & 0x40) == 0 ? null : sshConfigPath;
        this.keyInlines = (seen0 & 0x80) == 0 ? null : keyInlines;
        this.configInline = (seen0 & 0x100) == 0 ? null : configInline;
        this.originalConnectionString = (seen0 & 0x200) == 0 ? null : originalConnectionString;
        this.connectionTimeoutMillis = (seen0 & 0x400) == 0 ? 10000L : connectionTimeoutMillis;
        int n = this.getPort();
        int n2 = 0 <= n ? (n < 65536 ? 1 : 0) : (n = 0);
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.shouldUseSystemConfiguration = (seen0 & 0x800) == 0 ? true : shouldUseSystemConfiguration;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)ByteArraySerializer.INSTANCE)), null, null, null, null};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Endpoint> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

