/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.api.core.PluginSettingsStore;
import com.jetbrains.toolbox.api.core.ServiceLocator;
import com.jetbrains.toolbox.api.core.os.LocalDesktopManager;
import com.jetbrains.toolbox.api.core.util.LoadableState;
import com.jetbrains.toolbox.api.core.util.LoadableStateKt;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.api.remoteDev.AbstractRemoteProvider;
import com.jetbrains.toolbox.api.remoteDev.ProviderVisibilityState;
import com.jetbrains.toolbox.api.remoteDev.connection.ClientHelper;
import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.api.remoteDev.ssh.validation.SshConnectionValidator;
import com.jetbrains.toolbox.api.remoteDev.ui.EnvironmentUiPageManager;
import com.jetbrains.toolbox.api.ui.ToolboxUi;
import com.jetbrains.toolbox.api.ui.actions.ActionDescription;
import com.jetbrains.toolbox.api.ui.actions.RunnableActionDescription;
import com.jetbrains.toolbox.api.ui.components.TextFieldKt;
import com.jetbrains.toolbox.api.ui.components.TextFieldMutable;
import com.jetbrains.toolbox.api.ui.components.TextType;
import com.jetbrains.toolbox.api.ui.components.UiField;
import com.jetbrains.toolbox.api.ui.components.UiPage;
import com.jetbrains.toolbox.api.ui.components.ValidationResult;
import com.jetbrains.toolbox.common.coroutines.flow.SingleStateFlow;
import com.jetbrains.toolbox.gateway.InternalDialogService;
import com.jetbrains.toolbox.gateway.ProjectStub;
import com.jetbrains.toolbox.gateway.ToolPathRegisterService;
import com.jetbrains.toolbox.gateway.error.ConnectionError;
import com.jetbrains.toolbox.gateway.error.DuplicateEnvironmentError;
import com.jetbrains.toolbox.gateway.error.EnvironmentError;
import com.jetbrains.toolbox.gateway.hints.EnvironmentHint;
import com.jetbrains.toolbox.gateway.hints.EnvironmentHintService;
import com.jetbrains.toolbox.gateway.ssh.SshConfigPathProvider;
import com.jetbrains.toolbox.gateway.ssh.SshConnectionStringCache;
import com.jetbrains.toolbox.gateway.ssh.SshCustomLinkHandler;
import com.jetbrains.toolbox.gateway.ssh.SshNewEnvPage;
import com.jetbrains.toolbox.gateway.ssh.SshPluginSettingsStore;
import com.jetbrains.toolbox.gateway.ssh.SshRemoteEnvironment;
import com.jetbrains.toolbox.gateway.ssh.SshRemoteProvider;
import com.jetbrains.toolbox.gateway.ssh.SshRemoteProvider$special$;
import com.jetbrains.toolbox.gateway.ssh.UtilKt;
import com.jetbrains.toolbox.gateway.ssh.autocompletion.SshCacheAutocompletionProvider;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfig;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfigProvider;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfigs;
import com.jetbrains.toolbox.gateway.ssh.configImport.OpenSshImportedConfigsProviderFactory;
import com.jetbrains.toolbox.gateway.ssh.hints.IdePathsCache;
import com.jetbrains.toolbox.gateway.ssh.hints.IdePathsService;
import com.jetbrains.toolbox.gateway.ssh.hints.RejectedHintsCache;
import com.jetbrains.toolbox.gateway.ssh.model.Endpoint;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.platform.image.ImageResource;
import com.jetbrains.toolbox.platform.image.ImageResourceKt;
import com.jetbrains.toolbox.platform.resource.ResourceReader;
import com.jetbrains.toolbox.platform.resource.jvm.JvmResourceReaderKt;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSshRemoteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshRemoteProvider.kt\ncom/jetbrains/toolbox/gateway/ssh/SshRemoteProvider\n+ 2 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 3 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 4 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,469:1\n49#2:470\n51#2:474\n46#3:471\n51#3:473\n105#4:472\n1#5:475\n1563#6:476\n1634#6,3:477\n1669#6,8:480\n1374#6:488\n1460#6,2:489\n1563#6:491\n1634#6,3:492\n1462#6,3:495\n*S KotlinDebug\n*F\n+ 1 SshRemoteProvider.kt\ncom/jetbrains/toolbox/gateway/ssh/SshRemoteProvider\n*L\n104#1:470\n104#1:474\n104#1:471\n104#1:473\n104#1:472\n175#1:476\n175#1:477,3\n181#1:480,8\n278#1:488\n278#1:489,2\n278#1:491\n278#1:492,3\n278#1:495,3\n*E\n"})
public final class SshRemoteProvider
extends AbstractRemoteProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope pluginScope;
    @NotNull
    private final PluginSettingsStore settingsStore;
    @NotNull
    private final ServiceLocator serviceLocator;
    @NotNull
    private final Json json;
    @NotNull
    private final MutableStateFlow<LoadableState<List<SshRemoteEnvironment>>> environments;
    private long myTimeout;
    @NotNull
    private final SshConnectionValidator sshConnectionValidator;
    @NotNull
    private final SshConnectionStringCache connectionStringCache;
    @NotNull
    private final OpenSshImportedConfigsProviderFactory openSshImportedConfigsProviderFactory;
    @NotNull
    private final SshCacheAutocompletionProvider sshCacheAutocompletionProvider;
    @NotNull
    private final ToolboxUi toolboxUi;
    @NotNull
    private final EnvironmentUiPageManager environmentUiPageManager;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final RejectedHintsCache rejectedHintsCache;
    @NotNull
    private final EnvironmentHintService environmentHintService;
    @NotNull
    private final ImportedSshConfigProvider intellijImportProvider;
    @NotNull
    private final ToolPathRegisterService idePathRegisterService;
    @NotNull
    private final ClientHelper clientHelper;
    @NotNull
    private final InternalDialogService dialogService;
    @NotNull
    private final LocalizableStringFactory i18n;
    @NotNull
    private final IdePathsCache idePathsCache;
    @NotNull
    private final IdePathsService idePathService;
    @NotNull
    private final SshConfigPathProvider sshConfigPathProvider;
    @NotNull
    private final LocalDesktopManager localDesktopManager;
    @NotNull
    private final StateFlow<ImportedSshConfigProvider> openSshImportedConfigsProviderState;
    @NotNull
    private final MutableStateFlow<List<ImportedSshConfigs>> opensshImportedConfigurations;
    @NotNull
    private final MutableStateFlow<List<ImportedSshConfigs>> intellijImportedConfigurations;
    @NotNull
    private final StateFlow<List<ImportedSshConfigs>> importedConfigurations;
    @NotNull
    private final StateFlow<List<EnvironmentHint>> currentHintsAll;
    @NotNull
    private final String noEnvironmentsDescription;
    private final boolean canCreateNewEnvironments;
    private final boolean isSingleEnvironment;
    @NotNull
    private final SshNewEnvPage newEnvironmentPage;
    @NotNull
    private static final String timeoutSettingName = "timeoutSeconds";
    @NotNull
    private static final String environmentsJsonSettingName = "envsJson";
    @NotNull
    private static final ImageResource sshLogo = ImageResourceKt.image$default((ResourceReader)JvmResourceReaderKt.jvmResourceReader$default((Object)Companion, null, (int)1, null), (String)"ssh-logo.svg", (boolean)false, (int)2, null);

    public SshRemoteProvider(@NotNull CoroutineScope pluginScope, @NotNull PluginSettingsStore settingsStore, @NotNull ServiceLocator serviceLocator) {
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)settingsStore, (String)"settingsStore");
        Intrinsics.checkNotNullParameter((Object)serviceLocator, (String)"serviceLocator");
        super("SSH");
        this.pluginScope = pluginScope;
        this.settingsStore = settingsStore;
        this.serviceLocator = serviceLocator;
        this.json = JsonKt.Json$default(null, SshRemoteProvider::json$lambda$0, (int)1, null);
        this.environments = StateFlowKt.MutableStateFlow((Object)new LoadableState.Value((Object)CollectionsKt.emptyList()));
        this.myTimeout = 10000L;
        this.sshConnectionValidator = (SshConnectionValidator)this.serviceLocator.getService(SshConnectionValidator.class);
        this.connectionStringCache = new SshConnectionStringCache(this.settingsStore, this.json);
        this.openSshImportedConfigsProviderFactory = (OpenSshImportedConfigsProviderFactory)this.serviceLocator.getService(OpenSshImportedConfigsProviderFactory.class);
        this.sshCacheAutocompletionProvider = new SshCacheAutocompletionProvider(this.connectionStringCache);
        this.toolboxUi = (ToolboxUi)this.serviceLocator.getService(ToolboxUi.class);
        this.environmentUiPageManager = (EnvironmentUiPageManager)this.serviceLocator.getService(EnvironmentUiPageManager.class);
        this.fileSystem = (FileSystem)this.serviceLocator.getService(FileSystem.class);
        this.rejectedHintsCache = new RejectedHintsCache(this.settingsStore, this.json, this.pluginScope);
        this.environmentHintService = (EnvironmentHintService)this.serviceLocator.getService(EnvironmentHintService.class);
        this.intellijImportProvider = (ImportedSshConfigProvider)this.serviceLocator.getService(ImportedSshConfigProvider.class);
        this.idePathRegisterService = (ToolPathRegisterService)this.serviceLocator.getService(ToolPathRegisterService.class);
        this.clientHelper = (ClientHelper)this.serviceLocator.getService(ClientHelper.class);
        this.dialogService = (InternalDialogService)this.serviceLocator.getService(InternalDialogService.class);
        this.i18n = (LocalizableStringFactory)this.serviceLocator.getService(LocalizableStringFactory.class);
        this.idePathsCache = new IdePathsCache(this.settingsStore, this.json);
        this.idePathService = new IdePathsService(this.idePathsCache, this.idePathRegisterService, this.pluginScope);
        this.sshConfigPathProvider = new SshConfigPathProvider(this.settingsStore, this.pluginScope);
        this.localDesktopManager = (LocalDesktopManager)this.serviceLocator.getService(LocalDesktopManager.class);
        Flow $this$map$iv = (Flow)this.sshConfigPathProvider.getCurrentConfigPath();
        boolean $i$f$map = false;
        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        this.openSshImportedConfigsProviderState = FlowKt.stateIn((Flow)((Flow)new Flow<ImportedSshConfigProvider>($this$unsafeTransform$iv$iv, this){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.$this_unsafeTransform$inlined = flow2;
                this.this$0 = sshRemoteProvider;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    final /* synthetic */ SshRemoteProvider this$0;
                    {
                        this.$this_unsafeFlow = $receiver;
                        this.this$0 = sshRemoteProvider;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof special$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ special$$inlined$map$1$2 this$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                var10_14 = $this$map_u24lambda_u245;
                                var11_15 = (Continuation)$continuation;
                                configPath = (String)value;
                                $i$a$-map-SshRemoteProvider$openSshImportedConfigsProviderState$1 = false;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                $continuation.label = 1;
                                v0 = var10_14.emit((Object)SshRemoteProvider.access$getOpenSshImportedConfigsProviderFactory$p(this.this$0).create(configPath), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl38
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl38:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }), (CoroutineScope)this.pluginScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)this.openSshImportedConfigsProviderFactory.create((String)this.sshConfigPathProvider.getCurrentConfigPath().getValue()));
        this.opensshImportedConfigurations = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.intellijImportedConfigurations = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.importedConfigurations = FlowKt.stateIn((Flow)FlowKt.combine((Flow)((Flow)this.opensshImportedConfigurations), (Flow)((Flow)this.intellijImportedConfigurations), (Function3)((Function3)new Function3<List<? extends ImportedSshConfigs>, List<? extends ImportedSshConfigs>, Continuation<? super List<? extends ImportedSshConfigs>>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                List list2 = (List)this.L$0;
                List list3 = (List)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void intellij;
                        void openssh;
                        ResultKt.throwOnFailure((Object)$result);
                        return CollectionsKt.plus((Collection)((Collection)openssh), (Iterable)((Iterable)intellij));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(List<ImportedSshConfigs> p1, List<ImportedSshConfigs> p2, Continuation<? super List<ImportedSshConfigs>> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.pluginScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)CollectionsKt.emptyList());
        this.currentHintsAll = this.hintsState();
        this.updateOpenSshImportOnConfigProviderChange();
        this.scheduleRefreshIntellijImports();
        this.refreshTimeout();
        this.loadEnvironments();
        this.noEnvironmentsDescription = "Establish an SSH connection to your remote machine";
        this.canCreateNewEnvironments = true;
        this.newEnvironmentPage = new SshNewEnvPage(this.toolboxUi, sshLogo, this.sshCacheAutocompletionProvider, this.importedConfigurations, this.idePathService, this.json, (Function4<? super String, ? super Endpoint, ? super Function0<Unit>, ? super Function2<? super String, ? super EnvironmentError, Unit>, ? extends Job>)((Function4)new Function4<String, Endpoint, Function0<? extends Unit>, Function2<? super String, ? super EnvironmentError, ? extends Unit>, Job>((Object)this){

            public final Job invoke(String p0, Endpoint p1, Function0<Unit> p2, Function2<? super String, ? super EnvironmentError, Unit> p3) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                Intrinsics.checkNotNullParameter(p3, (String)"p3");
                return SshRemoteProvider.createEnvironment$default((SshRemoteProvider)((Object)this.receiver), p0, p1, p2, p3, false, 16, null);
            }
        }), (Function1<? super String, ? extends Job>)((Function1)new Function1<String, Job>((Object)this){

            public final Job invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SshRemoteProvider.access$openEnvironmentPage((SshRemoteProvider)((Object)this.receiver), p0);
            }
        }), this.fileSystem, this.pluginScope, this.i18n);
    }

    @NotNull
    public final CoroutineScope getPluginScope() {
        return this.pluginScope;
    }

    private final String asEnvSpecific(String $this$asEnvSpecific, String id) {
        return $this$asEnvSpecific + "_ENV" + id;
    }

    @NotNull
    public MutableStateFlow<LoadableState<List<SshRemoteEnvironment>>> getEnvironments() {
        return this.environments;
    }

    public final void setAutoConnect(@NotNull String devEnvironmentId, boolean autoConnect) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        ((Map)this.settingsStore).put(this.asEnvSpecific("TBX_AUTO_CONNECT", devEnvironmentId), String.valueOf(autoConnect));
    }

    public final boolean getAutoConnect(@NotNull String devEnvironmentId) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        String string = (String)this.settingsStore.get((Object)this.asEnvSpecific("TBX_AUTO_CONNECT", devEnvironmentId));
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final long getTimeoutMillis() {
        return this.myTimeout;
    }

    private final void refreshTimeout() {
        Object object = (String)this.settingsStore.get((Object)timeoutSettingName);
        this.myTimeout = (long)(object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 10) * 1000L;
    }

    public void close() {
        this.getEnvironments().setValue((Object)new LoadableState.Value((Object)CollectionsKt.emptyList()));
    }

    public void setVisible(@NotNull ProviderVisibilityState visibilityState) {
        Intrinsics.checkNotNullParameter((Object)visibilityState, (String)"visibilityState");
        Logger.INSTANCE.debug("Visibility changed " + visibilityState);
    }

    private final void updateOpenSshImportOnConfigProviderChange() {
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)SshRemoteProvider.access$getOpenSshImportedConfigsProviderState$p(this.this$0)), (Function2)((Function2)new Function2<ImportedSshConfigProvider, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$1;
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SshRemoteProvider this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (ImportedSshConfigProvider)this.L$0;
                                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var3_4 = SshRemoteProvider.access$getOpensshImportedConfigurations$p(this.this$0);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)provider);
                                        this.L$1 = var3_4;
                                        this.label = 1;
                                        v0 = provider.getImportedSshConfigs((Continuation<? super List<ImportedSshConfigs>>)((Continuation)this));
                                        if (v0 == var4_3) {
                                            return var4_3;
                                        }
                                        ** GOTO lbl18
                                    }
                                    case 1: {
                                        var3_4 = (MutableStateFlow)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl18:
                                        // 2 sources

                                        var3_4.setValue(v0);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ImportedSshConfigProvider p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void scheduleRefreshIntellijImports() {
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = SshRemoteProvider.access$getIntellijImportedConfigurations$p(this.this$0);
                        this.L$0 = var2_3;
                        this.label = 1;
                        v0 = SshRemoteProvider.access$getIntellijImportProvider$p(this.this$0).getImportedSshConfigs((Continuation<? super List<ImportedSshConfigs>>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        var2_3 = (MutableStateFlow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        var2_3.setValue(v0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void scheduleRefreshOpenSshImports() {
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = SshRemoteProvider.access$getOpensshImportedConfigurations$p(this.this$0);
                        this.L$0 = var2_3;
                        this.label = 1;
                        v0 = ((ImportedSshConfigProvider)SshRemoteProvider.access$getOpenSshImportedConfigsProviderState$p(this.this$0).getValue()).getImportedSshConfigs((Continuation<? super List<ImportedSshConfigs>>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        var2_3 = (MutableStateFlow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        var2_3.setValue(v0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void loadEnvironments() {
        var2_1 = (String)this.settingsStore.get((Object)"envsJson");
        if (var2_1 == null) ** GOTO lbl-1000
        it = var2_1;
        $i$a$-let-SshRemoteProvider$loadEnvironments$existingEnvironments$1 = false;
        var3_5 = (SshPluginSettingsStore)this.json.decodeFromString((DeserializationStrategy)SshPluginSettingsStore.Companion.serializer(), it);
        if (var3_5 != null && (var4_6 = var3_5.getRemotes()) != null) {
            $i$a$-let-SshRemoteProvider$loadEnvironments$existingEnvironments$1 = var4_6;
            $i$f$map = false;
            var8_9 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var13_15 = (Endpoint)item$iv$iv;
                var15_18 = destination$iv$iv;
                $i$a$-map-SshRemoteProvider$loadEnvironments$existingEnvironments$2 = false;
                var15_18.add(new SshRemoteEnvironment(this, (Endpoint)remote, this.i18n));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$distinctBy = false;
            set$iv = new HashSet<String>();
            list$iv = new ArrayList<T>();
            for (T e$iv : $this$distinctBy$iv) {
                it = (SshRemoteEnvironment)e$iv;
                $i$a$-distinctBy-SshRemoteProvider$loadEnvironments$existingEnvironments$3 = false;
                key$iv = it.getId();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            v0 = list$iv;
        } else lbl-1000:
        // 2 sources

        {
            v0 = null;
        }
        v1 = existingEnvironments = v0;
        if (v1 != null) {
            it = v1;
            $i$a$-let-SshRemoteProvider$loadEnvironments$1 = false;
            this.getEnvironments().setValue((Object)new LoadableState.Value(it));
        }
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)LoadableStateKt.filterNotLoading((Flow)((Flow)this.this$0.getEnvironments())), (Function2)((Function2)new Function2<List<? extends SshRemoteEnvironment>, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SshRemoteProvider this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                List list2 = (List)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Collection<Endpoint> collection;
                                        void $this$mapTo$iv$iv;
                                        void $this$map$iv;
                                        void state2;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Iterable iterable = (Iterable)state2;
                                        SerializationStrategy serializationStrategy = (SerializationStrategy)SshPluginSettingsStore.Companion.serializer();
                                        Json json2 = SshRemoteProvider.access$getJson$p(this.this$0);
                                        boolean $i$f$map = false;
                                        void var6_7 = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void it;
                                            SshRemoteEnvironment sshRemoteEnvironment = (SshRemoteEnvironment)((Object)item$iv$iv);
                                            collection = destination$iv$iv;
                                            boolean bl = false;
                                            collection.add(it.getEndpoint());
                                        }
                                        collection = (List)destination$iv$iv;
                                        List list3 = collection;
                                        String sshPluginSettings = json2.encodeToString(serializationStrategy, (Object)new SshPluginSettingsStore(list3));
                                        ((Map)SshRemoteProvider.access$getSettingsStore$p(this.this$0)).put("envsJson", sshPluginSettings);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(List<SshRemoteEnvironment> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collect((Flow)FlowKt.combine((Flow)LoadableStateKt.filterNotLoading((Flow)((Flow)this.this$0.getEnvironments())), (Flow)((Flow)SshRemoteProvider.access$getCurrentHintsAll$p(this.this$0)), (Flow)((Flow)SshRemoteProvider.access$getRejectedHintsCache$p(this.this$0).getState()), (Function4)((Function4)new Function4<List<? extends SshRemoteEnvironment>, List<? extends EnvironmentHint>, Set<? extends String>, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            /* synthetic */ Object L$1;
                            /* synthetic */ Object L$2;
                            final /* synthetic */ SshRemoteProvider this$0;
                            {
                                this.this$0 = $receiver;
                                super(4, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                List list2 = (List)this.L$0;
                                List list3 = (List)this.L$1;
                                Set set = (Set)this.L$2;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$filterNotTo$iv$iv;
                                        void $this$filterNot$iv;
                                        void hints;
                                        Object object;
                                        void $this$mapTo$iv$iv;
                                        void envs;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Iterable $this$map$iv = (Iterable)envs;
                                        boolean $i$f$map = false;
                                        Iterable iterable = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void environment;
                                            SshRemoteEnvironment sshRemoteEnvironment = (SshRemoteEnvironment)((Object)item$iv$iv);
                                            object = destination$iv$iv;
                                            boolean bl = false;
                                            Object object2 = environment.getNameFlow().getValue();
                                            String it = (String)object2;
                                            boolean bl2 = false;
                                            String string = (String)(((CharSequence)it).length() > 0 ? object2 : null);
                                            if (string == null) {
                                                string = environment.getName();
                                            }
                                            object.add(string);
                                        }
                                        List currentEnvironmentNames = (List)destination$iv$iv;
                                        $this$map$iv = (Iterable)hints;
                                        object = SshRemoteProvider.access$getEnvironmentHintService$p(this.this$0);
                                        boolean $i$f$filterNot = false;
                                        $this$mapTo$iv$iv = $this$filterNot$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        boolean $i$f$filterNotTo = false;
                                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                            void rejected;
                                            EnvironmentHint it = (EnvironmentHint)element$iv$iv;
                                            boolean bl = false;
                                            if (rejected.contains(it.getId()) || currentEnvironmentNames.contains(it.getName())) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        object.setEnvironmentHints((List)destination$iv$iv);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(List<SshRemoteEnvironment> p1, List<? extends EnvironmentHint> p2, Set<String> p3, Continuation<? super Unit> p4) {
                                var var5_5 = new /* invalid duplicate definition of identical inner class */;
                                var5_5.L$0 = p1;
                                var5_5.L$1 = p2;
                                var5_5.L$2 = p3;
                                return var5_5.invokeSuspend(Unit.INSTANCE);
                            }
                        })), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public ImageResource getIconResource() {
        return sshLogo;
    }

    @NotNull
    public ImageResource getNoEnvironmentsIconResource() {
        return sshLogo;
    }

    @NotNull
    public String getNoEnvironmentsDescription() {
        return this.noEnvironmentsDescription;
    }

    public boolean getCanCreateNewEnvironments() {
        return this.canCreateNewEnvironments;
    }

    public boolean isSingleEnvironment() {
        return this.isSingleEnvironment;
    }

    private final Job createEnvironment(String singleInputValue, Endpoint endpoint, Function0<Unit> onStart, Function2<? super String, ? super EnvironmentError, Unit> onEnd, boolean withValidation) {
        return BuildersKt.launch$default((CoroutineScope)this.pluginScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onStart, this, endpoint, onEnd, singleInputValue, withValidation, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ Function0<Unit> $onStart;
            final /* synthetic */ SshRemoteProvider this$0;
            final /* synthetic */ Endpoint $endpoint;
            final /* synthetic */ Function2<String, EnvironmentError, Unit> $onEnd;
            final /* synthetic */ String $singleInputValue;
            final /* synthetic */ boolean $withValidation;
            {
                this.$onStart = $onStart;
                this.this$0 = $receiver;
                this.$endpoint = $endpoint;
                this.$onEnd = $onEnd;
                this.$singleInputValue = $singleInputValue;
                this.$withValidation = $withValidation;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$onStart.invoke();
                        environment = new SshRemoteEnvironment(this.this$0, this.$endpoint, SshRemoteProvider.access$getI18n$p(this.this$0));
                        v0 /* !! */  = ((LoadableState)this.this$0.getEnvironments().getValue()).takeIfValue();
                        if (v0 /* !! */  == null || (v0 /* !! */  = (List)v0 /* !! */ .getValue()) == null) ** GOTO lbl20
                        var5_4 = (Iterable)v0 /* !! */ ;
                        for (T var7_6 : var5_4) {
                            it = (SshRemoteEnvironment)var7_6;
                            $i$a$-find-SshRemoteProvider$createEnvironment$1$existingEnvironment$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)environment.getId())) continue;
                            v1 = var7_6;
                            ** GOTO lbl18
                        }
                        v1 = null;
lbl18:
                        // 2 sources

                        v2 = v1;
                        ** GOTO lbl21
lbl20:
                        // 1 sources

                        v2 = existingEnvironment = null;
lbl21:
                        // 2 sources

                        if (existingEnvironment == null) ** GOTO lbl27
                        this.$onEnd.invoke((Object)existingEnvironment.getId(), (Object)new DuplicateEnvironmentError());
                        BuildersKt.launch$default((CoroutineScope)this.this$0.getPluginScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(existingEnvironment, null){
                            int label;
                            final /* synthetic */ SshRemoteEnvironment $existingEnvironment;
                            {
                                this.$existingEnvironment = $existingEnvironment;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.$existingEnvironment.connect((Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        ** GOTO lbl45
lbl27:
                        // 1 sources

                        this.L$0 = environment;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)existingEnvironment);
                        this.label = 1;
                        v3 = SshRemoteProvider.access$addEnvironment(this.this$0, environment, this.$singleInputValue, this.$endpoint, this.$withValidation, (Continuation)this);
                        if (v3 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl39
                    }
                    case 1: {
                        existingEnvironment = (SshRemoteEnvironment)this.L$1;
                        environment = (SshRemoteEnvironment)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl39:
                        // 2 sources

                        error = (EnvironmentError)v3;
                        this.$onEnd.invoke((Object)environment.getId(), (Object)error);
                        if (error == null) {
                            BuildersKt.launch$default((CoroutineScope)this.this$0.getPluginScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(environment, null){
                                int label;
                                final /* synthetic */ SshRemoteEnvironment $environment;
                                {
                                    this.$environment = $environment;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.$environment.connect((Continuation<? super Unit>)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
lbl45:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    static /* synthetic */ Job createEnvironment$default(SshRemoteProvider sshRemoteProvider, String string, Endpoint endpoint, Function0 function0, Function2 function2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return sshRemoteProvider.createEnvironment(string, endpoint, (Function0<Unit>)function0, (Function2<? super String, ? super EnvironmentError, Unit>)function2, bl);
    }

    /*
     * Unable to fully structure code
     */
    private final Object addEnvironment(SshRemoteEnvironment environment, String singleInputValue, Endpoint endpoint, boolean withValidation, Continuation<? super EnvironmentError> $completion) {
        if (!($completion instanceof addEnvironment.1)) ** GOTO lbl-1000
        var26_6 = $completion;
        if ((var26_6.label & -2147483648) != 0) {
            var26_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshRemoteProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SshRemoteProvider.access$addEnvironment(this.this$0, null, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var27_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!withValidation) ** GOTO lbl44
                endpointWithTimeout = Endpoint.copy$default(endpoint, null, 0, null, null, false, null, null, null, null, null, this.getTimeoutMillis(), 1023, null);
                $continuation.L$0 = environment;
                $continuation.L$1 = singleInputValue;
                $continuation.L$2 = endpoint;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)endpointWithTimeout);
                $continuation.Z$0 = withValidation;
                $continuation.label = 1;
                v0 = this.sshConnectionValidator.validate(SshRemoteEnvironment.Companion.toUsernameHostPortString(endpoint), (SshConnectionInfo)endpointWithTimeout, (Continuation)$continuation);
                ** if (v0 != var27_8) goto lbl25
lbl24:
                // 1 sources

                return var27_8;
lbl25:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                withValidation = $continuation.Z$0;
                endpointWithTimeout = (Endpoint)$continuation.L$3;
                endpoint = (Endpoint)$continuation.L$2;
                singleInputValue = (String)$continuation.L$1;
                environment = (SshRemoteEnvironment)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl36:
                    // 2 sources

                    var8_10 = (List)v0;
                }
                catch (ConnectionError e) {
                    return e;
                }
                validationResult = var8_10;
                if (((Collection)validationResult).isEmpty() == false) {
                    Logger.INSTANCE.warn("Failed to add SSH environment: Connection validation failed");
                    return ConnectionError.Companion.fromSshValidationFailure(validationResult);
                }
lbl44:
                // 3 sources

                if (singleInputValue != null) {
                    endpointWithTimeout = (Iterable)this.opensshImportedConfigurations.getValue();
                    $i$f$flatMap = false;
                    var8_10 = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (ImportedSshConfigs)element$iv$iv;
                        $i$a$-flatMap-SshRemoteProvider$addEnvironment$2 = false;
                        $this$map$iv = it.getConfigs();
                        $i$f$map = false;
                        var17_22 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var22_27 = (ImportedSshConfig)item$iv$iv;
                            var23_28 = destination$iv$iv;
                            $i$a$-map-SshRemoteProvider$addEnvironment$2$1 = false;
                            var23_28.add(config.getAlias());
                        }
                        list$iv$iv = (List)destination$iv$iv;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    if (!((List)destination$iv$iv).contains(singleInputValue)) {
                        this.connectionStringCache.add(singleInputValue, endpoint);
                    }
                }
                this.getEnvironments().setValue((Object)((LoadableState)this.getEnvironments().getValue()).useValue((Object)CollectionsKt.listOf((Object)environment), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, addEnvironment$lambda$1(com.jetbrains.toolbox.gateway.ssh.SshRemoteEnvironment java.util.List ), (Ljava/util/List;)Ljava/util/List;)((SshRemoteEnvironment)environment)));
                new LoadableState.Value((Object)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)environment), (Object)this.getEnvironments().getValue()));
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Job openEnvironmentPage(String environmentId) {
        return BuildersKt.launch$default((CoroutineScope)this.pluginScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, environmentId, null){
            Object L$1;
            Object L$2;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SshRemoteProvider this$0;
            final /* synthetic */ String $environmentId;
            {
                this.this$0 = $receiver;
                this.$environmentId = $environmentId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 /* !! */  = ((LoadableState)this.this$0.getEnvironments().getValue()).takeIfValue();
                        if (v0 /* !! */  == null || (v0 /* !! */  = (List)v0 /* !! */ .getValue()) == null) break;
                        var3_4 = (Iterable)v0 /* !! */ ;
                        var4_5 /* !! */  = this.$environmentId;
                        var5_6 = var3_4;
                        for (T var7_11 : var5_6) {
                            it = (SshRemoteEnvironment)var7_11;
                            $i$a$-find-SshRemoteProvider$openEnvironmentPage$1$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)var4_5 /* !! */ )) continue;
                            v1 = var7_11;
                            ** GOTO lbl18
                        }
                        v1 = null;
lbl18:
                        // 2 sources

                        if ((v0 /* !! */  = (SshRemoteEnvironment)v1) == null) break;
                        var3_4 = v0 /* !! */ ;
                        var4_5 /* !! */  = this.this$0;
                        environment = var3_4;
                        $i$a$-let-SshRemoteProvider$openEnvironmentPage$1$2 = 0;
                        request = BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>((SshRemoteProvider)var4_5 /* !! */ , (SshRemoteEnvironment)environment, null){
                            int label;
                            final /* synthetic */ SshRemoteProvider this$0;
                            final /* synthetic */ SshRemoteEnvironment $environment;
                            {
                                this.this$0 = $receiver;
                                this.$environment = $environment;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = SshRemoteProvider.access$getEnvironmentUiPageManager$p(this.this$0).showEnvironmentPage(this.$environment.getId(), true, (Continuation)this);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((SshRemoteEnvironment)environment, null){
                            int label;
                            final /* synthetic */ SshRemoteEnvironment $environment;
                            {
                                this.$environment = $environment;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.$environment.connect((Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)environment);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                        this.I$0 = $i$a$-let-SshRemoteProvider$openEnvironmentPage$1$2;
                        this.label = 1;
                        v2 = request.await((Continuation)this);
                        if (v2 == var10_3) {
                            return var10_3;
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-let-SshRemoteProvider$openEnvironmentPage$1$2 = this.I$0;
                        request = (Deferred)this.L$2;
                        environment = (SshRemoteEnvironment)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public UiPage getNewEnvironmentUiPage() {
        return this.newEnvironmentPage;
    }

    public final void removeEnvironment(@NotNull SshRemoteEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, environment, null){
            int label;
            final /* synthetic */ SshRemoteProvider this$0;
            final /* synthetic */ SshRemoteEnvironment $environment;
            {
                this.this$0 = $receiver;
                this.$environment = $environment;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.getEnvironments().setValue((Object)((LoadableState)this.this$0.getEnvironments().getValue()).map(arg_0 -> removeEnvironment.1.invokeSuspend$lambda$0(this.$environment, arg_0)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final List invokeSuspend$lambda$0(SshRemoteEnvironment $environment, List envs) {
                return CollectionsKt.minus((Iterable)envs, (Object)((Object)$environment));
            }
        }), (int)3, null);
    }

    @NotNull
    public StateFlow<List<ActionDescription>> getAdditionalPluginActions() {
        List list2;
        RunnableActionDescription openSshSettingsAction2 = new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                this.label = SshRemoteProvider.access$getI18n$p($receiver).ptrl("SSH Settings");
            }

            public void run() {
                LocalizableString localizableString = SshRemoteProvider.access$getI18n$p(this.this$0).ptrl("SSH Timeout in seconds");
                String string = (String)SshRemoteProvider.access$getSettingsStore$p(this.this$0).get((Object)"timeoutSeconds");
                if (string == null) {
                    string = "10";
                }
                TextFieldMutable timeoutField = TextFieldKt.TextField$default((LocalizableString)localizableString, (String)string, (TextType)TextType.Integer, (boolean)false, null, null, additionalPluginActions.openSshSettingsAction.1::run$lambda$0, (int)56, null);
                Function1 validator = arg_0 -> additionalPluginActions.openSshSettingsAction.1.run$lambda$1(this.this$0, arg_0);
                String currentConfigPath = (String)SshRemoteProvider.access$getSshConfigPathProvider$p(this.this$0).getCurrentConfigPath().getValue();
                TextFieldMutable configPathField = TextFieldKt.TextField$default((LocalizableString)SshRemoteProvider.access$getI18n$p(this.this$0).ptrl("Custom configuration file path: "), (String)currentConfigPath, null, (boolean)false, null, null, (Function1)validator, (int)60, null);
                LocalizableString localizableString2 = SshRemoteProvider.access$getI18n$p(this.this$0).ptrl("SSH Settings");
                ((ToolboxUi)SshRemoteProvider.access$getServiceLocator$p(this.this$0).getService(ToolboxUi.class)).showUiPage(new UiPage(timeoutField, configPathField, this.this$0, (Function1<? super String, ? extends ValidationResult>)validator, localizableString2){
                    private final StateFlow<List<UiField>> fields;
                    final /* synthetic */ TextFieldMutable $timeoutField;
                    final /* synthetic */ TextFieldMutable $configPathField;
                    final /* synthetic */ SshRemoteProvider this$0;
                    final /* synthetic */ Function1<String, ValidationResult> $validator;
                    {
                        this.$timeoutField = $timeoutField;
                        this.$configPathField = $configPathField;
                        this.this$0 = $receiver;
                        this.$validator = $validator;
                        super($super_call_param$1);
                        Object[] objectArray = new TextFieldMutable[]{$timeoutField, $configPathField};
                        this.fields = new SingleStateFlow<List>(CollectionsKt.listOf((Object[])objectArray));
                    }

                    public StateFlow<List<UiField>> getFields() {
                        return this.fields;
                    }

                    public void afterHide() {
                        Integer n = StringsKt.toIntOrNull((String)((String)this.$timeoutField.getContentState().getValue()));
                        if (n == null) {
                            return;
                        }
                        int timeoutInt = n;
                        ((Map)SshRemoteProvider.access$getSettingsStore$p(this.this$0)).put("timeoutSeconds", String.valueOf(timeoutInt));
                        String path2 = (String)this.$configPathField.getContentState().getValue();
                        if (!Intrinsics.areEqual((Object)this.$validator.invoke((Object)path2), (Object)ValidationResult.Valid.INSTANCE)) {
                            SshRemoteProvider.access$getSshConfigPathProvider$p(this.this$0).setConfigPath("");
                        } else {
                            SshRemoteProvider.access$getSshConfigPathProvider$p(this.this$0).setConfigPath(path2);
                        }
                        SshRemoteProvider.access$refreshTimeout(this.this$0);
                    }
                });
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            private static final ValidationResult run$lambda$0(String it) {
                ValidationResult validationResult;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Companion companion = SshRemoteProvider.Companion;
                String text$iv = it;
                boolean $i$f$validateIntField = false;
                try {
                    String it2 = text$iv;
                    boolean bl = false;
                    Integer.parseInt(it2);
                    validationResult = (ValidationResult)ValidationResult.Valid.INSTANCE;
                }
                catch (NumberFormatException numberFormatException) {
                    validationResult = (ValidationResult)new ValidationResult.Invalid((LocalizableString)LocalizableStringExKt.trl("Invalid number"));
                }
                return validationResult;
            }

            private static final ValidationResult run$lambda$1(SshRemoteProvider this$0, String v) {
                ValidationResult validationResult;
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                if (!StringsKt.isBlank((CharSequence)v)) {
                    Path path2 = Paths.get(v, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    Path path3 = path2;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        Path path4 = Paths.get(v, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                        path3 = path4;
                        linkOptionArray = new LinkOption[]{};
                        validationResult = Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? (ValidationResult)new ValidationResult.Invalid(SshRemoteProvider.access$getI18n$p(this$0).ptrl("Provided file is a directory")) : (ValidationResult)ValidationResult.Valid.INSTANCE;
                    } else {
                        validationResult = (ValidationResult)new ValidationResult.Invalid(SshRemoteProvider.access$getI18n$p(this$0).ptrl("Provided path doesn't exist"));
                    }
                } else {
                    validationResult = (ValidationResult)ValidationResult.Valid.INSTANCE;
                }
                return validationResult;
            }
        };
        RunnableActionDescription openSshConfigAction2 = new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                this.label = SshRemoteProvider.access$getI18n$p($receiver).ptrl("Open SSH config location");
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public void run() {
                LocalDesktopManager localDesktopManager = SshRemoteProvider.access$getLocalDesktopManager$p(this.this$0);
                Path path2 = Paths.get((String)SshRemoteProvider.access$getSshConfigPathProvider$p(this.this$0).getCurrentConfigPath().getValue(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                localDesktopManager.openPath(path2);
            }
        };
        RunnableActionDescription refreshHintsAction2 = new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                this.label = SshRemoteProvider.access$getI18n$p($receiver).ptrl("Refresh imported SSH configurations");
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public void run() {
                SshRemoteProvider.access$scheduleRefreshIntellijImports(this.this$0);
                SshRemoteProvider.access$scheduleRefreshOpenSshImports(this.this$0);
            }
        };
        List $this$_get_additionalPluginActions__u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$_get_additionalPluginActions__u24lambda_u240.add(openSshSettingsAction2);
        $this$_get_additionalPluginActions__u24lambda_u240.add(refreshHintsAction2);
        if (this.fileSystem.exists(Path.Companion.get$default((Path.Companion)okio.Path.Companion, (String)((String)this.sshConfigPathProvider.getCurrentConfigPath().getValue()), (boolean)false, (int)1, null))) {
            $this$_get_additionalPluginActions__u24lambda_u240.add(openSshConfigAction2);
        }
        List list3 = CollectionsKt.build((List)list2);
        return new SingleStateFlow<List>(list3);
    }

    @Nullable
    protected Object handleCustomUri(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.pluginScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, this, null){
            Object L$0;
            int label;
            final /* synthetic */ URI $uri;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.$uri = $uri;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE]], but top level block is 11[SWITCH]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(SshRemoteProvider this$0, SshCustomLinkHandler.Result $result, String envId) {
                SshRemoteProvider.access$getClientHelper$p(this$0).connectToIde(envId, $result.getIdeHint(), $result.getProjectHint());
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final StateFlow<List<EnvironmentHint>> hintsState() {
        return FlowKt.stateIn((Flow)FlowKt.mapLatest((Flow)((Flow)this.importedConfigurations), (Function2)((Function2)new Function2<List<? extends ImportedSshConfigs>, Continuation<? super List<? extends hintsState.1.1.1>>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                List list2 = (List)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$flatMapTo$iv$iv;
                        void $this$flatMap$iv;
                        void imports;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable iterable = (Iterable)imports;
                        SshRemoteProvider sshRemoteProvider = this.this$0;
                        boolean $i$f$flatMap = false;
                        void var6_6 = $this$flatMap$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$flatMapTo = false;
                        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                            void $this$mapTo$iv$iv;
                            ImportedSshConfigs configs = (ImportedSshConfigs)element$iv$iv;
                            boolean bl = false;
                            Iterable $this$map$iv = configs.getConfigs();
                            boolean $i$f$map = false;
                            Iterable iterable2 = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void config2;
                                ImportedSshConfig importedSshConfig = (ImportedSshConfig)item$iv$iv;
                                Collection collection = destination$iv$iv2;
                                boolean bl2 = false;
                                String hintId = configs.getSource() + "_" + config2.getId();
                                collection.add(new EnvironmentHint(hintId, (ImportedSshConfig)config2, configs, sshRemoteProvider){
                                    private final String id;
                                    private final String name;
                                    private final String description;
                                    private final List<ProjectStub> projectStubs;
                                    private final String environmentId;
                                    private final String source;
                                    final /* synthetic */ String $hintId;
                                    final /* synthetic */ ImportedSshConfig $config;
                                    final /* synthetic */ SshRemoteProvider this$0;
                                    {
                                        this.$hintId = $hintId;
                                        this.$config = $config;
                                        this.this$0 = $receiver;
                                        this.id = $hintId;
                                        String string = $config.getAlias();
                                        if (string == null) {
                                            string = com.jetbrains.toolbox.gateway.ssh.presentation.UtilKt.defaultPresentableName($config.getSshConnectionInfo());
                                        }
                                        this.name = string;
                                        this.description = "From " + $configs.getSource();
                                        this.projectStubs = $config.getRecentProjects();
                                        this.environmentId = SshRemoteEnvironment.Companion.toUsernameHostPortString($config.getSshConnectionInfo());
                                        this.source = $configs.getSourceLabel();
                                    }

                                    public String getId() {
                                        return this.id;
                                    }

                                    public String getName() {
                                        return this.name;
                                    }

                                    public String getDescription() {
                                        return this.description;
                                    }

                                    public List<ProjectStub> getProjectStubs() {
                                        return this.projectStubs;
                                    }

                                    public String getEnvironmentId() {
                                        return this.environmentId;
                                    }

                                    public String getSource() {
                                        return this.source;
                                    }

                                    public void accept() {
                                        SshRemoteProvider.access$createEnvironment(this.this$0, null, UtilKt.toEndpoint(this.$config.getSshConnectionInfo(), this.$config.getAlias()), hintsState.1.1.1::accept$lambda$0, (arg_0, arg_1) -> hintsState.1.1.1.accept$lambda$1(this.$config, this.this$0, arg_0, arg_1), false);
                                    }

                                    public void reject() {
                                        SshRemoteProvider.access$getRejectedHintsCache$p(this.this$0).reject(this.$hintId);
                                    }

                                    private static final Unit accept$lambda$0() {
                                        return Unit.INSTANCE;
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    private static final Unit accept$lambda$1(ImportedSshConfig $config, SshRemoteProvider this$0, String envId, EnvironmentError error2) {
                                        Intrinsics.checkNotNullParameter((Object)envId, (String)"envId");
                                        if (error2 == null) {
                                            void $this$mapNotNullTo$iv$iv;
                                            Iterable $this$mapNotNull$iv = $config.getRecentProjects();
                                            boolean $i$f$mapNotNull = false;
                                            Iterable iterable = $this$mapNotNull$iv;
                                            Collection destination$iv$iv = new ArrayList<E>();
                                            boolean $i$f$mapNotNullTo = false;
                                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                            boolean $i$f$forEach = false;
                                            Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                                            while (iterator2.hasNext()) {
                                                String it$iv$iv;
                                                T element$iv$iv$iv;
                                                T element$iv$iv = element$iv$iv$iv = iterator2.next();
                                                boolean bl = false;
                                                ProjectStub it = (ProjectStub)element$iv$iv;
                                                boolean bl2 = false;
                                                if (it.getIdePath() == null) continue;
                                                boolean bl3 = false;
                                                destination$iv$iv.add(it$iv$iv);
                                            }
                                            List idePaths = (List)destination$iv$iv;
                                            SshRemoteProvider.access$getIdePathService$p(this$0).registerIdePaths(envId, idePaths);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                });
                            }
                            Iterable list$iv$iv = (List)destination$iv$iv2;
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(List<ImportedSshConfigs> p1, Continuation<? super List<hintsState.1.1.1>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.pluginScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)CollectionsKt.emptyList());
    }

    public void refresh() {
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final List addEnvironment$lambda$1(SshRemoteEnvironment $environment, List envs) {
        Intrinsics.checkNotNullParameter((Object)envs, (String)"envs");
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)$environment)), (Iterable)envs);
    }

    public static final /* synthetic */ StateFlow access$getOpenSshImportedConfigsProviderState$p(SshRemoteProvider $this) {
        return $this.openSshImportedConfigsProviderState;
    }

    public static final /* synthetic */ MutableStateFlow access$getOpensshImportedConfigurations$p(SshRemoteProvider $this) {
        return $this.opensshImportedConfigurations;
    }

    public static final /* synthetic */ MutableStateFlow access$getIntellijImportedConfigurations$p(SshRemoteProvider $this) {
        return $this.intellijImportedConfigurations;
    }

    public static final /* synthetic */ ImportedSshConfigProvider access$getIntellijImportProvider$p(SshRemoteProvider $this) {
        return $this.intellijImportProvider;
    }

    public static final /* synthetic */ Json access$getJson$p(SshRemoteProvider $this) {
        return $this.json;
    }

    public static final /* synthetic */ PluginSettingsStore access$getSettingsStore$p(SshRemoteProvider $this) {
        return $this.settingsStore;
    }

    public static final /* synthetic */ StateFlow access$getCurrentHintsAll$p(SshRemoteProvider $this) {
        return $this.currentHintsAll;
    }

    public static final /* synthetic */ RejectedHintsCache access$getRejectedHintsCache$p(SshRemoteProvider $this) {
        return $this.rejectedHintsCache;
    }

    public static final /* synthetic */ EnvironmentHintService access$getEnvironmentHintService$p(SshRemoteProvider $this) {
        return $this.environmentHintService;
    }

    public static final /* synthetic */ LocalizableStringFactory access$getI18n$p(SshRemoteProvider $this) {
        return $this.i18n;
    }

    public static final /* synthetic */ Object access$addEnvironment(SshRemoteProvider $this, SshRemoteEnvironment environment, String singleInputValue, Endpoint endpoint, boolean withValidation, Continuation $completion) {
        return $this.addEnvironment(environment, singleInputValue, endpoint, withValidation, (Continuation<? super EnvironmentError>)$completion);
    }

    public static final /* synthetic */ EnvironmentUiPageManager access$getEnvironmentUiPageManager$p(SshRemoteProvider $this) {
        return $this.environmentUiPageManager;
    }

    public static final /* synthetic */ SshConfigPathProvider access$getSshConfigPathProvider$p(SshRemoteProvider $this) {
        return $this.sshConfigPathProvider;
    }

    public static final /* synthetic */ ServiceLocator access$getServiceLocator$p(SshRemoteProvider $this) {
        return $this.serviceLocator;
    }

    public static final /* synthetic */ void access$refreshTimeout(SshRemoteProvider $this) {
        $this.refreshTimeout();
    }

    public static final /* synthetic */ LocalDesktopManager access$getLocalDesktopManager$p(SshRemoteProvider $this) {
        return $this.localDesktopManager;
    }

    public static final /* synthetic */ void access$scheduleRefreshIntellijImports(SshRemoteProvider $this) {
        $this.scheduleRefreshIntellijImports();
    }

    public static final /* synthetic */ void access$scheduleRefreshOpenSshImports(SshRemoteProvider $this) {
        $this.scheduleRefreshOpenSshImports();
    }

    public static final /* synthetic */ InternalDialogService access$getDialogService$p(SshRemoteProvider $this) {
        return $this.dialogService;
    }

    public static final /* synthetic */ SshNewEnvPage access$getNewEnvironmentPage$p(SshRemoteProvider $this) {
        return $this.newEnvironmentPage;
    }

    public static final /* synthetic */ ToolboxUi access$getToolboxUi$p(SshRemoteProvider $this) {
        return $this.toolboxUi;
    }

    public static final /* synthetic */ ClientHelper access$getClientHelper$p(SshRemoteProvider $this) {
        return $this.clientHelper;
    }

    public static final /* synthetic */ Job access$createEnvironment(SshRemoteProvider $this, String singleInputValue, Endpoint endpoint, Function0 onStart, Function2 onEnd, boolean withValidation) {
        return $this.createEnvironment(singleInputValue, endpoint, (Function0<Unit>)onStart, (Function2<? super String, ? super EnvironmentError, Unit>)onEnd, withValidation);
    }

    public static final /* synthetic */ IdePathsService access$getIdePathService$p(SshRemoteProvider $this) {
        return $this.idePathService;
    }

    public static final /* synthetic */ OpenSshImportedConfigsProviderFactory access$getOpenSshImportedConfigsProviderFactory$p(SshRemoteProvider $this) {
        return $this.openSshImportedConfigsProviderFactory;
    }

    public static final /* synthetic */ Job access$openEnvironmentPage(SshRemoteProvider $this, String environmentId) {
        return $this.openEnvironmentPage(environmentId);
    }

    public static final class Companion {
        private Companion() {
        }

        private final ValidationResult validateIntField(String text2, Function1<? super String, Unit> parser) {
            ValidationResult validationResult;
            boolean $i$f$validateIntField = false;
            try {
                parser.invoke((Object)text2);
                validationResult = (ValidationResult)ValidationResult.Valid.INSTANCE;
            }
            catch (NumberFormatException numberFormatException) {
                validationResult = (ValidationResult)new ValidationResult.Invalid((LocalizableString)LocalizableStringExKt.trl("Invalid number"));
            }
            return validationResult;
        }

        @NotNull
        public final ImageResource getSshLogo() {
            return sshLogo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

