/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.gateway.ssh.SshAgentConnectionHandle;
import com.jetbrains.toolbox.gateway.ssh.SshForwardedConnectionHandle;
import com.jetbrains.toolbox.gateway.ssh.SshProcess;
import java.net.InetAddress;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SshPortForwarder {
    @NotNull
    public static final SshPortForwarder INSTANCE = new SshPortForwarder();

    private SshPortForwarder() {
    }

    @NotNull
    public final SshForwardedConnectionHandle forwardPort(@NotNull InetAddress localAddress, @NotNull InetAddress remoteAddress2, int remotePort, @NotNull SshProcess sshProcess, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Intrinsics.checkNotNullParameter((Object)remoteAddress2, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)sshProcess, (String)"sshProcess");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        return new SshForwardedConnectionHandle(localAddress, remoteAddress2, remotePort, sshProcess, coroutineScope);
    }

    @NotNull
    public final SshAgentConnectionHandle forwardAgentConnection(@NotNull InetAddress localAddress, @NotNull InetAddress remoteAddress2, int remotePort, @Nullable String authToken, @NotNull SshProcess sshProcess, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        Intrinsics.checkNotNullParameter((Object)remoteAddress2, (String)"remoteAddress");
        Intrinsics.checkNotNullParameter((Object)sshProcess, (String)"sshProcess");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        return new SshAgentConnectionHandle(localAddress, remoteAddress2, remotePort, authToken, sshProcess, coroutineScope);
    }
}

