/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.Keychain;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSshPasswordStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshPasswordStore.kt\ncom/jetbrains/toolbox/gateway/ssh/SshPasswordStore\n+ 2 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n7#2,2:62\n9#2,5:65\n222#3:64\n205#3:74\n72#4,2:70\n1#5:72\n1#5:73\n*S KotlinDebug\n*F\n+ 1 SshPasswordStore.kt\ncom/jetbrains/toolbox/gateway/ssh/SshPasswordStore\n*L\n27#1:62,2\n27#1:65,5\n27#1:64\n43#1:74\n32#1:70,2\n32#1:72\n*E\n"})
public final class SshPasswordStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Keychain keychain;
    @NotNull
    private final ConcurrentHashMap<DevEnvironmentId, MutableStateFlow<Boolean>> stateMap;
    @NotNull
    private static final String KEYCHAIN_PREFIX = "GATEWAY_SSH";

    public SshPasswordStore(@NotNull Keychain keychain) {
        Intrinsics.checkNotNullParameter((Object)keychain, (String)"keychain");
        this.keychain = keychain;
        this.stateMap = new ConcurrentHashMap();
    }

    private final String getPasswordKey(DevEnvironmentId devEnvironmentId) {
        return "GATEWAY_SSH_PASSWORD_" + devEnvironmentId.getProviderId-rwbms5E() + "_" + devEnvironmentId.getEnvironmentId();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getKeychainValue(DevEnvironmentId devEnvironmentId) {
        Map map2;
        String keychainValue;
        String string = Keychain.fetchFromKeychainBlocking$default(this.keychain, this.getPasswordKey(devEnvironmentId), null, 2, null);
        String string2 = keychainValue = string != null ? StringExtensionsKt.getNullIfEmpty(string) : null;
        if (string2 != null) {
            Object object;
            String it = string2;
            boolean bl = false;
            boolean $i$f$catching = false;
            try {
                void this_$iv;
                boolean bl2 = false;
                Json json2 = (Json)Json.Default;
                String string$iv = it;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                object = Result.constructor-impl((Object)((Map)this_$iv.decodeFromString((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), string$iv)));
            }
            catch (CancellationException c$iv) {
                throw c$iv;
            }
            catch (Throwable t$iv) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
            }
            Object object2 = object;
            map2 = (Map)(Result.isFailure-impl((Object)object2) ? null : object2);
        } else {
            map2 = null;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final MutableStateFlow<Boolean> getMutableState(DevEnvironmentId devEnvironmentId) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.stateMap;
        DevEnvironmentId key$iv = devEnvironmentId;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            MutableStateFlow default$iv = StateFlowKt.MutableStateFlow((Object)this.containsPassword(devEnvironmentId));
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (MutableStateFlow)object;
    }

    @Nullable
    public final String getPassword(@NotNull DevEnvironmentId devEnvironmentId, @NotNull String userHost) {
        Map<String, String> elements;
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        Intrinsics.checkNotNullParameter((Object)userHost, (String)"userHost");
        Map<String, String> map2 = elements = this.getKeychainValue(devEnvironmentId);
        return map2 != null ? map2.get(userHost) : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void storePassword(@NotNull DevEnvironmentId devEnvironmentId, @NotNull String userHost, @NotNull String password) {
        void this_$iv;
        Map map2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
                Intrinsics.checkNotNullParameter((Object)userHost, (String)"userHost");
                Intrinsics.checkNotNullParameter((Object)password, (String)"password");
                Map elements = this.getKeychainValue(devEnvironmentId);
                map2 = elements;
                if (map2 == null) break block2;
                Map it = map2;
                boolean bl = false;
                Map map3 = MapsKt.plus((Map)it, (Pair)TuplesKt.to((Object)userHost, (Object)password));
                map2 = map3;
                if (map3 != null) break block3;
            }
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)userHost, (Object)password));
        }
        Map newElements = map2;
        Json json2 = (Json)Json.Default;
        Map value$iv = newElements;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String serialized = this_$iv.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), (Object)value$iv);
        Keychain.writeToKeychainBlocking$default(this.keychain, this.getPasswordKey(devEnvironmentId), serialized, null, 4, null);
        this.getMutableState(devEnvironmentId).setValue((Object)true);
    }

    public final void forgetPassword(@NotNull DevEnvironmentId devEnvironmentId) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        Keychain.writeToKeychainBlocking$default(this.keychain, this.getPasswordKey(devEnvironmentId), "", null, 4, null);
        this.getMutableState(devEnvironmentId).setValue((Object)false);
    }

    public final boolean containsPassword(@NotNull DevEnvironmentId devEnvironmentId) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        String string = Keychain.fetchFromKeychainBlocking$default(this.keychain, this.getPasswordKey(devEnvironmentId), null, 2, null);
        return (string != null ? StringExtensionsKt.getNullIfEmpty(string) : null) != null;
    }

    @NotNull
    public final StateFlow<Boolean> getState(@NotNull DevEnvironmentId devEnvironmentId) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        return FlowKt.asStateFlow(this.getMutableState(devEnvironmentId));
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

