/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.BackgroundTaskScheduler;
import com.jetbrains.toolbox.StandardPathsKt;
import com.jetbrains.toolbox.common.datetime.InstantExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.ssh.SshOutputDumpImpl;
import com.jetbrains.toolbox.gateway.ssh.SshOutputDumpImplKt;
import com.jetbrains.toolbox.openssh.OpenSshProcess;
import java.io.Closeable;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSshOutputDumpImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshOutputDumpImpl.kt\ncom/jetbrains/toolbox/gateway/ssh/SshOutputDumpImpl\n+ 2 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n7#2,2:105\n9#2,5:143\n7#2,7:150\n80#3:107\n165#3:108\n81#3:109\n82#3:114\n52#4,4:110\n60#4,10:115\n56#4,18:125\n1056#5:148\n1869#5:149\n1870#5:158\n774#5:159\n865#5,2:160\n1#6:157\n*S KotlinDebug\n*F\n+ 1 SshOutputDumpImpl.kt\ncom/jetbrains/toolbox/gateway/ssh/SshOutputDumpImpl\n*L\n56#1:105,2\n56#1:143,5\n89#1:150,7\n57#1:107\n57#1:108\n57#1:109\n57#1:114\n57#1:110,4\n57#1:115,10\n57#1:125,18\n86#1:148\n88#1:149\n88#1:158\n101#1:159\n101#1:160,2\n*E\n"})
public final class SshOutputDumpImpl {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Clock clock;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Path DumpDirectory;

    public SshOutputDumpImpl(@NotNull FileSystem fileSystem, @NotNull BackgroundTaskScheduler backgroundTaskScheduler, @NotNull Clock clock, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskScheduler, (String)"backgroundTaskScheduler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.fileSystem = fileSystem;
        this.clock = clock;
        this.coroutineScope = coroutineScope;
        this.DumpDirectory = StandardPathsKt.getLogsDirectory().resolve("ssh_outputs");
        this.fileSystem.createDirectories(this.DumpDirectory);
        this.cleanup();
        BackgroundTaskScheduler.scheduleRepeatingTask-FHKeTTw$default(backgroundTaskScheduler, this.coroutineScope, new BackgroundTaskScheduler.TaskSchedule.Relaxed(SshOutputDumpImplKt.access$getMinCleanupDelay$p(), SshOutputDumpImplKt.access$getMaxCleanupDelay$p(), null), null, null, null, (Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SshOutputDumpImpl this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.cleanup();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, 28, null);
    }

    public final void dumpOutput(@NotNull DevEnvironmentId environmentId, @NotNull OpenSshProcess process2) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        String stderrFileName = this.generateFileName(environmentId, true);
        String stdoutFileName = this.generateFileName(environmentId, false);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, stderrFileName, process2, stdoutFileName, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SshOutputDumpImpl this$0;
            final /* synthetic */ String $stderrFileName;
            final /* synthetic */ OpenSshProcess $process;
            final /* synthetic */ String $stdoutFileName;
            {
                this.this$0 = $receiver;
                this.$stderrFileName = $stderrFileName;
                this.$process = $process;
                this.$stdoutFileName = $stdoutFileName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$stderrFileName, this.$process, null){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            int label;
                            final /* synthetic */ SshOutputDumpImpl this$0;
                            final /* synthetic */ String $stderrFileName;
                            final /* synthetic */ OpenSshProcess $process;
                            {
                                this.this$0 = $receiver;
                                this.$stderrFileName = $stderrFileName;
                                this.$process = $process;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var4_3 = this.$process.getCommand();
                                        var3_4 = SshOutputDumpImpl.access$getDumpDirectory$p(this.this$0).resolve(this.$stderrFileName);
                                        var2_5 = this.this$0;
                                        this.L$0 = var2_5;
                                        this.L$1 = var3_4;
                                        this.L$2 = var4_3;
                                        this.label = 1;
                                        v0 = this.$process.getErrorOutput((Continuation<? super Flow<String>>)((Continuation)this));
                                        if (v0 == var6_2) {
                                            return var6_2;
                                        }
                                        ** GOTO lbl22
                                    }
                                    case 1: {
                                        var4_3 = (String[])this.L$2;
                                        var3_4 = (Path)this.L$1;
                                        var2_5 = (SshOutputDumpImpl)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl22:
                                        // 2 sources

                                        var5_6 = v0;
                                        this.L$0 = null;
                                        this.L$1 = null;
                                        this.L$2 = null;
                                        this.label = 2;
                                        v1 = SshOutputDumpImpl.access$dumpFlow(var2_5, var3_4, var4_3, (Flow)var5_6, (Continuation)this);
                                        if (v1 == var6_2) {
                                            return var6_2;
                                        }
                                        ** GOTO lbl34
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl34:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$stdoutFileName, this.$process, null){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            int label;
                            final /* synthetic */ SshOutputDumpImpl this$0;
                            final /* synthetic */ String $stdoutFileName;
                            final /* synthetic */ OpenSshProcess $process;
                            {
                                this.this$0 = $receiver;
                                this.$stdoutFileName = $stdoutFileName;
                                this.$process = $process;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var4_3 = this.$process.getCommand();
                                        var3_4 = SshOutputDumpImpl.access$getDumpDirectory$p(this.this$0).resolve(this.$stdoutFileName);
                                        var2_5 = this.this$0;
                                        this.L$0 = var2_5;
                                        this.L$1 = var3_4;
                                        this.L$2 = var4_3;
                                        this.label = 1;
                                        v0 = this.$process.getOutput((Continuation<? super Flow<String>>)((Continuation)this));
                                        if (v0 == var6_2) {
                                            return var6_2;
                                        }
                                        ** GOTO lbl22
                                    }
                                    case 1: {
                                        var4_3 = (String[])this.L$2;
                                        var3_4 = (Path)this.L$1;
                                        var2_5 = (SshOutputDumpImpl)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl22:
                                        // 2 sources

                                        var5_6 = v0;
                                        this.L$0 = null;
                                        this.L$1 = null;
                                        this.L$2 = null;
                                        this.label = 2;
                                        v1 = SshOutputDumpImpl.access$dumpFlow(var2_5, var3_4, var4_3, (Flow)var5_6, (Continuation)this);
                                        if (v1 == var6_2) {
                                            return var6_2;
                                        }
                                        ** GOTO lbl34
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl34:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object dumpFlow(Path file, String[] args, Flow<String> flow, Continuation<? super Unit> $completion) {
        if (!($completion instanceof dumpFlow.1)) ** GOTO lbl-1000
        var23_5 = $completion;
        if ((var23_5.label & -2147483648) != 0) {
            var23_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                int I$5;
                int I$6;
                /* synthetic */ Object result;
                final /* synthetic */ SshOutputDumpImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SshOutputDumpImpl.access$dumpFlow(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$catching = 0;
                $i$a$-catching-SshOutputDumpImpl$dumpFlow$2 = 0;
                var7_12 = this.fileSystem;
                file$iv = file;
                mustCreate$iv = 0;
                $i$f$-write = 0;
                $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, false));
                $i$f$use = 0;
                thrown$iv$iv = null;
                it$iv = (BufferedSink)$this$use$iv$iv;
                $i$a$-use-FileSystem$write$1$iv = 0;
                $this$dumpFlow_u24lambda_u240_u240 = it$iv;
                $i$a$--write$default-SshOutputDumpImpl$dumpFlow$2$1 = 0;
                $this$dumpFlow_u24lambda_u240_u240.writeString(ArraysKt.joinToString$default((Object[])args, (CharSequence)", ", (CharSequence)"Command: ", (CharSequence)"\n", (int)0, null, null, (int)56, null), Charsets.UTF_8);
                $continuation.L$0 = file;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)args);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)flow);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$iv);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)file$iv);
                $continuation.L$5 = $this$use$iv$iv;
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)it$iv);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$dumpFlow_u24lambda_u240_u240);
                $continuation.I$0 = $i$f$catching;
                $continuation.I$1 = $i$a$-catching-SshOutputDumpImpl$dumpFlow$2;
                $continuation.I$2 = mustCreate$iv;
                $continuation.I$3 = $i$f$-write;
                $continuation.I$4 = $i$f$use;
                $continuation.I$5 = $i$a$-use-FileSystem$write$1$iv;
                $continuation.I$6 = $i$a$--write$default-SshOutputDumpImpl$dumpFlow$2$1;
                $continuation.label = 1;
                v0 = flow.collect(new FlowCollector($this$dumpFlow_u24lambda_u240_u240){
                    final /* synthetic */ BufferedSink $this_write;
                    {
                        this.$this_write = $receiver;
                    }

                    public final Object emit(String it, Continuation<? super Unit> $completion) {
                        this.$this_write.writeString(it + "\n", Charsets.UTF_8);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation);
                ** if (v0 != var24_7) goto lbl51
lbl50:
                // 1 sources

                return var24_7;
lbl51:
                // 1 sources

                ** GOTO lbl74
            }
            case 1: {
                $i$a$--write$default-SshOutputDumpImpl$dumpFlow$2$1 = $continuation.I$6;
                $i$a$-use-FileSystem$write$1$iv = $continuation.I$5;
                $i$f$use = $continuation.I$4;
                $i$f$-write = $continuation.I$3;
                mustCreate$iv = $continuation.I$2;
                $i$a$-catching-SshOutputDumpImpl$dumpFlow$2 = $continuation.I$1;
                $i$f$catching = $continuation.I$0;
                $this$dumpFlow_u24lambda_u240_u240 = (BufferedSink)$continuation.L$7;
                it$iv = (BufferedSink)$continuation.L$6;
                thrown$iv$iv = null;
                $this$use$iv$iv = (Closeable)$continuation.L$5;
                file$iv = (Path)$continuation.L$4;
                $this$iv = (FileSystem)$continuation.L$3;
                flow = (Flow)$continuation.L$2;
                args = (String[])$continuation.L$1;
                file = (Path)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl74:
                    // 2 sources

                    var15_27 = Unit.INSTANCE;
                    try {
                        v1 = $this$use$iv$iv;
                        if (v1 != null) {
                            v1.close();
                        }
                        ** GOTO lbl104
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                    ** GOTO lbl104
                    {
                        catch (Throwable t$iv$iv) {
                            try {
                                thrown$iv$iv = t$iv$iv;
                                var15_27 = null;
                            }
                            catch (Throwable var18_35) {
                                throw var18_35;
                            }
                            finally {
                                try {
                                    v2 = $this$use$iv$iv;
                                    if (v2 != null) {
                                        v2.close();
                                    }
                                }
                                catch (Throwable t$iv$iv) {
                                    if (thrown$iv$iv != null) ** GOTO lbl102
                                    thrown$iv$iv = t$iv$iv;
                                    ** GOTO lbl103
lbl102:
                                    // 1 sources

                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
                                }
lbl103:
                                // 3 sources

                            }
                        }
                    }
lbl104:
                    // 3 sources

                    result$iv$iv = var15_27;
                    v3 = thrown$iv$iv;
                    if (v3 != null) {
                        throw v3;
                    }
                    var20_37 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (CancellationException c$iv) {
                    throw c$iv;
                }
                catch (Throwable t$iv) {
                    var20_37 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                }
                var5_9 = var20_37;
                v4 = Result.exceptionOrNull-impl((Object)var5_9);
                if (v4 != null) {
                    error = v4;
                    $i$a$-getOrElse-SshOutputDumpImpl$dumpFlow$3 = false;
                    Logger.INSTANCE.error(error, "Failed to dump output to file: " + file);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String environmentFilePrefix(DevEnvironmentId environmentId) {
        CharSequence charSequence = environmentId.getProviderId-rwbms5E();
        Object object = new Regex("\\W");
        String string = "";
        String providerNormalized = object.replace(charSequence, string);
        object = environmentId.getEnvironmentId();
        string = new Regex("\\W");
        String string2 = "";
        String environmentNormalized = string.replace((CharSequence)object, string2);
        return providerNormalized + "_" + environmentNormalized;
    }

    private final String generateFileName(DevEnvironmentId environmentId, boolean isErr) {
        Instant instant = this.clock.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss_SSS");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        String datePart = InstantExtensionsKt.toString$default(instant, dateTimeFormatter, null, 2, null);
        return this.environmentFilePrefix(environmentId) + "_" + datePart + "." + (isErr ? "err" : "out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup() {
        block9: {
            Logger.INSTANCE.debug("Cleaning up SSH process outputs");
            try {
                List list2;
                if (this.fileSystem.listOrNull(this.DumpDirectory) == null) {
                    return;
                }
                List files = list2;
                Logger.INSTANCE.debug("Found " + files.size() + " files in " + this.DumpDirectory);
                if (files.size() <= SshOutputDumpImplKt.access$getFilesCountLimit$p()) break block9;
                int diff = files.size() - SshOutputDumpImplKt.access$getFilesCountLimit$p();
                Logger.INSTANCE.debug("Will need to delete " + diff + " files from " + this.DumpDirectory);
                Iterable $this$sortedBy$iv = files;
                boolean $i$f$sortedBy = false;
                Iterable $this$forEach$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
                    final /* synthetic */ SshOutputDumpImpl this$0;
                    {
                        this.this$0 = sshOutputDumpImpl;
                    }

                    public final int compare(T a, T b) {
                        Path path2 = (Path)a;
                        boolean bl = false;
                        Comparable comparable = SshOutputDumpImpl.access$getFileSystem$p(this.this$0).metadata(path2).getLastModifiedAtMillis();
                        path2 = (Path)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)SshOutputDumpImpl.access$getFileSystem$p(this.this$0).metadata(path2).getLastModifiedAtMillis());
                    }
                }), (int)diff);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Throwable error2;
                    Object object;
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    boolean $i$f$catching = false;
                    try {
                        boolean bl2 = false;
                        this.fileSystem.delete(it, false);
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (CancellationException c$iv) {
                        throw c$iv;
                    }
                    catch (Throwable t$iv) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                    }
                    Object object2 = object;
                    if (Result.exceptionOrNull-impl((Object)object2) == null) continue;
                    boolean bl3 = false;
                    Logger.INSTANCE.warn(error2, "Failed to cleanup SSH output log: " + it);
                }
            }
            finally {
                Logger.INSTANCE.debug("SSH process outputs cleanup finished");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> getFilesForEnvironment(@NotNull DevEnvironmentId environmentId) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        String prefix = this.environmentFilePrefix(environmentId) + "_";
        List list3 = this.fileSystem.listOrNull(this.DumpDirectory);
        if (list3 != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list3;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it.name(), (String)prefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public static final /* synthetic */ Object access$dumpFlow(SshOutputDumpImpl $this, Path file, String[] args, Flow flow2, Continuation $completion) {
        return $this.dumpFlow(file, args, (Flow<String>)flow2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Path access$getDumpDirectory$p(SshOutputDumpImpl $this) {
        return $this.DumpDirectory;
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(SshOutputDumpImpl $this) {
        return $this.fileSystem;
    }
}

