/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.WindowManager;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentManager;
import com.jetbrains.toolbox.gateway.DevEnvironmentProvider;
import com.jetbrains.toolbox.gateway.GatewayProtocolHandler;
import com.jetbrains.toolbox.gateway.GatewayProtocolHandlerKt;
import com.jetbrains.toolbox.gateway.PluginId;
import com.jetbrains.toolbox.gateway.PluginManager;
import com.jetbrains.toolbox.gateway.ssh.RemoteDevConnectionProtocolHandler;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.manager.SnackbarManager;
import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nRemoteDevConnectionProtocolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDevConnectionProtocolHandler.kt\ncom/jetbrains/toolbox/gateway/ssh/RemoteDevConnectionProtocolHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,69:1\n774#2:70\n865#2,2:71\n774#2:73\n865#2,2:74\n1#3:76\n375#4:77\n*S KotlinDebug\n*F\n+ 1 RemoteDevConnectionProtocolHandler.kt\ncom/jetbrains/toolbox/gateway/ssh/RemoteDevConnectionProtocolHandler\n*L\n27#1:70\n27#1:71,2\n35#1:73\n35#1:74,2\n60#1:77\n*E\n"})
public final class RemoteDevConnectionProtocolHandler
implements ProtocolHandler {
    @NotNull
    private final DevEnvironmentManager environmentManager;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final SnackbarManager snackbarManager;
    @NotNull
    private final WindowManager windowManager;
    @NotNull
    private final I18n i18n;
    private final boolean impliesUiMode;

    public RemoteDevConnectionProtocolHandler(@NotNull DevEnvironmentManager environmentManager, @NotNull PluginManager pluginManager, @NotNull SnackbarManager snackbarManager, @NotNull WindowManager windowManager, @NotNull I18n i18n) {
        Intrinsics.checkNotNullParameter((Object)environmentManager, (String)"environmentManager");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)snackbarManager, (String)"snackbarManager");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        this.environmentManager = environmentManager;
        this.pluginManager = pluginManager;
        this.snackbarManager = snackbarManager;
        this.windowManager = windowManager;
        this.i18n = i18n;
        this.impliesUiMode = true;
    }

    @Override
    public boolean getImpliesUiMode() {
        return this.impliesUiMode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object canHandle(@NotNull URI uri, @NotNull Continuation<? super Boolean> $completion) {
        void $this$filterTo$iv$iv;
        if (!Intrinsics.areEqual((Object)uri.getHost(), (Object)"remote-dev")) {
            return Boxing.boxBoolean((boolean)false);
        }
        String string = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String[] stringArray = new String[]{"/"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List segments = (List)destination$iv$iv;
        if (segments.size() != 2 || !Intrinsics.areEqual(segments.get(1), (Object)"new-environment")) {
            return Boxing.boxBoolean((boolean)false);
        }
        return Boxing.boxBoolean((boolean)true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handle(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteDevConnectionProtocolHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPath(...)");
                var4_6 = new String[]{"/"};
                $this$filter$iv = StringsKt.split$default((CharSequence)v0, (String[])var4_6, (boolean)false, (int)0, (int)6, null);
                $i$f$filter = false;
                var6_12 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-filter-RemoteDevConnectionProtocolHandler$handle$segments$1 = false;
                    v1 = !StringsKt.isBlank((CharSequence)it);
                    if (!v1) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                segments = (List)destination$iv$iv;
                v2 = GatewayProtocolHandler.Companion.getExternalPluginAliases$gateway().get(segments.get(0));
                if (v2 == null) {
                    v2 = (String)segments.get(0);
                }
                if (this.findProviderFor(pluginId = v2) != null) ** GOTO lbl71
                $continuation.L$0 = uri;
                $continuation.L$1 = segments;
                $continuation.L$2 = pluginId;
                $continuation.label = 1;
                v3 = this.pluginManager.awaitInitialLoading((Continuation<? super Unit>)$continuation);
                ** if (v3 != var16_5) goto lbl42
lbl41:
                // 1 sources

                return var16_5;
lbl42:
                // 1 sources

                ** GOTO lbl51
            }
            case 1: {
                pluginId = (String)$continuation.L$2;
                segments = (List)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl51:
                // 2 sources

                if (this.findProviderFor(pluginId) != null) ** GOTO lbl71
                $continuation.L$0 = uri;
                $continuation.L$1 = segments;
                $continuation.L$2 = pluginId;
                $continuation.label = 2;
                v4 = GatewayProtocolHandlerKt.suggestInstallPlugin-Vgb-Y34(PluginId.constructor-impl(pluginId), this.pluginManager, this.snackbarManager, this.windowManager, this.i18n, (Continuation<? super Boolean>)$continuation);
                ** if (v4 != var16_5) goto lbl59
lbl58:
                // 1 sources

                return var16_5;
lbl59:
                // 1 sources

                ** GOTO lbl68
            }
            case 2: {
                pluginId = (String)$continuation.L$2;
                segments = (List)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl68:
                // 2 sources

                if (!(pluginInstalled = ((Boolean)v4).booleanValue())) {
                    Logger.INSTANCE.warn("Can't open UI for the plugin " + pluginId + ". Plugin is not installed.");
                    return Unit.INSTANCE;
                }
lbl71:
                // 4 sources

                if ((provider = this.findProviderFor(pluginId)) == null) {
                    Logger.INSTANCE.warn("Can't open UI for the plugin " + pluginId + ". Provider is not found.");
                    return Unit.INSTANCE;
                }
                $i$f$filterTo = var7_14 = CollectionsKt.toMutableList((Collection)segments);
                var13_24 = uri;
                $i$a$-also-RemoteDevConnectionProtocolHandler$handle$newUri$1 = false;
                it.set(0, pluginId);
                newUri = URIExtensionsKt.withPath(var13_24, "/" + CollectionsKt.joinToString$default((Iterable)var7_14, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
                $continuation.L$0 = uri;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)segments);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)pluginId);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)provider);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)newUri);
                $continuation.label = 3;
                v5 = provider.handleUri(newUri, (Continuation<? super Unit>)$continuation);
                ** if (v5 != var16_5) goto lbl89
lbl88:
                // 1 sources

                return var16_5;
lbl89:
                // 1 sources

                ** GOTO lbl106
            }
            case 3: {
                newUri = (URI)$continuation.L$4;
                provider = (DevEnvironmentProvider)$continuation.L$3;
                pluginId = (String)$continuation.L$2;
                segments = (List)$continuation.L$1;
                uri = (URI)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
                }
                catch (Throwable e) {
                    $i$f$currentCoroutineContext = false;
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    Logger.INSTANCE.warn(e, "Can't handle client uri=" + uri);
                }
lbl106:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final DevEnvironmentProvider findProviderFor(String pluginId) {
        Object v0;
        block1: {
            Iterable iterable = (Iterable)this.environmentManager.getProviders().getValue();
            for (Object t2 : iterable) {
                DevEnvironmentProvider provider2 = (DevEnvironmentProvider)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)pluginId, (Object)provider2.getId-rwbms5E())) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

