/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.ssh.PasswordUserInput;
import com.jetbrains.toolbox.gateway.ssh.PromptHandler;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class PasswordPromptHandler
implements PromptHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean shouldAskForPassword;
    @NotNull
    private final PasswordUserInput userInput;
    @NotNull
    private static final Regex PASSWORD_REGEX = new Regex("([a-zA-Z0-9\\-_@.()]*)('s)?\\s*[pP]assword:");

    public PasswordPromptHandler(boolean shouldAskForPassword, @NotNull PasswordUserInput userInput) {
        Intrinsics.checkNotNullParameter((Object)userInput, (String)"userInput");
        this.shouldAskForPassword = shouldAskForPassword;
        this.userInput = userInput;
    }

    @Override
    @Nullable
    public Object onData(@NotNull String str, @NotNull DevEnvironmentId id, @NotNull Continuation<? super String> $completion) {
        String string;
        MatchResult matchResult = Regex.find$default((Regex)PASSWORD_REGEX, (CharSequence)str, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult match2 = matchResult;
            boolean bl = false;
            if (!this.shouldAskForPassword) {
                Logger.INSTANCE.warn("Environment " + id + " shouldn't ask for password. Denying the request");
                return "";
            }
            String userHost = (String)match2.getGroupValues().get(1);
            Object object = this.userInput.ask(str, userHost, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            string = (String)object;
        } else {
            string = null;
        }
        return string;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

