/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.api.core.auth.PluginAuthManager;
import com.jetbrains.toolbox.api.core.os.LocalDesktopManager;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.api.ui.actions.RunnableActionDescription;
import com.jetbrains.toolbox.api.ui.components.TextFieldKt;
import com.jetbrains.toolbox.api.ui.components.TextFieldMutable;
import com.jetbrains.toolbox.api.ui.components.TextType;
import com.jetbrains.toolbox.api.ui.components.UiField;
import com.jetbrains.toolbox.api.ui.components.UiPage;
import com.jetbrains.toolbox.common.coroutines.flow.SingleStateFlow;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportAccount;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportLoginConfiguration;
import com.jetbrains.toolbox.platform.image.ImageResource;
import java.net.URI;
import java.net.URL;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class SpaceportLoginPage
extends UiPage {
    @NotNull
    private final ImageResource iconResource;
    @NotNull
    private final PluginAuthManager<SpaceportAccount, SpaceportLoginConfiguration> spaceportAuthManager;
    @NotNull
    private final LocalDesktopManager localDesktopManager;
    @NotNull
    private final LocalizableStringFactory i18n;
    @NotNull
    private final TextFieldMutable host;
    @NotNull
    private final StateFlow<List<UiField>> fields;
    @NotNull
    private final StateFlow<List<RunnableActionDescription>> actionButtons;

    public SpaceportLoginPage(@NotNull ImageResource iconResource, @NotNull PluginAuthManager<SpaceportAccount, SpaceportLoginConfiguration> spaceportAuthManager2, @NotNull LocalDesktopManager localDesktopManager, @NotNull LocalizableStringFactory i18n) {
        Intrinsics.checkNotNullParameter((Object)iconResource, (String)"iconResource");
        Intrinsics.checkNotNullParameter(spaceportAuthManager2, (String)"spaceportAuthManager");
        Intrinsics.checkNotNullParameter((Object)localDesktopManager, (String)"localDesktopManager");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        super(i18n.ptrl("CodeCanvas Login"));
        this.iconResource = iconResource;
        this.spaceportAuthManager = spaceportAuthManager2;
        this.localDesktopManager = localDesktopManager;
        this.i18n = i18n;
        this.host = TextFieldKt.TextField((LocalizableString)this.i18n.ptrl("CodeCanvas URL"), (String)"", (TextType)TextType.General, (boolean)true, (Float)Float.valueOf(1.0f), (LocalizableString)this.i18n.pnotr("https://codecanvas.example/"), null);
        this.fields = new SingleStateFlow<List>(CollectionsKt.listOf((Object)this.host));
        this.actionButtons = new SingleStateFlow<List>(CollectionsKt.listOf((Object)new RunnableActionDescription(this){
            private final LocalizableString label;
            private final boolean shouldClosePage;
            final /* synthetic */ SpaceportLoginPage this$0;
            {
                this.this$0 = $receiver;
                this.label = $receiver.getI18n().ptrl("Log in");
            }

            public void run() {
                String host = SpaceportLoginPage.access$normalizeUrl(this.this$0, (String)SpaceportLoginPage.access$getHost$p(this.this$0).getContentState().getValue());
                String loginUrl = SpaceportLoginPage.access$getSpaceportAuthManager$p(this.this$0).initiateLogin((Object)new SpaceportLoginConfiguration(host));
                LocalDesktopManager localDesktopManager = SpaceportLoginPage.access$getLocalDesktopManager$p(this.this$0);
                URL uRL = new URI(loginUrl).toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                localDesktopManager.openUrl(uRL);
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public boolean getShouldClosePage() {
                return this.shouldClosePage;
            }
        }));
    }

    @NotNull
    public ImageResource getIconResource() {
        return this.iconResource;
    }

    @NotNull
    public final LocalizableStringFactory getI18n() {
        return this.i18n;
    }

    private final String normalizeUrl(String rawUrl) {
        String result2 = rawUrl;
        result2 = StringsKt.startsWith$default((String)result2, (String)"https://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)result2, (String)"http://", (boolean)false, (int)2, null) ? result2 : "https://" + result2;
        result2 = StringsKt.removeSuffix((String)result2, (CharSequence)"/");
        return result2;
    }

    @VisibleForTesting
    @NotNull
    public final String getLoginUrl(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.spaceportAuthManager.initiateLogin((Object)new SpaceportLoginConfiguration(this.normalizeUrl(host)));
    }

    @NotNull
    public StateFlow<List<UiField>> getFields() {
        return this.fields;
    }

    @NotNull
    public StateFlow<List<RunnableActionDescription>> getActionButtons() {
        return this.actionButtons;
    }

    public static final /* synthetic */ String access$normalizeUrl(SpaceportLoginPage $this, String rawUrl) {
        return $this.normalizeUrl(rawUrl);
    }

    public static final /* synthetic */ TextFieldMutable access$getHost$p(SpaceportLoginPage $this) {
        return $this.host;
    }

    public static final /* synthetic */ PluginAuthManager access$getSpaceportAuthManager$p(SpaceportLoginPage $this) {
        return $this.spaceportAuthManager;
    }

    public static final /* synthetic */ LocalDesktopManager access$getLocalDesktopManager$p(SpaceportLoginPage $this) {
        return $this.localDesktopManager;
    }
}

