/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.api.core.diagnostics.Logger;
import com.jetbrains.toolbox.api.remoteDev.connection.ForwardedConnection;
import com.jetbrains.toolbox.api.remoteDev.connection.ForwardedConnectionHandle;
import com.jetbrains.toolbox.api.remoteDev.connection.HostTunnelConnector;
import com.jetbrains.toolbox.gateway.spaceport.RdConnectionInfo;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportConnectionUtilsKt;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportHostTunnelConnectorProviderKt;
import com.jetbrains.toolbox.gateway.spaceport.ThinClientConnectionBroker;
import java.io.EOFException;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CancellationException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpaceportHostTunnelConnectorProvider {
    @NotNull
    private final CoroutineScope pluginScope;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String userId;
    @NotNull
    private final Function2<String, Continuation<? super RdConnectionInfo>, Object> fetchRdConnectionInfo;
    private final int messagesCountLog;

    public SpaceportHostTunnelConnectorProvider(@NotNull CoroutineScope pluginScope, @NotNull Logger logger, @NotNull String userId, @NotNull Function2<? super String, ? super Continuation<? super RdConnectionInfo>, ? extends Object> fetchRdConnectionInfo2) {
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(fetchRdConnectionInfo2, (String)"fetchRdConnectionInfo");
        this.pluginScope = pluginScope;
        this.logger = logger;
        this.userId = userId;
        this.fetchRdConnectionInfo = fetchRdConnectionInfo2;
        this.messagesCountLog = 200;
    }

    @NotNull
    public final HostTunnelConnector createConnector() {
        return new SpaceportHostTunnelConnector();
    }

    public static final /* synthetic */ Function2 access$getFetchRdConnectionInfo$p(SpaceportHostTunnelConnectorProvider $this) {
        return $this.fetchRdConnectionInfo;
    }

    public static final /* synthetic */ int access$getMessagesCountLog$p(SpaceportHostTunnelConnectorProvider $this) {
        return $this.messagesCountLog;
    }

    private final class SpaceportForwardedConnectionHandle
    implements ForwardedConnectionHandle {
        private final int remotePort;
        @NotNull
        private final InetAddress localAddress;
        private final long connectionId;
        @NotNull
        private final String connectionLogPrefix;
        @NotNull
        private final CoroutineScope hostConnectionScope;

        public SpaceportForwardedConnectionHandle(@NotNull int remotePort, InetAddress localAddress) {
            Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
            this.remotePort = remotePort;
            this.localAddress = localAddress;
            this.connectionId = SpaceportHostTunnelConnectorProviderKt.access$getConnectionIdCounter$p().incrementAndGet();
            this.connectionLogPrefix = "HostConnection(" + SpaceportHostTunnelConnectorProvider.this.userId + "-" + this.connectionId + ")";
            SpaceportHostTunnelConnectorProvider.this.logger.info(this.connectionLogPrefix + ": start");
            this.hostConnectionScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SpaceportHostTunnelConnectorProvider.this.pluginScope.getCoroutineContext().plus((CoroutineContext)new CoroutineName(this.connectionLogPrefix)).plus((CoroutineContext)Dispatchers.getIO()).plus((CoroutineContext)JobKt.Job((Job)JobKt.getJob((CoroutineContext)SpaceportHostTunnelConnectorProvider.this.pluginScope.getCoroutineContext()))));
            SpaceportConnectionUtilsKt.logCancellationMessage(this.hostConnectionScope, SpaceportHostTunnelConnectorProvider.this.logger, this.connectionLogPrefix);
        }

        @Nullable
        public Object getForwardedConnection(@NotNull Continuation<? super ForwardedConnection> $completion) {
            ServerSocketChannel clientSocketConnection = ServerSocketChannel.open().bind(new InetSocketAddress(this.localAddress, 0));
            SpaceportConnectionUtilsKt.invokeOnCancellation(this.hostConnectionScope, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> SpaceportForwardedConnectionHandle.getForwardedConnection$lambda$0(clientSocketConnection, arg_0)));
            int clientPort = clientSocketConnection.socket().getLocalPort();
            Logger logger = SpaceportHostTunnelConnectorProvider.this.logger;
            Intrinsics.checkNotNull((Object)clientSocketConnection);
            ThinClientConnectionBroker connectionBroker2 = new ThinClientConnectionBroker(logger, this.hostConnectionScope, clientPort, clientSocketConnection);
            SpaceportHostTunnelConnectorProvider.this.logger.info(this.connectionLogPrefix + ": socket for thinclient " + clientSocketConnection.socket());
            BuildersKt.launch$default((CoroutineScope)this.hostConnectionScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, SpaceportHostTunnelConnectorProvider.this, connectionBroker2, null){
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                int I$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ SpaceportForwardedConnectionHandle this$0;
                final /* synthetic */ SpaceportHostTunnelConnectorProvider this$1;
                final /* synthetic */ ThinClientConnectionBroker $connectionBroker;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$connectionBroker = $connectionBroker;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var13_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            attempt = new Ref.IntRef();
                            lastSuccessfulAttempt = new Ref.IntRef();
                            ** break;
                        }
                        case 1: {
                            connectionAttemptScope = (CoroutineScope)this.L$4;
                            attemptConnectionLogPrefix = (String)this.L$3;
                            lastSuccessfulAttempt = (Ref.IntRef)this.L$2;
                            attempt = (Ref.IntRef)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            while (true) {
                                var8_20 = v0;
                                it = (SocketChannel)var8_20;
                                $i$a$-also-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$clientConnection$1 = false;
                                SpaceportConnectionUtilsKt.invokeOnCancellation(connectionAttemptScope, (Function1<? super Throwable, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0$0(java.nio.channels.SocketChannel java.lang.Throwable ), (Ljava/lang/Throwable;)Lkotlin/Unit;)((SocketChannel)it));
                                clientConnection = (SocketChannel)var8_20;
                                this.L$0 = $this$launch;
                                this.L$1 = attempt;
                                this.L$2 = lastSuccessfulAttempt;
                                this.L$3 = attemptConnectionLogPrefix;
                                this.L$4 = connectionAttemptScope;
                                this.L$5 = clientConnection;
                                this.label = 2;
                                v1 = SpaceportConnectionUtilsKt.waitForRdConnection((String)attemptConnectionLogPrefix, (Function2<? super String, ? super Continuation<? super RdConnectionInfo>, ? extends Object>)SpaceportHostTunnelConnectorProvider.access$getFetchRdConnectionInfo$p(this.this$1), (Continuation<? super RdConnectionInfo>)((Continuation)this));
                                ** GOTO lbl52
                                break;
                            }
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
lbl35:
                        // 3 sources

                        while (true) {
                            if (CoroutineScopeKt.isActive((CoroutineScope)$this$launch) == false) return Unit.INSTANCE;
                            var5_9 = attempt.element;
                            attempt.element = var5_9 + 1;
                            attemptConnectionLogPrefix = StringsKt.dropLast((String)SpaceportForwardedConnectionHandle.access$getConnectionLogPrefix$p(this.this$0), (int)1) + "-" + attempt.element + ")";
                            connectionAttemptScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SpaceportForwardedConnectionHandle.access$getHostConnectionScope$p(this.this$0).getCoroutineContext().plus((CoroutineContext)new CoroutineName((String)attemptConnectionLogPrefix)).plus((CoroutineContext)JobKt.Job((Job)JobKt.getJob((CoroutineContext)SpaceportForwardedConnectionHandle.access$getHostConnectionScope$p(this.this$0).getCoroutineContext()))));
                            SpaceportConnectionUtilsKt.logCancellationMessage(connectionAttemptScope, SpaceportHostTunnelConnectorProvider.access$getLogger$p(this.this$1), (String)attemptConnectionLogPrefix);
                            this.L$0 = $this$launch;
                            this.L$1 = attempt;
                            this.L$2 = lastSuccessfulAttempt;
                            this.L$3 = attemptConnectionLogPrefix;
                            this.L$4 = connectionAttemptScope;
                            this.label = 1;
                            if ((v0 = SpaceportForwardedConnectionHandle.access$waitForClientConnection(this.this$0, connectionAttemptScope, (String)attemptConnectionLogPrefix, this.$connectionBroker, (Continuation)this)) != var13_3) ** continue;
                            return var13_3;
                        }
lbl52:
                        // 1 sources

                        v2 = v1;
                        if (v1 == var13_3) {
                            return var13_3;
                        }
                        ** GOTO lbl66
                        case 2: {
                            clientConnection = (SocketChannel)this.L$5;
                            connectionAttemptScope = (CoroutineScope)this.L$4;
                            attemptConnectionLogPrefix = (String)this.L$3;
                            lastSuccessfulAttempt = (Ref.IntRef)this.L$2;
                            attempt = (Ref.IntRef)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl66:
                            // 2 sources

                            connectionData = (RdConnectionInfo)v2;
                            this.L$0 = $this$launch;
                            this.L$1 = attempt;
                            this.L$2 = lastSuccessfulAttempt;
                            this.L$3 = attemptConnectionLogPrefix;
                            this.L$4 = connectionAttemptScope;
                            this.L$5 = SpillingKt.nullOutSpilledVariable((Object)clientConnection);
                            this.L$6 = SpillingKt.nullOutSpilledVariable((Object)connectionData);
                            this.label = 3;
                            v3 = SpaceportConnectionUtilsKt.withRelayWebSocket(SpaceportHostTunnelConnectorProvider.access$getLogger$p(this.this$1), (String)attemptConnectionLogPrefix, connectionAttemptScope, new URI(connectionData.getRelayLink() + "/" + SpaceportHostTunnelConnectorProvider.access$getUserId$p(this.this$1) + "-" + SpaceportForwardedConnectionHandle.access$getConnectionId$p(this.this$0) + "-" + attempt.element), connectionData.getRelayAuthData(), new WebSocketListener(this.this$1, (String)attemptConnectionLogPrefix, clientConnection){
                                final /* synthetic */ SpaceportHostTunnelConnectorProvider this$0;
                                final /* synthetic */ String $attemptConnectionLogPrefix;
                                final /* synthetic */ SocketChannel $clientConnection;
                                {
                                    this.this$0 = $receiver;
                                    this.$attemptConnectionLogPrefix = $attemptConnectionLogPrefix;
                                    this.$clientConnection = $clientConnection;
                                }

                                public void onMessage(WebSocket webSocket2, String text2) {
                                    Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
                                    Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                                    SpaceportHostTunnelConnectorProvider.access$getLogger$p(this.this$0).info(this.$attemptConnectionLogPrefix + ": unexpected message from relay '" + text2 + "'");
                                }

                                public void onMessage(WebSocket webSocket2, ByteString bytes2) {
                                    Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
                                    Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
                                    this.$clientConnection.write(bytes2.asByteBuffer());
                                }
                            }, (Function2)new Function2<WebSocket, Continuation<? super Unit>, Object>(this.this$1, (String)attemptConnectionLogPrefix, lastSuccessfulAttempt, attempt, clientConnection, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ SpaceportHostTunnelConnectorProvider this$0;
                                final /* synthetic */ String $attemptConnectionLogPrefix;
                                final /* synthetic */ Ref.IntRef $lastSuccessfulAttempt;
                                final /* synthetic */ Ref.IntRef $attempt;
                                final /* synthetic */ SocketChannel $clientConnection;
                                {
                                    this.this$0 = $receiver;
                                    this.$attemptConnectionLogPrefix = $attemptConnectionLogPrefix;
                                    this.$lastSuccessfulAttempt = $lastSuccessfulAttempt;
                                    this.$attempt = $attempt;
                                    this.$clientConnection = $clientConnection;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    WebSocket webSocket2 = (WebSocket)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            SpaceportHostTunnelConnectorProvider.access$getLogger$p(this.this$0).info(this.$attemptConnectionLogPrefix + ": relay connected");
                                            this.$lastSuccessfulAttempt.element = this.$attempt.element;
                                            ByteBuffer clientData = ByteBuffer.allocate(65536);
                                            int counter = 0;
                                            try {
                                                while (true) {
                                                    boolean $i$f$currentCoroutineContext = false;
                                                    if (JobKt.isActive((CoroutineContext)this.getContext())) {
                                                        void relayWebSocket;
                                                        if (this.$clientConnection.read(clientData) < 0) {
                                                            throw new EOFException(this.$attemptConnectionLogPrefix + ": thinclient [" + this.$clientConnection.hashCode() + "] read eof");
                                                        }
                                                        clientData.flip();
                                                        Intrinsics.checkNotNull((Object)clientData);
                                                        boolean sent = relayWebSocket.send(ByteString.Companion.of(clientData));
                                                        if (!sent) {
                                                            throw new IllegalStateException(this.$attemptConnectionLogPrefix + ": failed to send data to ws");
                                                        }
                                                        clientData.clear();
                                                        if (counter++ != 1 && counter % SpaceportHostTunnelConnectorProvider.access$getMessagesCountLog$p(this.this$0) != 0) continue;
                                                        SpaceportHostTunnelConnectorProvider.access$getLogger$p(this.this$0).debug(this.$attemptConnectionLogPrefix + ": messages sent from client " + counter);
                                                        continue;
                                                    }
                                                    break;
                                                }
                                            }
                                            catch (CancellationException e) {
                                                throw e;
                                            }
                                            catch (Throwable e) {
                                                SpaceportHostTunnelConnectorProvider.access$getLogger$p(this.this$0).info(e, this.$attemptConnectionLogPrefix + ": error reading from thinclient");
                                                throw e;
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(WebSocket p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            ** if (v3 != var13_3) goto lbl78
lbl77:
                            // 1 sources

                            return var13_3;
lbl78:
                            // 1 sources

                            ** GOTO lbl90
                        }
                        case 3: {
                            connectionData = (RdConnectionInfo)this.L$6;
                            clientConnection = (SocketChannel)this.L$5;
                            connectionAttemptScope = (CoroutineScope)this.L$4;
                            attemptConnectionLogPrefix = (String)this.L$3;
                            lastSuccessfulAttempt = (Ref.IntRef)this.L$2;
                            attempt = (Ref.IntRef)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl90:
                            // 2 sources

                            CoroutineScopeKt.cancel$default((CoroutineScope)connectionAttemptScope, (String)"relay handler completed", null, (int)2, null);
                            $i$f$catching = 0;
                            $i$a$-catching-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$3 = 0;
                            this.L$0 = $this$launch;
                            this.L$1 = attempt;
                            this.L$2 = lastSuccessfulAttempt;
                            this.L$3 = attemptConnectionLogPrefix;
                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)connectionAttemptScope);
                            this.L$5 = null;
                            this.L$6 = null;
                            this.I$0 = $i$f$catching;
                            this.I$1 = $i$a$-catching-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$3;
                            this.label = 4;
                            v4 = JobKt.getJob((CoroutineContext)connectionAttemptScope.getCoroutineContext()).join((Continuation)this);
                            ** if (v4 != var13_3) goto lbl109
lbl108:
                            // 1 sources

                            return var13_3;
lbl109:
                            // 1 sources

                            ** GOTO lbl121
                        }
                        case 4: {
                            $i$a$-catching-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$3 = this.I$1;
                            $i$f$catching = this.I$0;
                            connectionAttemptScope = (CoroutineScope)this.L$4;
                            attemptConnectionLogPrefix = (String)this.L$3;
                            lastSuccessfulAttempt = (Ref.IntRef)this.L$2;
                            attempt = (Ref.IntRef)this.L$1;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl121:
                                // 2 sources

                                it = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (CancellationException c$iv) {
                                throw c$iv;
                            }
                            catch (Throwable t$iv) {
                                it = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                            }
                            $i$f$catching = it;
                            t$iv = this.this$1;
                            v5 = Result.exceptionOrNull-impl((Object)$i$f$catching);
                            if (v5 != null) {
                                it = it = v5;
                                $i$a$-onFailure-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$4 = false;
                                if (!(it instanceof CancellationException)) {
                                    SpaceportHostTunnelConnectorProvider.access$getLogger$p(t$iv).info((Throwable)it, (String)attemptConnectionLogPrefix + ": failed to complete connection");
                                }
                            }
lbl138:
                            // 8 sources

                            while (true) {
                                secondsBeforeReconnect = Math.min(attempt.element - lastSuccessfulAttempt.element + 1, 5);
                                SpaceportHostTunnelConnectorProvider.access$getLogger$p(this.this$1).info((String)attemptConnectionLogPrefix + ": relay handler completed, will reconnect in " + secondsBeforeReconnect + " seconds");
                                this.L$0 = $this$launch;
                                this.L$1 = attempt;
                                this.L$2 = lastSuccessfulAttempt;
                                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)attemptConnectionLogPrefix);
                                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)connectionAttemptScope);
                                this.L$5 = null;
                                this.L$6 = null;
                                this.I$0 = secondsBeforeReconnect;
                                this.label = 7;
                                v6 = DelayKt.delay((long)((long)secondsBeforeReconnect * 1000L), (Continuation)((Continuation)this));
                                if (v6 != var13_3) ** GOTO lbl35
                                return var13_3;
                            }
                        }
                        catch (Throwable e) {
                            try {
                                CoroutineScopeKt.ensureActive((CoroutineScope)$this$launch);
                                SpaceportHostTunnelConnectorProvider.access$getLogger$p(this.this$1).info(e, (String)attemptConnectionLogPrefix + ": connection failed with error");
                                CoroutineScopeKt.cancel((CoroutineScope)connectionAttemptScope, (String)("relay handler completed: " + e.getMessage()), (Throwable)e);
                            }
                            catch (Throwable $i$f$catching) {
                                CoroutineScopeKt.cancel$default((CoroutineScope)connectionAttemptScope, (String)"relay handler completed", null, (int)2, null);
                                $i$f$catching = 0;
                                ** try [egrp 9[TRYBLOCK] [12, 14 : 1240->1333)] { 
lbl162:
                                // 1 sources

                                ** GOTO lbl170
lbl163:
                                // 1 sources

                                catch (CancellationException c$iv) {
                                    throw c$iv;
                                }
lbl165:
                                // 1 sources

                                catch (Throwable t$iv) {
                                    var10_39 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                                    ** GOTO lbl246
                                }
lbl170:
                                // 1 sources

                                $i$a$-catching-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$3 = 0;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)attempt);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)lastSuccessfulAttempt);
                                this.L$3 = attemptConnectionLogPrefix;
                                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)connectionAttemptScope);
                                this.L$5 = $i$f$catching;
                                this.L$6 = null;
                                this.I$0 = $i$f$catching;
                                this.I$1 = $i$a$-catching-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$3;
                                this.label = 6;
                                v7 = JobKt.getJob((CoroutineContext)connectionAttemptScope.getCoroutineContext()).join((Continuation)this);
                                if (v7 == var13_3) {
                                    return var13_3;
                                }
                                ** GOTO lbl245
                            }
                            CoroutineScopeKt.cancel$default((CoroutineScope)connectionAttemptScope, (String)"relay handler completed", null, (int)2, null);
                            $i$f$catching = 0;
                            $i$a$-catching-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$3 = 0;
                            this.L$0 = $this$launch;
                            this.L$1 = attempt;
                            this.L$2 = lastSuccessfulAttempt;
                            this.L$3 = attemptConnectionLogPrefix;
                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)connectionAttemptScope);
                            this.L$5 = null;
                            this.L$6 = null;
                            this.I$0 = $i$f$catching;
                            this.I$1 = $i$a$-catching-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$3;
                            this.label = 5;
                            v8 = JobKt.getJob((CoroutineContext)connectionAttemptScope.getCoroutineContext()).join((Continuation)this);
                            ** if (v8 != var13_3) goto lbl204
lbl203:
                            // 1 sources

                            return var13_3;
lbl204:
                            // 1 sources

                            ** GOTO lbl216
                            case 5: {
                                $i$a$-catching-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$3 = this.I$1;
                                $i$f$catching = this.I$0;
                                connectionAttemptScope = (CoroutineScope)this.L$4;
                                attemptConnectionLogPrefix = (String)this.L$3;
                                lastSuccessfulAttempt = (Ref.IntRef)this.L$2;
                                attempt = (Ref.IntRef)this.L$1;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v8 = $result;
lbl216:
                                    // 2 sources

                                    it = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (CancellationException c$iv) {
                                    throw c$iv;
                                }
                                catch (Throwable t$iv) {
                                    it = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                                }
                                $i$f$catching = it;
                                t$iv = this.this$1;
                                v9 = Result.exceptionOrNull-impl((Object)$i$f$catching);
                                if (v9 == null) ** GOTO lbl138
                                it = it = v9;
                                $i$a$-onFailure-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$4 = false;
                                if (it instanceof CancellationException) ** GOTO lbl138
                                SpaceportHostTunnelConnectorProvider.access$getLogger$p(t$iv).info((Throwable)it, (String)attemptConnectionLogPrefix + ": failed to complete connection");
                                ** continue;
                            }
                        }
                        case 6: {
                            $i$a$-catching-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$3 = this.I$1;
                            $i$f$catching = this.I$0;
                            $i$f$catching = (Throwable)this.L$5;
                            connectionAttemptScope = (CoroutineScope)this.L$4;
                            attemptConnectionLogPrefix = (String)this.L$3;
                            lastSuccessfulAttempt = (Ref.IntRef)this.L$2;
                            attempt = (Ref.IntRef)this.L$1;
                            {
                                ResultKt.throwOnFailure((Object)$result);
                                v7 = $result;
lbl245:
                                // 2 sources

                                var10_39 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
lbl246:
                            // 2 sources

                            var8_29 = var10_39;
                            var9_35 = this.this$1;
                            v10 = Result.exceptionOrNull-impl((Object)var8_29);
                            if (v10 == null) throw $i$f$catching;
                            it = var10_39 = v10;
                            $i$a$-onFailure-SpaceportHostTunnelConnectorProvider$SpaceportForwardedConnectionHandle$getForwardedConnection$3$4 = false;
                            if (it instanceof CancellationException != false) throw $i$f$catching;
                            SpaceportHostTunnelConnectorProvider.access$getLogger$p(var9_35).info((Throwable)it, (String)attemptConnectionLogPrefix + ": failed to complete connection");
                            throw $i$f$catching;
                        }
                        case 7: 
                    }
                    secondsBeforeReconnect = this.I$0;
                    connectionAttemptScope = (CoroutineScope)this.L$4;
                    attemptConnectionLogPrefix = (String)this.L$3;
                    lastSuccessfulAttempt = (Ref.IntRef)this.L$2;
                    attempt = (Ref.IntRef)this.L$1;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
                    ** while (true)
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0$0(SocketChannel $it, Throwable e) {
                    $it.close();
                    return Unit.INSTANCE;
                }
            }), (int)3, null);
            return new ForwardedConnection(clientPort, this.remotePort);
        }

        public void close() {
            SpaceportHostTunnelConnectorProvider.this.logger.info(this.connectionLogPrefix + ": closing thinclient connection");
            CoroutineScopeKt.cancel$default((CoroutineScope)this.hostConnectionScope, (String)"ForwardedConnection.close called", null, (int)2, null);
        }

        private final Object waitForClientConnection(CoroutineScope connectionAttemptScope, String connectionLogPrefix, ThinClientConnectionBroker connectionBroker2, Continuation<? super SocketChannel> $completion) {
            SpaceportHostTunnelConnectorProvider.this.logger.info(connectionLogPrefix + ": waiting for new connection attempt from the client on :" + connectionBroker2.getPort());
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SocketChannel>, Object>(connectionBroker2, connectionAttemptScope, SpaceportHostTunnelConnectorProvider.this, connectionLogPrefix, null){
                int label;
                final /* synthetic */ ThinClientConnectionBroker $connectionBroker;
                final /* synthetic */ CoroutineScope $connectionAttemptScope;
                final /* synthetic */ SpaceportHostTunnelConnectorProvider this$0;
                final /* synthetic */ String $connectionLogPrefix;
                {
                    this.$connectionBroker = $connectionBroker;
                    this.$connectionAttemptScope = $connectionAttemptScope;
                    this.this$0 = $receiver;
                    this.$connectionLogPrefix = $connectionLogPrefix;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = this.$connectionBroker.accept(this.$connectionAttemptScope, (Continuation<? super SocketChannel>)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            newConnection = (SocketChannel)v0;
                            newConnection.configureBlocking(true);
                            newConnection.socket().setTcpNoDelay(true);
                            SpaceportHostTunnelConnectorProvider.access$getLogger$p(this.this$0).info(this.$connectionLogPrefix + ": thin client connected to :" + this.$connectionBroker.getPort());
                            return newConnection;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super SocketChannel> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private static final Unit getForwardedConnection$lambda$0(ServerSocketChannel $clientSocketConnection, Throwable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $clientSocketConnection.close();
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ String access$getConnectionLogPrefix$p(SpaceportForwardedConnectionHandle $this) {
            return $this.connectionLogPrefix;
        }

        public static final /* synthetic */ CoroutineScope access$getHostConnectionScope$p(SpaceportForwardedConnectionHandle $this) {
            return $this.hostConnectionScope;
        }

        public static final /* synthetic */ Object access$waitForClientConnection(SpaceportForwardedConnectionHandle $this, CoroutineScope connectionAttemptScope, String connectionLogPrefix, ThinClientConnectionBroker connectionBroker2, Continuation $completion) {
            return $this.waitForClientConnection(connectionAttemptScope, connectionLogPrefix, connectionBroker2, (Continuation<? super SocketChannel>)$completion);
        }

        public static final /* synthetic */ long access$getConnectionId$p(SpaceportForwardedConnectionHandle $this) {
            return $this.connectionId;
        }
    }

    private final class SpaceportHostTunnelConnector
    implements HostTunnelConnector {
        @NotNull
        public ForwardedConnectionHandle forwardIdePort(@NotNull HostTunnelConnector.Protocol protocol, @NotNull InetAddress remoteAddress2, int remotePort, @NotNull InetAddress localAddress) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)remoteAddress2, (String)"remoteAddress");
            Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
            return new SpaceportForwardedConnectionHandle(remotePort, localAddress);
        }
    }
}

