/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.api.core.Arch;
import com.jetbrains.toolbox.api.core.OS;
import com.jetbrains.toolbox.api.core.diagnostics.Logger;
import com.jetbrains.toolbox.api.remoteDev.connection.AgentConnection;
import com.jetbrains.toolbox.api.remoteDev.connection.AgentConnectionHandle;
import com.jetbrains.toolbox.api.remoteDev.deploy.AgentDistributionProvider;
import com.jetbrains.toolbox.api.remoteDev.deploy.DistributionInfo;
import com.jetbrains.toolbox.common.io.FileSize;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.gateway.spaceport.RdConnectionInfo;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportAgentConnectionProvider;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportAgentConnectionProviderKt;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportConnectionUtilsKt;
import com.jetbrains.toolbox.gateway.spaceport.utils.Once;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.NonCancellable;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSpaceportAgentConnectionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceportAgentConnectionProvider.kt\ncom/jetbrains/toolbox/gateway/spaceport/SpaceportAgentConnectionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1#2:280\n*E\n"})
public final class SpaceportAgentConnectionProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope pluginScope;
    @NotNull
    private final AgentDistributionProvider agentProvider;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String userId;
    @NotNull
    private final Function2<String, Continuation<? super RdConnectionInfo>, Object> fetchRdConnectionInfo;
    private final int increasedPipeSize;
    @NotNull
    private final Mutex reconnectionLock;
    @NotNull
    private static final String tbaRedeployFlagMsg = "tba.redeploy.";
    @NotNull
    private static final String tbaUrlMsg = "tba.url.";
    @NotNull
    private static final String tbaDeployMsg = "tba.deploy.";
    @NotNull
    private static final String tbaShaMsg = "tba.sha256.";

    public SpaceportAgentConnectionProvider(@NotNull CoroutineScope pluginScope, @NotNull AgentDistributionProvider agentProvider, @NotNull Logger logger, @NotNull String userId, @NotNull Function2<? super String, ? super Continuation<? super RdConnectionInfo>, ? extends Object> fetchRdConnectionInfo2) {
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)agentProvider, (String)"agentProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(fetchRdConnectionInfo2, (String)"fetchRdConnectionInfo");
        this.pluginScope = pluginScope;
        this.agentProvider = agentProvider;
        this.logger = logger;
        this.userId = userId;
        this.fetchRdConnectionInfo = fetchRdConnectionInfo2;
        this.increasedPipeSize = 65536;
        this.reconnectionLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @NotNull
    public final AgentConnectionHandle createAgentConnection(boolean redeploy) {
        return new AgentConnectionHandle(this, redeploy){
            private final long connectionId;
            private final String connectionLogPrefix;
            private final CoroutineScope agentConnectionScope;
            private final PipedOutputStream agentOutput;
            private final PipedInputStream clientInput;
            private final PipedOutputStream clientOutput;
            private final PipedInputStream clientReaderInput;
            private final BufferedReader clientReader;
            private final Once<Unit> closeOnce;
            final /* synthetic */ SpaceportAgentConnectionProvider this$0;
            final /* synthetic */ boolean $redeploy;
            {
                Object it;
                Closeable closeable;
                this.this$0 = $receiver;
                this.$redeploy = $redeploy;
                this.connectionId = SpaceportAgentConnectionProviderKt.access$getConnectionIdCounter$p().incrementAndGet();
                this.connectionLogPrefix = "TbaConnection(" + SpaceportAgentConnectionProvider.access$getUserId$p($receiver) + "-" + this.connectionId + ")";
                this.agentConnectionScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SpaceportAgentConnectionProvider.access$getPluginScope$p($receiver).getCoroutineContext().plus((CoroutineContext)new CoroutineName(this.connectionLogPrefix)).plus((CoroutineContext)Dispatchers.getIO()).plus((CoroutineContext)JobKt.Job((Job)JobKt.getJob((CoroutineContext)SpaceportAgentConnectionProvider.access$getPluginScope$p($receiver).getCoroutineContext()))));
                SpaceportConnectionUtilsKt.logCancellationMessage(this.agentConnectionScope, SpaceportAgentConnectionProvider.access$getLogger$p($receiver), this.connectionLogPrefix);
                PipedOutputStream pipedOutputStream = closeable = new PipedOutputStream();
                var var6_7 = this;
                boolean bl = false;
                SpaceportConnectionUtilsKt.closeOnCancellation(this.agentConnectionScope, (AutoCloseable)it);
                var6_7.agentOutput = closeable;
                closeable = new PipedInputStream(this.agentOutput, SpaceportAgentConnectionProvider.access$getIncreasedPipeSize$p($receiver));
                it = closeable;
                var6_7 = this;
                boolean bl2 = false;
                SpaceportConnectionUtilsKt.closeOnCancellation(this.agentConnectionScope, (AutoCloseable)it);
                var6_7.clientInput = closeable;
                closeable = new PipedOutputStream();
                it = closeable;
                var6_7 = this;
                boolean bl3 = false;
                SpaceportConnectionUtilsKt.closeOnCancellation(this.agentConnectionScope, (AutoCloseable)it);
                var6_7.clientOutput = closeable;
                closeable = new PipedInputStream(this.clientOutput, SpaceportAgentConnectionProvider.access$getIncreasedPipeSize$p($receiver));
                it = closeable;
                var6_7 = this;
                boolean bl4 = false;
                SpaceportConnectionUtilsKt.closeOnCancellation(this.agentConnectionScope, (AutoCloseable)it);
                var6_7.clientReaderInput = closeable;
                closeable = this.clientReaderInput;
                it = Charsets.UTF_8;
                closeable = new InputStreamReader((InputStream)closeable, (Charset)it);
                int it32 = 8192;
                Closeable it32 = closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, it32);
                var6_7 = this;
                boolean bl5 = false;
                SpaceportConnectionUtilsKt.closeOnCancellation(this.agentConnectionScope, it32);
                var6_7.clientReader = closeable;
                this.closeOnce = new Once<T>((Function1)new Function1<Continuation<? super Unit>, Object>($receiver, this, null){
                    int label;
                    final /* synthetic */ SpaceportAgentConnectionProvider this$0;
                    final /* synthetic */ createAgentConnection.1 this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(1, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = BuildersKt.withContext((CoroutineContext)SpaceportAgentConnectionProvider.access$getPluginScope$p(this.this$0).getCoroutineContext().plus((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.this$0, null){
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ createAgentConnection.1 this$0;
                                    final /* synthetic */ SpaceportAgentConnectionProvider this$1;
                                    {
                                        this.this$0 = $receiver;
                                        this.this$1 = $receiver2;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                void $this$withContext;
                                                ResultKt.throwOnFailure((Object)$result);
                                                BuildersKt.launch$default((CoroutineScope)$this$withContext, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.this$0, null){
                                                    int label;
                                                    final /* synthetic */ SpaceportAgentConnectionProvider this$0;
                                                    final /* synthetic */ createAgentConnection.1 this$1;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.this$1 = $receiver2;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * Unable to fully structure code
                                                     */
                                                    public final Object invokeSuspend(Object $result) {
                                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                this.label = 1;
                                                                v0 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                                                                if (v0 == var2_2) {
                                                                    return var2_2;
                                                                }
                                                                ** GOTO lbl13
                                                            }
                                                            case 1: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v0 = $result;
lbl13:
                                                                // 2 sources

                                                                if (SpaceportAgentConnectionProvider.access$getReconnectionLock$p(this.this$0).holdsLock((Object)createAgentConnection.1.access$getConnectionLogPrefix$p(this.this$1))) {
                                                                    SpaceportAgentConnectionProvider.access$getReconnectionLock$p(this.this$0).unlock((Object)createAgentConnection.1.access$getConnectionLogPrefix$p(this.this$1));
                                                                } else {
                                                                    SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.jetbrains.toolbox.gateway.spaceport.SpaceportAgentConnectionProvider$createAgentConnection$1 ), ()Ljava/lang/String;)(this.this$1));
                                                                }
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }

                                                    private static final String invokeSuspend$lambda$0(createAgentConnection.1 this$0) {
                                                        return createAgentConnection.1.access$getConnectionLogPrefix$p(this$0) + ": reconnectionLock is not held by current AgentConnectionHandle";
                                                    }
                                                }), (int)3, null);
                                                CoroutineScopeKt.cancel$default((CoroutineScope)createAgentConnection.1.access$getAgentConnectionScope$p(this.this$0), (String)"AgentConnectionHandle.close called", null, (int)2, null);
                                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                                                this.label = 1;
                                                Object object2 = JobKt.getJob((CoroutineContext)createAgentConnection.1.access$getAgentConnectionScope$p(this.this$0).getCoroutineContext()).join((Continuation)this);
                                                if (object2 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value2;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Object object2;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    object2 = $result;
                                    return Unit.INSTANCE;
                                }
                                catch (Throwable e) {
                                    SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).error(e, createAgentConnection.1.access$getConnectionLogPrefix$p(this.this$1) + ": AgentConnectionHandle.close failed with [" + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + "] " + e.getMessage());
                                    throw e;
                                }
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            {
                                finally {
                                    SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(createAgentConnection.1.access$getConnectionLogPrefix$p(this.this$1) + ": AgentConnectionHandle.close completed");
                                }
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            }

            /*
             * Unable to fully structure code
             */
            public Object getAgentConnection(Continuation<? super AgentConnection> $completion) {
                if (!($completion instanceof createAgentConnection.getAgentConnection.1)) ** GOTO lbl-1000
                var5_2 = $completion;
                if ((var5_2.label & -2147483648) != 0) {
                    var5_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        /* synthetic */ Object result;
                        final /* synthetic */ createAgentConnection.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.getAgentConnection((Continuation<? super AgentConnection>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(this.connectionLogPrefix + ": start");
                        $continuation.label = 1;
                        v0 = SpaceportAgentConnectionProvider.access$getReconnectionLock$p(this.this$0).lock((Object)this.connectionLogPrefix, (Continuation)$continuation);
                        ** if (v0 != var6_4) goto lbl19
lbl18:
                        // 1 sources

                        return var6_4;
lbl19:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        $continuation.label = 2;
                        v1 = SpaceportConnectionUtilsKt.waitForRdConnection(this.connectionLogPrefix, (Function2<? super String, ? super Continuation<? super RdConnectionInfo>, ? extends Object>)SpaceportAgentConnectionProvider.access$getFetchRdConnectionInfo$p(this.this$0), (Continuation<? super RdConnectionInfo>)$continuation);
                        ** if (v1 != var6_4) goto lbl29
lbl28:
                        // 1 sources

                        return var6_4;
lbl29:
                        // 1 sources

                        ** GOTO lbl35
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl35:
                            // 2 sources

                            connectionData = (RdConnectionInfo)v1;
                            BuildersKt.launch$default((CoroutineScope)this.agentConnectionScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, connectionData, this.this$0, null){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ createAgentConnection.1 this$0;
                                final /* synthetic */ RdConnectionInfo $connectionData;
                                final /* synthetic */ SpaceportAgentConnectionProvider this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.$connectionData = $connectionData;
                                    this.this$1 = $receiver2;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Loose catch block
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void $this$launch;
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.L$0 = $this$launch;
                                            this.label = 1;
                                            Object object2 = createAgentConnection.1.access$connectionHandler(this.this$0, createAgentConnection.1.access$getAgentConnectionScope$p(this.this$0), createAgentConnection.1.access$getConnectionLogPrefix$p(this.this$0), this.$connectionData, createAgentConnection.1.access$getAgentOutput$p(this.this$0), createAgentConnection.1.access$getClientReader$p(this.this$0), (Continuation)this);
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            Object object2;
                                            void $this$launch;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                            catch (Throwable e) {
                                                if (e instanceof CancellationException) return Unit.INSTANCE;
                                                if (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                                    SpaceportAgentConnectionProvider.access$getLogger$p(this.this$1).debug(createAgentConnection.1.access$getConnectionLogPrefix$p(this.this$0) + ": connectionHandler failed with " + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + ": " + e.getMessage() + "\n\tat " + SpaceportAgentConnectionProviderKt.access$washedStacktrace(e));
                                                    return Unit.INSTANCE;
                                                } else {
                                                    SpaceportAgentConnectionProvider.access$getLogger$p(this.this$1).debug(e, createAgentConnection.1.access$getConnectionLogPrefix$p(this.this$0) + ": connectionHandler failed with [" + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + "] " + e.getMessage() + "\n\tat " + SpaceportAgentConnectionProviderKt.access$washedStacktrace(e));
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                        {
                                            finally {
                                                SpaceportAgentConnectionProvider.access$getLogger$p(this.this$1).debug(createAgentConnection.1.access$getConnectionLogPrefix$p(this.this$0) + ": connectionHandler completed");
                                                CoroutineScopeKt.cancel$default((CoroutineScope)createAgentConnection.1.access$getAgentConnectionScope$p(this.this$0), (String)"connectionHandler completed", null, (int)2, null);
                                            }
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            var2_5 = new AgentConnection((InputStream)this.clientInput, (OutputStream)this.clientOutput);
                        }
                        catch (Throwable e) {
                            CoroutineScopeKt.cancel$default((CoroutineScope)this.agentConnectionScope, (String)("AgentConnectionHandle.getAgentConnection failed with [" + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + "] " + e.getMessage()), null, (int)2, null);
                            throw e;
                        }
                        return var2_5;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public Object close(Continuation<? super Unit> $completion) {
                SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(this.connectionLogPrefix + ": AgentConnectionHandle.close called");
                Object object = this.closeOnce.invoke($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            private final Object connectionHandler(CoroutineScope agentConnectionScope, String connectionLogPrefix, RdConnectionInfo connectionData, OutputStream agentOutput, BufferedReader clientReader, Continuation<? super Unit> $completion) {
                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, connectionLogPrefix, agentConnectionScope, connectionData, this, agentOutput, this.$redeploy, clientReader, null){
                    int label;
                    final /* synthetic */ SpaceportAgentConnectionProvider this$0;
                    final /* synthetic */ String $connectionLogPrefix;
                    final /* synthetic */ CoroutineScope $agentConnectionScope;
                    final /* synthetic */ RdConnectionInfo $connectionData;
                    final /* synthetic */ createAgentConnection.1 this$1;
                    final /* synthetic */ OutputStream $agentOutput;
                    final /* synthetic */ boolean $redeploy;
                    final /* synthetic */ BufferedReader $clientReader;
                    {
                        this.this$0 = $receiver;
                        this.$connectionLogPrefix = $connectionLogPrefix;
                        this.$agentConnectionScope = $agentConnectionScope;
                        this.$connectionData = $connectionData;
                        this.this$1 = $receiver2;
                        this.$agentOutput = $agentOutput;
                        this.$redeploy = $redeploy;
                        this.$clientReader = $clientReader;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Logger logger = SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0);
                                URI uRI = new URI(this.$connectionData.getToolboxAgentRelayLink() + "/" + SpaceportAgentConnectionProvider.access$getUserId$p(this.this$0) + "-" + createAgentConnection.1.access$getConnectionId$p(this.this$1));
                                String string = this.$connectionData.getToolboxAgentRelayAuthData();
                                Intrinsics.checkNotNull((Object)string);
                                this.label = 1;
                                Object object2 = SpaceportConnectionUtilsKt.withRelayWebSocket(logger, this.$connectionLogPrefix, this.$agentConnectionScope, uRI, string, new WebSocketListener(this.$agentOutput, this.$connectionLogPrefix){
                                    final /* synthetic */ OutputStream $agentOutput;
                                    final /* synthetic */ String $connectionLogPrefix;
                                    {
                                        this.$agentOutput = $agentOutput;
                                        this.$connectionLogPrefix = $connectionLogPrefix;
                                    }

                                    public void onMessage(WebSocket webSocket2, String text2) {
                                        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
                                        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                                        byte[] byArray = text2.getBytes(Charsets.UTF_8);
                                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                                        this.$agentOutput.write(byArray);
                                        this.$agentOutput.flush();
                                    }

                                    public void onMessage(WebSocket webSocket2, ByteString bytes2) {
                                        Intrinsics.checkNotNullParameter((Object)webSocket2, (String)"webSocket");
                                        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
                                        throw new IllegalStateException((this.$connectionLogPrefix + ": unexpected binary frame from agent").toString());
                                    }
                                }, (Function2)new Function2<WebSocket, Continuation<? super Unit>, Object>(this.this$0, this.$connectionLogPrefix, this.$redeploy, this.$clientReader, null){
                                    int label;
                                    /* synthetic */ Object L$0;
                                    final /* synthetic */ SpaceportAgentConnectionProvider this$0;
                                    final /* synthetic */ String $connectionLogPrefix;
                                    final /* synthetic */ boolean $redeploy;
                                    final /* synthetic */ BufferedReader $clientReader;
                                    {
                                        this.this$0 = $receiver;
                                        this.$connectionLogPrefix = $connectionLogPrefix;
                                        this.$redeploy = $redeploy;
                                        this.$clientReader = $clientReader;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        var2_2 = (WebSocket)this.L$0;
                                        var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(this.$connectionLogPrefix + " TB -> Relay: Deploying TBA, redeploy=" + this.$redeploy);
                                                this.L$0 = relayWebSocket;
                                                this.label = 1;
                                                v0 = SpaceportAgentConnectionProvider.access$deployToolboxAgent(this.this$0, this.$connectionLogPrefix, (WebSocket)relayWebSocket, this.$redeploy, (Continuation)this);
                                                if (v0 == var5_3) {
                                                    return var5_3;
                                                }
                                                ** GOTO lbl16
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl16:
                                                // 2 sources

                                                SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(this.$connectionLogPrefix + " TB -> Relay: Starting to transmit data");
                                                try {
                                                    firstMessageReceived = false;
                                                    while (true) {
                                                        if ((text = this.$clientReader.readLine()) != null) ** GOTO lbl25
                                                        SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(this.$connectionLogPrefix + " TB -> Relay: TB EOF");
                                                        break;
lbl25:
                                                        // 1 sources

                                                        if (!firstMessageReceived) {
                                                            SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(this.$connectionLogPrefix + " TB -> Relay: First message received from TB");
                                                        }
                                                        if (!relayWebSocket.send(text + "\n")) {
                                                            SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(this.$connectionLogPrefix + " TB -> Relay: Failed to send message to Relay");
                                                        }
                                                        if (firstMessageReceived) continue;
                                                        SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(this.$connectionLogPrefix + " TB -> Relay: First message sent to Relay");
                                                        firstMessageReceived = true;
                                                    }
                                                }
                                                finally {
                                                    SpaceportAgentConnectionProvider.access$getLogger$p(this.this$0).debug(this.$connectionLogPrefix + " TB -> Relay: completed");
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value2;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(WebSocket p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }

            public static final /* synthetic */ Object access$connectionHandler(createAgentConnection.1 $this, CoroutineScope agentConnectionScope, String connectionLogPrefix, RdConnectionInfo connectionData, OutputStream agentOutput, BufferedReader clientReader, Continuation $completion) {
                return $this.connectionHandler(agentConnectionScope, connectionLogPrefix, connectionData, agentOutput, clientReader, (Continuation<? super Unit>)$completion);
            }

            public static final /* synthetic */ CoroutineScope access$getAgentConnectionScope$p(createAgentConnection.1 $this) {
                return $this.agentConnectionScope;
            }

            public static final /* synthetic */ String access$getConnectionLogPrefix$p(createAgentConnection.1 $this) {
                return $this.connectionLogPrefix;
            }

            public static final /* synthetic */ PipedOutputStream access$getAgentOutput$p(createAgentConnection.1 $this) {
                return $this.agentOutput;
            }

            public static final /* synthetic */ BufferedReader access$getClientReader$p(createAgentConnection.1 $this) {
                return $this.clientReader;
            }

            public static final /* synthetic */ long access$getConnectionId$p(createAgentConnection.1 $this) {
                return $this.connectionId;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private final Object deployToolboxAgent(String connectionLogPrefix, WebSocket relayWebSocket, boolean redeploy, Continuation<? super Unit> $completion) {
        block10: {
            block9: {
                if (!($completion instanceof deployToolboxAgent.1)) ** GOTO lbl-1000
                var14_5 = $completion;
                if ((var14_5.label & -2147483648) != 0) {
                    var14_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        boolean Z$0;
                        long J$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ SpaceportAgentConnectionProvider this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return SpaceportAgentConnectionProvider.access$deployToolboxAgent(this.this$0, null, null, false, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var15_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.L$0 = connectionLogPrefix;
                        $continuation.L$1 = relayWebSocket;
                        $continuation.Z$0 = redeploy;
                        $continuation.label = 1;
                        v0 = this.agentProvider.getAgentDistribution(OS.Linux, Arch.X64, true, (Continuation)$continuation);
                        if (v0 == var15_7) {
                            return var15_7;
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        redeploy = $continuation.Z$0;
                        relayWebSocket = (WebSocket)$continuation.L$1;
                        connectionLogPrefix = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        if ((distribution = (DistributionInfo)v0) == null) break block9;
                        if (!Intrinsics.areEqual((Object)distribution.getUri().getScheme(), (Object)"file")) break;
                        v1 = Paths.get(distribution.getUri());
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"get(...)");
                        path = v1;
                        contentLength = Files.size(path);
                        v2 = new OpenOption[]{};
                        v3 = Files.newInputStream(path, Arrays.copyOf(v2, v2.length));
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"newInputStream(...)");
                        var10_15 = v3;
                        var11_16 = 8192;
                        it = var10_15 = var10_15 instanceof BufferedInputStream != false ? (BufferedInputStream)var10_15 : new BufferedInputStream(var10_15, var11_16);
                        $i$a$-also-SpaceportAgentConnectionProvider$deployToolboxAgent$agentInputStream$1 = false;
                        this.logger.debug(connectionLogPrefix + ": Agent file path: " + path);
                        agentInputStream = var10_15;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connectionLogPrefix);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)relayWebSocket);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)distribution);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)path);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)agentInputStream);
                        $continuation.Z$0 = redeploy;
                        $continuation.J$0 = contentLength;
                        $continuation.label = 2;
                        v4 = this.uploadToolboxAgent(connectionLogPrefix, relayWebSocket, (BufferedInputStream)agentInputStream, Boxing.boxLong((long)contentLength), distribution, (Continuation<? super Unit>)$continuation);
                        if (v4 == var15_7) {
                            return var15_7;
                        }
                        ** GOTO lbl64
                    }
                    case 2: {
                        contentLength = $continuation.J$0;
                        redeploy = $continuation.Z$0;
                        agentInputStream = (BufferedInputStream)$continuation.L$4;
                        path = (Path)$continuation.L$3;
                        distribution = (DistributionInfo)$continuation.L$2;
                        relayWebSocket = (WebSocket)$continuation.L$1;
                        connectionLogPrefix = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl64:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                break block10;
            }
            this.logger.error(connectionLogPrefix + ": Failed to get Toolbox Agent distribution - " + distribution);
            throw new IllegalStateException(("Failed to get Toolbox Agent distribution - " + distribution).toString());
        }
        this.logger.debug(connectionLogPrefix + ": Passing redeploy=" + (redeploy != false) + " to Toolbox Agent");
        var6_12 = "tba.redeploy." + (redeploy != false);
        v5 = var6_12.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getBytes(...)");
        relayWebSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])v5, (int)0, (int)0, (int)3, null));
        this.logger.debug(connectionLogPrefix + ": Deploying Toolbox Agent from the link: " + distribution.getUri());
        var6_12 = "tba.url." + distribution.getUri();
        v6 = var6_12.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getBytes(...)");
        relayWebSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])v6, (int)0, (int)0, (int)3, null));
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object uploadToolboxAgent(String connectionLogPrefix, WebSocket relayWebSocket, BufferedInputStream inputStream, Long contentLength, DistributionInfo distribution, Continuation<? super Unit> $completion) {
        if (!($completion instanceof uploadToolboxAgent.1)) ** GOTO lbl-1000
        var20_7 = $completion;
        if ((var20_7.label & -2147483648) != 0) {
            var20_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                int I$0;
                int I$1;
                int I$2;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ SpaceportAgentConnectionProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SpaceportAgentConnectionProvider.access$uploadToolboxAgent(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var7_10 = inputStream;
                var8_11 = null;
                it = (BufferedInputStream)var7_10;
                $i$a$-use-SpaceportAgentConnectionProvider$uploadToolboxAgent$2 = 0;
                bytesRead = new Ref.IntRef();
                this.logger.debug(connectionLogPrefix + ": ToolboxAgent deploy started");
                v0 = contentLength;
                var12_18 = "tba.deploy." + (v0 != null ? v0 : 0L);
                v1 = var12_18.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getBytes(...)");
                relayWebSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])v1, (int)0, (int)0, (int)3, null));
                bufferSize = 0x100000;
                buffer = new byte[bufferSize];
                sendBytes = 0;
                break;
            }
            case 1: {
                sendResult = $continuation.Z$0;
                sendBytes = $continuation.I$2;
                bufferSize = $continuation.I$1;
                $i$a$-use-SpaceportAgentConnectionProvider$uploadToolboxAgent$2 = $continuation.I$0;
                buffer = (byte[])$continuation.L$8;
                bytesRead = (Ref.IntRef)$continuation.L$7;
                it = (BufferedInputStream)$continuation.L$6;
                var8_11 = null;
                var7_10 = (Closeable)$continuation.L$5;
                distribution = (DistributionInfo)$continuation.L$4;
                contentLength = (Long)$continuation.L$3;
                inputStream = (BufferedInputStream)$continuation.L$2;
                relayWebSocket = (WebSocket)$continuation.L$1;
                connectionLogPrefix = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    ** GOTO lbl65
                }
                catch (Throwable var10_15) {
                    try {
                        var8_11 = var10_15;
                        throw var10_15;
                    }
                    catch (Throwable var10_16) {
                        CloseableKt.closeFinally((Closeable)var7_10, (Throwable)var8_11);
                        throw var10_16;
                    }
                }
            }
            default: {
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        }
        while (true) {
            it = var15_22 = inputStream.read(buffer);
            $i$a$-also-SpaceportAgentConnectionProvider$uploadToolboxAgent$2$1 = false;
            bytesRead.element = it;
            if (var15_22 == -1) break;
            sendResult = relayWebSocket.send(ByteString.Companion.of(buffer, 0, bytesRead.element));
lbl65:
            // 3 sources

            while (relayWebSocket.queueSize() > (long)bufferSize) {
                $continuation.L$0 = connectionLogPrefix;
                $continuation.L$1 = relayWebSocket;
                $continuation.L$2 = inputStream;
                $continuation.L$3 = contentLength;
                $continuation.L$4 = distribution;
                $continuation.L$5 = var7_10;
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)it);
                $continuation.L$7 = bytesRead;
                $continuation.L$8 = buffer;
                $continuation.I$0 = $i$a$-use-SpaceportAgentConnectionProvider$uploadToolboxAgent$2;
                $continuation.I$1 = bufferSize;
                $continuation.I$2 = sendBytes;
                $continuation.Z$0 = sendResult;
                $continuation.label = 1;
                v2 = DelayKt.delay((long)10L, (Continuation)$continuation);
                if (v2 != var21_9) continue;
                return var21_9;
            }
            sendBytes += bytesRead.element;
            if (!sendResult) {
                this.logger.error(connectionLogPrefix + ": Failed to upload toolbox agent");
                throw new IllegalStateException("Failed to send toolbox upload frame");
            }
            if (contentLength != null) {
                var17_26 = "%.1f";
                var18_27 = new Object[]{Boxing.boxFloat((float)((float)100 * (float)sendBytes / (float)contentLength.longValue()))};
                v3 = String.format(var17_26, Arrays.copyOf(var18_27, var18_27.length));
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"format(...)");
                this.logger.trace("Sent " + v3 + "%");
                continue;
            }
            this.logger.trace("Sent " + FileSize.toString-impl(FileSystemExtKt.getBytes(sendBytes), 2));
        }
        this.logger.debug(connectionLogPrefix + ": ToolboxAgent deploy finished");
        var15_23 = "tba.sha256." + distribution.getSha256();
        v4 = var15_23.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getBytes(...)");
        var9_13 = relayWebSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])v4, (int)0, (int)0, (int)3, null));
        CloseableKt.closeFinally((Closeable)var7_10, (Throwable)var8_11);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getUserId$p(SpaceportAgentConnectionProvider $this) {
        return $this.userId;
    }

    public static final /* synthetic */ CoroutineScope access$getPluginScope$p(SpaceportAgentConnectionProvider $this) {
        return $this.pluginScope;
    }

    public static final /* synthetic */ Logger access$getLogger$p(SpaceportAgentConnectionProvider $this) {
        return $this.logger;
    }

    public static final /* synthetic */ int access$getIncreasedPipeSize$p(SpaceportAgentConnectionProvider $this) {
        return $this.increasedPipeSize;
    }

    public static final /* synthetic */ Mutex access$getReconnectionLock$p(SpaceportAgentConnectionProvider $this) {
        return $this.reconnectionLock;
    }

    public static final /* synthetic */ Function2 access$getFetchRdConnectionInfo$p(SpaceportAgentConnectionProvider $this) {
        return $this.fetchRdConnectionInfo;
    }

    public static final /* synthetic */ Object access$deployToolboxAgent(SpaceportAgentConnectionProvider $this, String connectionLogPrefix, WebSocket relayWebSocket, boolean redeploy, Continuation $completion) {
        return $this.deployToolboxAgent(connectionLogPrefix, relayWebSocket, redeploy, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$uploadToolboxAgent(SpaceportAgentConnectionProvider $this, String connectionLogPrefix, WebSocket relayWebSocket, BufferedInputStream inputStream, Long contentLength, DistributionInfo distribution, Continuation $completion) {
        return $this.uploadToolboxAgent(connectionLogPrefix, relayWebSocket, inputStream, contentLength, distribution, (Continuation<? super Unit>)$completion);
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

