/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.api.core.diagnostics.Logger;
import com.jetbrains.toolbox.api.core.os.LocalDesktopManager;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.api.remoteDev.logs.LogCollector;
import com.jetbrains.toolbox.api.ui.ToolboxUi;
import com.jetbrains.toolbox.gateway.spaceport.CodeCanvasReporter;
import com.jetbrains.toolbox.gateway.spaceport.CodeCanvasUrls;
import com.jetbrains.toolbox.gateway.spaceport.ReportInit;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportActions;
import com.jetbrains.toolbox.gateway.spaceport.auth.SpaceportAccount;
import com.jetbrains.toolbox.network.DownloadSessionUtilKt;
import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.StateFlow;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nCodeCanvasReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeCanvasReporter.kt\ncom/jetbrains/toolbox/gateway/spaceport/CodeCanvasReporter\n+ 2 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n7#2,7:145\n7#2,2:152\n9#2,5:156\n1869#3,2:154\n1#4:161\n*S KotlinDebug\n*F\n+ 1 CodeCanvasReporter.kt\ncom/jetbrains/toolbox/gateway/spaceport/CodeCanvasReporter\n*L\n55#1:145,7\n72#1:152,2\n72#1:156,5\n84#1:154,2\n*E\n"})
public final class CodeCanvasReporter {
    @NotNull
    private final StateFlow<SpaceportAccount> account;
    @NotNull
    private final LogCollector logsCollector;
    @NotNull
    private final SpaceportActions actions;
    @NotNull
    private final LocalDesktopManager desktopManager;
    @NotNull
    private final ToolboxUi toolboxUi;
    @NotNull
    private final LocalizableStringFactory i18n;
    @NotNull
    private final Logger logger;

    public CodeCanvasReporter(@NotNull StateFlow<SpaceportAccount> account2, @NotNull LogCollector logsCollector, @NotNull SpaceportActions actions2, @NotNull LocalDesktopManager desktopManager, @NotNull ToolboxUi toolboxUi, @NotNull LocalizableStringFactory i18n, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(account2, (String)"account");
        Intrinsics.checkNotNullParameter((Object)logsCollector, (String)"logsCollector");
        Intrinsics.checkNotNullParameter((Object)actions2, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)desktopManager, (String)"desktopManager");
        Intrinsics.checkNotNullParameter((Object)toolboxUi, (String)"toolboxUi");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.account = account2;
        this.logsCollector = logsCollector;
        this.actions = actions2;
        this.desktopManager = desktopManager;
        this.toolboxUi = toolboxUi;
        this.i18n = i18n;
        this.logger = logger;
    }

    private final String getTimestamp() {
        String timezone = System.getProperty("user.timezone");
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone(timezone));
        String string = df.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object reportProblem(@NotNull String devEnvId, @NotNull Continuation<? super Unit> $completion) {
        block28: {
            block26: {
                if (!($completion instanceof reportProblem.1)) ** GOTO lbl-1000
                var26_3 = $completion;
                if ((var26_3.label & -2147483648) != 0) {
                    var26_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        Object L$7;
                        Object L$8;
                        int I$0;
                        int I$1;
                        int I$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ CodeCanvasReporter this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.reportProblem(null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var27_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $continuation.L$0 = devEnvId;
                        $continuation.label = 1;
                        v0 = this.toolboxUi.showSnackbar("code-canvas-reporting", this.i18n.ptrl("Collecting report"), this.i18n.ptrl("After all logs are collected, the Toolbox App will open a browser window with a new issue in YouTrack"), this.i18n.ptrl("OK"), (Continuation)$continuation);
                        if (v0 == var27_5) {
                            return var27_5;
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        devEnvId = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        this.logger.info("Reporting problem for environment: " + devEnvId);
                        $i$f$catching = 0;
                        $i$a$-catching-CodeCanvasReporter$reportProblem$logsPath$1 = 0;
                        $continuation.L$0 = devEnvId;
                        $continuation.I$0 = $i$f$catching;
                        $continuation.I$1 = $i$a$-catching-CodeCanvasReporter$reportProblem$logsPath$1;
                        $continuation.label = 2;
                        v1 = this.logsCollector.collect(devEnvId, (Continuation)$continuation);
                        ** if (v1 != var27_5) goto lbl35
lbl34:
                        // 1 sources

                        return var27_5;
lbl35:
                        // 1 sources

                        ** GOTO lbl44
                    }
                    case 2: {
                        $i$a$-catching-CodeCanvasReporter$reportProblem$logsPath$1 = $continuation.I$1;
                        $i$f$catching = $continuation.I$0;
                        devEnvId = (String)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl44:
                            // 2 sources

                            var6_11 = Result.constructor-impl((Object)((Path)v1));
                        }
                        catch (CancellationException c$iv) {
                            throw c$iv;
                        }
                        catch (Throwable t$iv) {
                            var6_11 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                        }
                        $i$f$catching = var6_11;
                        v2 = Result.exceptionOrNull-impl((Object)$i$f$catching);
                        if (v2 != null) {
                            it = $i$a$-catching-CodeCanvasReporter$reportProblem$logsPath$1 = v2;
                            $i$a$-onFailure-CodeCanvasReporter$reportProblem$logsPath$2 = false;
                            this.logger.warn(it, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, reportProblem$lambda$1$0(java.lang.String ), ()Ljava/lang/String;)((String)devEnvId));
                        }
                        logsPath = (Path)(Result.isFailure-impl((Object)$i$f$catching) != false ? null : $i$f$catching);
                        account = (SpaceportAccount)this.account.getValue();
                        if (account == null) {
                            this.logger.warn("Toolbox logs can't be uploaded (" + devEnvId + "): SpaceportAccount is null");
                        }
                        if (logsPath == null || account == null) break block26;
                        $continuation.L$0 = devEnvId;
                        $continuation.L$1 = logsPath;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)account);
                        $continuation.label = 3;
                        v3 = this.actions.getTroubleshootingEndpoint-0E7RQCE$gateway_plugin_space_port(account, devEnvId, (Continuation<? super Result<ReportInit>>)$continuation);
                        if (v3 == var27_5) {
                            return var27_5;
                        }
                        ** GOTO lbl78
                    }
                    case 3: {
                        account = (SpaceportAccount)$continuation.L$2;
                        logsPath = (Path)$continuation.L$1;
                        devEnvId = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = ((Result)$result).unbox-impl();
lbl78:
                        // 2 sources

                        var7_15 = v3;
                        v4 = Result.exceptionOrNull-impl((Object)var7_15);
                        if (v4 != null) {
                            it = var8_17 = v4;
                            $i$a$-onFailure-CodeCanvasReporter$reportProblem$reportId$uploadEndpoint$1 = false;
                            this.logger.warn(it, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, reportProblem$lambda$2$0(java.lang.String ), ()Ljava/lang/String;)((String)devEnvId));
                        }
                        v5 = uploadEndpoint = (ReportInit)(Result.isFailure-impl((Object)var7_15) != false ? null : var7_15);
                        if (v5 == null) break;
                        endpoint = v5;
                        $i$a$-let-CodeCanvasReporter$reportProblem$reportId$1 = 0;
                        $i$f$catching = 0;
                        $i$a$-catching-CodeCanvasReporter$reportProblem$reportId$1$1 = 0;
                        client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(120L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
                        v6 = logsPath.toFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toFile(...)");
                        requestBody = RequestBody.Companion.create(v6, MediaType.Companion.get("application/octet-stream"));
                        requestBuilder = new Request.Builder().url(endpoint.getUploadUrl()).put(requestBody);
                        $this$forEach$iv = endpoint.getHeaders();
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            var19_37 = (Pair)element$iv;
                            $i$a$-forEach-CodeCanvasReporter$reportProblem$reportId$1$1$1 = false;
                            name = (String)var19_37.component1();
                            value = (String)var19_37.component2();
                            requestBuilder.addHeader(name, value);
                        }
                        request = requestBuilder.build();
                        $continuation.L$0 = devEnvId;
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)logsPath);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)account);
                        $continuation.L$3 = uploadEndpoint;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)endpoint);
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)client);
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)requestBuilder);
                        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)requestBody);
                        $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)request);
                        $continuation.I$0 = $i$a$-let-CodeCanvasReporter$reportProblem$reportId$1;
                        $continuation.I$1 = $i$f$catching;
                        $continuation.I$2 = $i$a$-catching-CodeCanvasReporter$reportProblem$reportId$1$1;
                        $continuation.label = 4;
                        v7 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(client, request, this, devEnvId, null){
                            int label;
                            final /* synthetic */ OkHttpClient $client;
                            final /* synthetic */ Request $request;
                            final /* synthetic */ CodeCanvasReporter this$0;
                            final /* synthetic */ String $devEnvId;
                            {
                                this.$client = $client;
                                this.$request = $request;
                                this.this$0 = $receiver;
                                this.$devEnvId = $devEnvId;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = DownloadSessionUtilKt.await(this.$client.newCall(this.$request), (Continuation<? super Response>)((Continuation)this));
                                        if (v0 == var8_2) {
                                            return var8_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        var2_3 = (Closeable)v0;
                                        var3_4 = this.this$0;
                                        var4_5 = this.$devEnvId;
                                        var5_6 = null;
                                        try {
                                            response = (Response)var2_3;
                                            $i$a$-use-CodeCanvasReporter$reportProblem$reportId$1$1$2$1 = false;
                                            if (!response.isSuccessful()) {
                                                CodeCanvasReporter.access$getLogger$p(var3_4).warn("Failed to upload Toolbox logs (" + var4_5 + "): [" + response.code() + "]: " + response.message());
                                            }
                                            var6_7 = Unit.INSTANCE;
                                        }
                                        catch (Throwable var7_9) {
                                            var5_6 = var7_9;
                                            throw var7_9;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)var2_3, (Throwable)var5_6);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation);
                        ** if (v7 != var27_5) goto lbl127
lbl126:
                        // 1 sources

                        return var27_5;
lbl127:
                        // 1 sources

                        ** GOTO lbl145
                    }
                    case 4: {
                        $i$a$-catching-CodeCanvasReporter$reportProblem$reportId$1$1 = $continuation.I$2;
                        $i$f$catching = $continuation.I$1;
                        $i$a$-let-CodeCanvasReporter$reportProblem$reportId$1 = $continuation.I$0;
                        request = (Request)$continuation.L$8;
                        requestBody = (RequestBody)$continuation.L$7;
                        requestBuilder = (Request.Builder)$continuation.L$6;
                        client = (OkHttpClient)$continuation.L$5;
                        endpoint = (ReportInit)$continuation.L$4;
                        uploadEndpoint = (ReportInit)$continuation.L$3;
                        account = (SpaceportAccount)$continuation.L$2;
                        logsPath = (Path)$continuation.L$1;
                        devEnvId = (String)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl145:
                            // 2 sources

                            var23_41 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (CancellationException c$iv) {
                            throw c$iv;
                        }
                        catch (Throwable t$iv) {
                            var23_41 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
                        }
                        var10_23 = var23_41;
                        v8 = Result.exceptionOrNull-impl((Object)var10_23);
                        if (v8 != null) {
                            it = var11_25 = v8;
                            $i$a$-onFailure-CodeCanvasReporter$reportProblem$reportId$1$2 = false;
                            this.logger.warn(it, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, reportProblem$lambda$3$1$0(java.lang.String ), ()Ljava/lang/String;)((String)devEnvId));
                        }
                        Result.box-impl((Object)var10_23);
                        break;
                    }
                }
                v9 = uploadEndpoint;
                v10 = v9 != null ? v9.getReportId() : null;
                break block28;
            }
            v10 = null;
        }
        reportId = v10;
        this.launchBrowser(devEnvId, reportId);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void launchBrowser(String devEnvId, String reportId2) {
        String string;
        String string2;
        String string3;
        SpaceportAccount spaceportAccount = (SpaceportAccount)this.account.getValue();
        if (spaceportAccount == null) {
            return;
        }
        SpaceportAccount account2 = spaceportAccount;
        String server = account2.getInstanceUrl();
        String timestamp2 = this.getTimestamp();
        String string4 = reportId2;
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            string3 = CodeCanvasUrls.INSTANCE.clientTroubleshootLogs(server, it, devEnvId);
        } else {
            string3 = null;
        }
        String clientLogsUrl = string3;
        String string5 = reportId2;
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            string2 = CodeCanvasUrls.INSTANCE.hostTroubleshootLogs(server, it, devEnvId);
        } else {
            string2 = null;
        }
        String hostLogsUrl = string2;
        String ideLogsUrl = CodeCanvasUrls.INSTANCE.ideLogs(server, devEnvId);
        String containerLogsUrl = CodeCanvasUrls.INSTANCE.containerLogs(server, devEnvId);
        String string6 = CodeCanvasUrls.INSTANCE.devEnvironment(server, devEnvId);
        String string7 = Build.INSTANCE.getApplicationFullNameVersion();
        String string8 = OS.INSTANCE.getNameAndVersion();
        String string9 = OS.INSTANCE.getCpuArch();
        String string10 = clientLogsUrl;
        if (string10 == null) {
            string10 = "not available";
        }
        if ((string = hostLogsUrl) == null) {
            string = ideLogsUrl;
        }
        String description2 = StringsKt.trimIndent((String)("\n      Date and time: " + timestamp2 + "\n      CodeCanvas stack url: " + server + "\n      Dev environment: " + string6 + "\n      Toolbox build: " + string7 + ", " + string8 + ", " + string9 + "\n      Client and Toolbox logs: " + string10 + "\n      Dev environment host logs: " + string + "\n      Container logs: " + containerLogsUrl + "\n    "));
        String summary = "Report for dev environment " + devEnvId + " from Toolbox";
        this.desktopManager.openUrl(this.youtrackUrl(summary, description2));
    }

    private final URL youtrackUrl(String summary, String description2) {
        StringBuilder stringBuilder;
        String baseUrl = "https://youtrack.jetbrains.com/newIssue";
        StringBuilder $this$youtrackUrl_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$youtrackUrl_u24lambda_u240.append(baseUrl);
        $this$youtrackUrl_u24lambda_u240.append("?project=").append(URLEncoder.encode("RDO", StandardCharsets.UTF_8));
        $this$youtrackUrl_u24lambda_u240.append("&description=").append(URLEncoder.encode(description2, StandardCharsets.UTF_8));
        $this$youtrackUrl_u24lambda_u240.append("&summary=").append(URLEncoder.encode(summary, StandardCharsets.UTF_8));
        $this$youtrackUrl_u24lambda_u240.append("&c=").append(URLEncoder.encode("Type+Report", StandardCharsets.UTF_8));
        String it = stringBuilder.toString();
        boolean bl2 = false;
        URL uRL = new URI(it).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"let(...)");
        return uRL;
    }

    private static final String reportProblem$lambda$1$0(String $devEnvId) {
        return "Toolbox logs won't be uploaded (" + $devEnvId + "): logs collector failed";
    }

    private static final String reportProblem$lambda$2$0(String $devEnvId) {
        return "Toolbox logs won't be uploaded (" + $devEnvId + "): failed to get troubleshooting endpoint";
    }

    private static final String reportProblem$lambda$3$1$0(String $devEnvId) {
        return "Error uploading Toolbox logs (" + $devEnvId + ")";
    }

    public static final /* synthetic */ Logger access$getLogger$p(CodeCanvasReporter $this) {
        return $this.logger;
    }
}

