/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.project;

import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentProviderId;
import com.jetbrains.toolbox.gateway.project.model.CachedEnvironmentDto;
import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nRemoteProjectCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteProjectCache.kt\ncom/jetbrains/toolbox/gateway/project/RemoteProjectCache\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 OkioStreams.kt\nkotlinx/serialization/json/okio/OkioStreamsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n66#2:51\n52#2,4:53\n60#2,10:59\n56#2,3:69\n71#2,3:72\n52#2,4:85\n60#2,10:91\n56#2,18:101\n67#3:52\n68#3:57\n80#3:82\n165#3:83\n81#3:84\n82#3:89\n78#4:58\n46#4:90\n1208#5,2:75\n1236#5,4:77\n1#6:81\n*S KotlinDebug\n*F\n+ 1 RemoteProjectCache.kt\ncom/jetbrains/toolbox/gateway/project/RemoteProjectCache\n*L\n31#1:51\n31#1:53,4\n31#1:59,10\n31#1:69,3\n31#1:72,3\n42#1:85,4\n42#1:91,10\n42#1:101,18\n31#1:52\n31#1:57\n42#1:82\n42#1:83\n42#1:84\n42#1:89\n31#1:58\n43#1:90\n32#1:75,2\n32#1:77,4\n*E\n"})
public final class RemoteProjectCache {
    @NotNull
    private final Path file;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Json parser;

    public RemoteProjectCache(@NotNull Path file, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.file = file;
        this.fileSystem = fileSystem;
        this.parser = JsonKt.Json$default(null, RemoteProjectCache::parser$lambda$0, (int)1, null);
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Map<DevEnvironmentId, CachedEnvironmentDto> load() {
        if (!this.fileSystem.exists(this.file)) {
            return MapsKt.emptyMap();
        }
        try {
            void $this$associateByTo$iv$iv;
            List $i$a$-use-FileSystem$read$1$iv23332;
            Throwable thrown$iv$iv;
            Object $this$use$iv$iv;
            block19: {
                void this_$iv;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = this.file;
                boolean bl = false;
                $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void $this$decodeFromBufferedSource$iv;
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean $i$a$-use-FileSystem$read$1$iv23332 = false;
                    BufferedSource $this$load_u24lambda_u240 = it$iv;
                    boolean bl2 = false;
                    Json json2 = this.parser;
                    BufferedSource source$iv = $this$load_u24lambda_u240;
                    boolean $i$f$decodeFromBufferedSource = false;
                    $this$decodeFromBufferedSource$iv.getSerializersModule();
                    $i$a$-use-FileSystem$read$1$iv23332 = (List)OkioStreamsKt.decodeFromBufferedSource((Json)$this$decodeFromBufferedSource$iv, (DeserializationStrategy)((DeserializationStrategy)new ArrayListSerializer(CachedEnvironmentDto.Companion.serializer())), (BufferedSource)source$iv);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        $i$a$-use-FileSystem$read$1$iv23332 = null;
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block20: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block20;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            List result$iv$iv = $i$a$-use-FileSystem$read$1$iv23332;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            List list2 = result$iv$iv;
            Iterable $this$associateBy$iv = list2;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            $this$use$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object element$iv$iv = iterator2.next();
                CachedEnvironmentDto t$iv$iv = (CachedEnvironmentDto)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(new DevEnvironmentId(DevEnvironmentProviderId.constructor-impl(it.getProviderId()), it.getEnvironmentId(), null), element$iv$iv);
            }
            return destination$iv$iv;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to deserialize project list from file '" + this.file + "'");
            return MapsKt.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void save(@NotNull Map<DevEnvironmentId, CachedEnvironmentDto> state2) {
        Intrinsics.checkNotNullParameter(state2, (String)"state");
        Path path2 = this.file.parent();
        if (path2 != null) {
            Path path3 = path2;
            FileSystem fileSystem = this.fileSystem;
            Path p0 = path3;
            boolean bl = false;
            fileSystem.createDirectories(p0);
        }
        try {
            Unit unit;
            Throwable thrown$iv$iv;
            block17: {
                void $this$iv;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = this.file;
                boolean mustCreate$iv = false;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void value$iv;
                    void $this$encodeToBufferedSink$iv;
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$save_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    Json json2 = this.parser;
                    Collection<CachedEnvironmentDto> collection = state2.values();
                    BufferedSink sink$iv = $this$save_u24lambda_u240;
                    boolean $i$f$encodeToBufferedSink = false;
                    $this$encodeToBufferedSink$iv.getSerializersModule();
                    OkioStreamsKt.encodeToBufferedSink((Json)$this$encodeToBufferedSink$iv, (SerializationStrategy)((SerializationStrategy)new ArrayListSerializer(CachedEnvironmentDto.Companion.serializer())), (Object)value$iv, (BufferedSink)sink$iv);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        unit = null;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block18: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block18;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Unit result$iv$iv = unit;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return;
            throw throwable;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to serialize project list to file '" + this.file + "'");
        }
    }

    private static final Unit parser$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(false);
        $this$Json.setCoerceInputValues(true);
        $this$Json.setExplicitNulls(false);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

