/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy.logs;

import com.jetbrains.toolbox.LocalLogCollector;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.gateway.deploy.logs.LogCollectionStep;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class LocalLogCollectionStep
implements LogCollectionStep {
    @NotNull
    private final LocalLogCollector localLogCollector;
    @NotNull
    private final LocalizableString title;

    public LocalLogCollectionStep(@NotNull LocalLogCollector localLogCollector) {
        Intrinsics.checkNotNullParameter((Object)localLogCollector, (String)"localLogCollector");
        this.localLogCollector = localLogCollector;
        this.title = LocalizableStringExKt.trl("Collecting local Toolbox App logs");
    }

    @Override
    @NotNull
    public LocalizableString getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public Object collect(@NotNull MutableStateFlow<Float> progress2, @NotNull Continuation<? super Path> $completion) {
        Path path2;
        try {
            path2 = this.localLogCollector.collectLocalLogs(false);
        }
        catch (Exception e) {
            Logger.INSTANCE.warn((Throwable)e, "Failed to collect local logs");
            path2 = null;
        }
        return path2;
    }
}

