/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy.logs;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.remoteDev.deploy.DiagnosticInfoCollector;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.deploy.logs.DiagnosticsLogCollectionStep;
import com.jetbrains.toolbox.gateway.deploy.logs.LogCollectionStep;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class DiagnosticsLogCollectionStep
implements LogCollectionStep {
    @NotNull
    private final DevEnvironmentId environmentId;
    @Nullable
    private final DiagnosticInfoCollector environmentDiagnosticInfoCollector;
    @Nullable
    private final DiagnosticInfoCollector providerDiagnosticInfoCollector;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final LocalizableString title;

    public DiagnosticsLogCollectionStep(@NotNull DevEnvironmentId environmentId, @Nullable DiagnosticInfoCollector environmentDiagnosticInfoCollector, @Nullable DiagnosticInfoCollector providerDiagnosticInfoCollector, @NotNull FileUtils fileUtils, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.environmentId = environmentId;
        this.environmentDiagnosticInfoCollector = environmentDiagnosticInfoCollector;
        this.providerDiagnosticInfoCollector = providerDiagnosticInfoCollector;
        this.fileUtils = fileUtils;
        this.fileSystem = fileSystem;
        this.title = LocalizableStringExKt.trl("Collecting additional diagnostics from provider");
    }

    @Override
    @NotNull
    public LocalizableString getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public Object isApplicable(@NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((this.environmentDiagnosticInfoCollector != null || this.providerDiagnosticInfoCollector != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Object collect(@NotNull MutableStateFlow<Float> progress, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof collect.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DiagnosticsLogCollectionStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.collect(null, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                tempDir = this.fileUtils.createTempDirectory("tbx-diagnostics");
                diagnosticsDir = tempDir.resolve(StringExtensionsKt.sanitizeDirName(this.environmentId.getProviderId-rwbms5E()) + "-diagnostics");
                environmentDir = diagnosticsDir.resolve(StringExtensionsKt.sanitizeDirName(this.environmentId.getEnvironmentId()));
                this.fileSystem.createDirectories(environmentDir);
                this.fileSystem.createDirectories(diagnosticsDir);
                try {
                    Logger.INSTANCE.info("Collecting provider diagnostics for " + this.environmentId);
                    v0 = this.providerDiagnosticInfoCollector;
                    if (v0 != null) {
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)progress);
                        $continuation.L$1 = tempDir;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)diagnosticsDir);
                        $continuation.L$3 = environmentDir;
                        $continuation.label = 1;
                        v1 = v0.collectAdditionalDiagnostics(diagnosticsDir.toNioPath(), (Continuation)$continuation);
                    }
                    ** GOTO lbl47
                }
                catch (Exception e) {
                    Logger.INSTANCE.warn((Throwable)e, "Failed to collect additional diagnostics for " + this.environmentId);
                    this.fileUtils.asyncDelete(tempDir);
                    return null;
                }
                v2 = v1;
                if (v1 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl47
            }
            case 1: {
                environmentDir = (Path)$continuation.L$3;
                diagnosticsDir = (Path)$continuation.L$2;
                tempDir = (Path)$continuation.L$1;
                progress = (MutableStateFlow)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl47:
                    // 3 sources

                    Logger.INSTANCE.info("Collecting environment diagnostics for " + this.environmentId);
                    v3 = this.environmentDiagnosticInfoCollector;
                    if (v3 == null) return tempDir;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)progress);
                    $continuation.L$1 = tempDir;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)diagnosticsDir);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)environmentDir);
                    $continuation.label = 2;
                    v4 = v3.collectAdditionalDiagnostics(environmentDir.toNioPath(), (Continuation)$continuation);
                }
                v5 = v4;
                if (v4 != var10_5) return tempDir;
                return var10_5;
            }
            case 2: {
                environmentDir = (Path)$continuation.L$3;
                diagnosticsDir = (Path)$continuation.L$2;
                tempDir = (Path)$continuation.L$1;
                progress = (MutableStateFlow)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
                    return tempDir;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

