/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy;

import com.jetbrains.toolbox.api.core.Arch;
import com.jetbrains.toolbox.api.core.OS;
import com.jetbrains.toolbox.api.remoteDev.deploy.DistributionInfo;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nJbrDistributionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbrDistributionProvider.kt\ncom/jetbrains/toolbox/gateway/deploy/JbrDistributionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1193#2,2:50\n1267#2,4:52\n*S KotlinDebug\n*F\n+ 1 JbrDistributionProvider.kt\ncom/jetbrains/toolbox/gateway/deploy/JbrDistributionProvider\n*L\n23#1:50,2\n23#1:52,4\n*E\n"})
public final class JbrDistributionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int minimalMajorRequired;
    @NotNull
    private final Map<Pair<OS, Arch>, DistributionInfo> jbrToDownload;
    @NotNull
    public static final String JBR_PREFIX = "jetbrains-toolbox-slim-jre-jbrsdk-21.0.8";
    @NotNull
    public static final String JBR_SUFFIX = "b1092.38_20";

    /*
     * WARNING - void declaration
     */
    public JbrDistributionProvider() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        this.minimalMajorRequired = 21;
        Object object = new Pair[]{TuplesKt.to((Object)TuplesKt.to((Object)OS.MacOS, (Object)Arch.ARM64), (Object)"e88f2e38daa593ee14e9d11a8c3e48bec810ca159b00ec453fdbffe562bfb84d"), TuplesKt.to((Object)TuplesKt.to((Object)OS.MacOS, (Object)Arch.X64), (Object)"37e0feb4c56a4c572004e1952c29be57963f72c7ecf169488b4e2ff9b6d64f3c"), TuplesKt.to((Object)TuplesKt.to((Object)OS.Windows, (Object)Arch.ARM64), (Object)"dae20cf38cdb733950b51db29ed847d1006a7ec78f4839a84d0a0f92f322c276"), TuplesKt.to((Object)TuplesKt.to((Object)OS.Windows, (Object)Arch.X64), (Object)"25b2c20757fcc4abd0db99ed318c6b3b224f66afe65b04fdd16ce6e0fb0afb99"), TuplesKt.to((Object)TuplesKt.to((Object)OS.Linux, (Object)Arch.ARM64), (Object)"64753d018405707c366f4b331c7f71a24b7c3eca51a6c7e58066e1a14e92a330"), TuplesKt.to((Object)TuplesKt.to((Object)OS.Linux, (Object)Arch.X64), (Object)"1864d015405b3d0a502080ae5043493a738761ecb51e7205a8e8b12f8fc800d7")};
        object = CollectionsKt.listOf((Object[])object);
        JbrDistributionProvider jbrDistributionProvider = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var4_5 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            Pair target = (Pair)pair.component1();
            String hash = (String)pair.component2();
            OS os = (OS)target.component1();
            Arch arch = (Arch)target.component2();
            pair = TuplesKt.to((Object)target, (Object)new DistributionInfo(new URI("https://download.jetbrains.com/toolbox/agent/jre/jetbrains-toolbox-slim-jre-jbrsdk-21.0.8-" + this.urlString(os, arch) + "-b1092.38_20.tar.gz"), hash));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        jbrDistributionProvider.jbrToDownload = destination$iv$iv;
    }

    private final String urlString(OS os, Arch arch) {
        String osString = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1 -> "linux";
            case 2 -> "mac";
            case 3 -> "win32";
            default -> throw new NoWhenBranchMatchedException();
        };
        String archString = switch (WhenMappings.$EnumSwitchMapping$1[arch.ordinal()]) {
            case 1 -> "x64";
            case 2 -> "aarch64";
            default -> throw new NoWhenBranchMatchedException();
        };
        return osString + "-" + archString;
    }

    @Nullable
    public final DistributionInfo getJbrDistribution(@NotNull OS os, @NotNull Arch arch) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        return this.jbrToDownload.get(TuplesKt.to((Object)os, (Object)arch));
    }

    public final int getMinimalMajor() {
        return this.minimalMajorRequired;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MacOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Arch.values().length];
            try {
                nArray[Arch.X64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

