/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.api.core.Arch;
import com.jetbrains.toolbox.api.core.OS;
import com.jetbrains.toolbox.api.remoteDev.deploy.AgentDistributionProvider;
import com.jetbrains.toolbox.api.remoteDev.deploy.DistributionInfo;
import com.jetbrains.toolbox.gateway.deploy.DownloadableToolboxAgentDistributionProvider;
import com.jetbrains.toolbox.gateway.deploy.JbrDistributionProvider;
import com.jetbrains.toolbox.manager.SnackbarManager;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.network.DownloadResult;
import com.jetbrains.toolbox.network.DownloadSession;
import java.net.URI;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nDownloadableToolboxAgentDistributionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadableToolboxAgentDistributionProvider.kt\ncom/jetbrains/toolbox/gateway/deploy/DownloadableToolboxAgentDistributionProvider\n+ 2 retryWithBackoff.kt\ncom/jetbrains/toolbox/common/RetryWithBackoffKt\n*L\n1#1,108:1\n14#2,12:109\n*S KotlinDebug\n*F\n+ 1 DownloadableToolboxAgentDistributionProvider.kt\ncom/jetbrains/toolbox/gateway/deploy/DownloadableToolboxAgentDistributionProvider\n*L\n51#1:109,12\n*E\n"})
public class DownloadableToolboxAgentDistributionProvider
implements AgentDistributionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DownloadManager downloadManager;
    @Nullable
    private final SnackbarManager snackbarManager;
    @NotNull
    private final String buildNumber;
    @NotNull
    private final JbrDistributionProvider jbrDistributionProvider;
    private final boolean isOfflineMode;
    @NotNull
    private static final String AGENT_DOWNLOAD_ROOT = "https://download.jetbrains.com/toolbox/agent/";
    @NotNull
    private static final String AGENT_NOT_FOUND_CONTENT = "AGENT_NOT_FOUND";
    @NotNull
    private static final List<String> commonArgs;

    private DownloadableToolboxAgentDistributionProvider(DownloadManager downloadManager, SnackbarManager snackbarManager, String buildNumber, JbrDistributionProvider jbrDistributionProvider, boolean isOfflineMode) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)jbrDistributionProvider, (String)"jbrDistributionProvider");
        this.downloadManager = downloadManager;
        this.snackbarManager = snackbarManager;
        this.buildNumber = buildNumber;
        this.jbrDistributionProvider = jbrDistributionProvider;
        this.isOfflineMode = isOfflineMode;
    }

    public /* synthetic */ DownloadableToolboxAgentDistributionProvider(DownloadManager downloadManager, SnackbarManager snackbarManager, String string, JbrDistributionProvider jbrDistributionProvider, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            snackbarManager = null;
        }
        if ((n & 4) != 0) {
            string = Build.INSTANCE.getBuildNumber-Y_E1uuk();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(downloadManager, snackbarManager, string, jbrDistributionProvider, bl, null);
    }

    private final String osNameForCli(OS os) {
        return switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1 -> "win32";
            case 2 -> "linux";
            case 3 -> "mac";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String archNameForCli(Arch arch) {
        return switch (WhenMappings.$EnumSwitchMapping$1[arch.ordinal()]) {
            case 1 -> "x64";
            case 2 -> "aarch64";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Unable to fully structure code
     */
    private final Object resolveDownloadableClient-r68XsIY(String $v$c$com-jetbrains-toolbox-BuildNumber$-build$0, OS os, Arch arch, boolean jreIncluded, Continuation<? super DistributionInfo> $completion) {
        block22: {
            if (!($completion instanceof resolveDownloadableClient.1)) ** GOTO lbl-1000
            var28_6 = $completion;
            if ((var28_6.label & -2147483648) != 0) {
                var28_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    boolean Z$0;
                    int I$0;
                    int I$1;
                    int I$2;
                    int I$3;
                    int I$4;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ DownloadableToolboxAgentDistributionProvider this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return DownloadableToolboxAgentDistributionProvider.access$resolveDownloadableClient-r68XsIY(this.this$0, null, null, null, false, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var29_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (this.isOfflineMode) {
                        return null;
                    }
                    withJreIncludedSuffix = jreIncluded != false ? "" : "-nojre";
                    artifactName = "tbcli-" + this.osNameForCli(os) + "-" + this.archNameForCli(arch) + "-" + $v$c$com-jetbrains-toolbox-BuildNumber$-build$0 + withJreIncludedSuffix + ".tar.gz";
                    var9_11 = new char[]{'/'};
                    source = StringsKt.trimEnd((String)"https://download.jetbrains.com/toolbox/agent/", (char[])var9_11) + "/" + (String)artifactName;
                    sourceURL = new URI((String)source);
                    shaSource = (String)source + ".sha256";
                    var12_14 = 3;
                    var13_17 = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
                    $i$f$retryWithBackoff-dWUq8MI = 0;
                    attempt$iv = 0;
lbl26:
                    // 2 sources

                    while (attempt$iv < attempts$iv) {
                        it = attempt$iv;
                        $i$a$-retryWithBackoff-dWUq8MI-DownloadableToolboxAgentDistributionProvider$resolveDownloadableClient$shaContent$1 = 0;
                        Logger.INSTANCE.debug("Resolving Toolbox Agent information from URL " + (String)source);
                        $continuation.L$0 = $v$c$com-jetbrains-toolbox-BuildNumber$-build$0;
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)os);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)arch);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)withJreIncludedSuffix);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)artifactName);
                        $continuation.L$5 = source;
                        $continuation.L$6 = sourceURL;
                        $continuation.L$7 = shaSource;
                        $continuation.Z$0 = jreIncluded;
                        $continuation.I$0 = attempts$iv;
                        $continuation.J$0 = $v$c$kotlin-time-Duration$-initialDelay$0$iv;
                        $continuation.I$1 = $i$f$retryWithBackoff-dWUq8MI;
                        $continuation.I$2 = attempt$iv;
                        $continuation.I$3 = it;
                        $continuation.I$4 = $i$a$-retryWithBackoff-dWUq8MI-DownloadableToolboxAgentDistributionProvider$resolveDownloadableClient$shaContent$1;
                        $continuation.label = 1;
                        v0 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                        ** if (v0 != var29_8) goto lbl51
lbl50:
                        // 1 sources

                        return var29_8;
lbl51:
                        // 1 sources

                        ** GOTO lbl73
                    }
                    break;
                }
                case 1: {
                    $i$a$-retryWithBackoff-dWUq8MI-DownloadableToolboxAgentDistributionProvider$resolveDownloadableClient$shaContent$1 = $continuation.I$4;
                    it = $continuation.I$3;
                    attempt$iv = $continuation.I$2;
                    $i$f$retryWithBackoff-dWUq8MI = $continuation.I$1;
                    $v$c$kotlin-time-Duration$-initialDelay$0$iv = $continuation.J$0;
                    attempts$iv = $continuation.I$0;
                    jreIncluded = $continuation.Z$0;
                    shaSource = (String)$continuation.L$7;
                    sourceURL = (URI)$continuation.L$6;
                    source = (String)$continuation.L$5;
                    artifactName = (String)$continuation.L$4;
                    withJreIncludedSuffix = (String)$continuation.L$3;
                    arch = (Arch)$continuation.L$2;
                    os = (OS)$continuation.L$1;
                    $v$c$com-jetbrains-toolbox-BuildNumber$-build$0 = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl73:
                    // 2 sources

                    $continuation.L$0 = $v$c$com-jetbrains-toolbox-BuildNumber$-build$0;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)os);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)arch);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)withJreIncludedSuffix);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)artifactName);
                    $continuation.L$5 = source;
                    $continuation.L$6 = sourceURL;
                    $continuation.L$7 = shaSource;
                    $continuation.Z$0 = jreIncluded;
                    $continuation.I$0 = attempts$iv;
                    $continuation.J$0 = $v$c$kotlin-time-Duration$-initialDelay$0$iv;
                    $continuation.I$1 = $i$f$retryWithBackoff-dWUq8MI;
                    $continuation.I$2 = attempt$iv;
                    $continuation.I$3 = it;
                    $continuation.I$4 = $i$a$-retryWithBackoff-dWUq8MI-DownloadableToolboxAgentDistributionProvider$resolveDownloadableClient$shaContent$1;
                    $continuation.label = 2;
                    v1 = DownloadSession.getAsync$default((DownloadSession)v0, (String)shaSource, 1000000L, null, null, false, false, (Continuation)$continuation, 60, null);
                    ** if (v1 != var29_8) goto lbl92
lbl91:
                    // 1 sources

                    return var29_8;
lbl92:
                    // 1 sources

                    ** GOTO lbl113
                }
                case 2: {
                    $i$a$-retryWithBackoff-dWUq8MI-DownloadableToolboxAgentDistributionProvider$resolveDownloadableClient$shaContent$1 = $continuation.I$4;
                    it = $continuation.I$3;
                    attempt$iv = $continuation.I$2;
                    $i$f$retryWithBackoff-dWUq8MI = $continuation.I$1;
                    $v$c$kotlin-time-Duration$-initialDelay$0$iv = $continuation.J$0;
                    attempts$iv = $continuation.I$0;
                    jreIncluded = $continuation.Z$0;
                    shaSource = (String)$continuation.L$7;
                    sourceURL = (URI)$continuation.L$6;
                    source = (String)$continuation.L$5;
                    artifactName = (String)$continuation.L$4;
                    withJreIncludedSuffix = (String)$continuation.L$3;
                    arch = (Arch)$continuation.L$2;
                    os = (OS)$continuation.L$1;
                    $v$c$com-jetbrains-toolbox-BuildNumber$-build$0 = (String)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl113:
                        // 2 sources

                        var19_24 = (Pair)v1;
                        $i$a$-let-DownloadableToolboxAgentDistributionProvider$resolveDownloadableClient$shaContent$1$1 = false;
                        result = (DownloadResult)var19_24.component1();
                        contentBytes = (byte[])var19_24.component2();
                        content = new String(contentBytes, Charsets.UTF_8);
                        if (result.isSuccessful()) ** GOTO lbl130
                        if (!(result instanceof DownloadResult.Failed)) ** GOTO lbl-1000
                        v2 = ((DownloadResult.Failed)result).getCode();
                        var24_29 = 404;
                        if (v2 != null && v2 == var24_29) {
                            Logger.INSTANCE.info("Toolbox Agent version " + BuildNumber.toString-impl($v$c$com-jetbrains-toolbox-BuildNumber$-build$0) + " was not found (404) on " + (String)source + ", will not try again");
                            v3 = "AGENT_NOT_FOUND";
                        } else lbl-1000:
                        // 2 sources

                        {
                            errorMessage = (var25_31 = result) instanceof DownloadResult.Failed != false ? "Request failed: " + ((DownloadResult.Failed)result).getError() : (var25_31 instanceof DownloadResult.NotConnected != false ? "Request failed: " + ((DownloadResult.NotConnected)result).getError() : (var25_31 instanceof DownloadResult.Cancelled != false ? "Request has been cancelled" : result.toString()));
                            Logger.INSTANCE.warn("Failed to retrieve Toolbox Agent version from " + (String)source + ": " + errorMessage);
                            v3 = null;
                        }
                        ** GOTO lbl132
lbl130:
                        // 1 sources

                        v3 = StringsKt.trim((CharSequence)content).toString();
lbl132:
                        // 3 sources

                        result$iv = v3;
                        if (result$iv != null) {
                            v4 = result$iv;
                            break block22;
                        }
                    }
                    catch (Exception var26_33) {
                        // empty catch block
                    }
                    $continuation.L$0 = $v$c$com-jetbrains-toolbox-BuildNumber$-build$0;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)os);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)arch);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)withJreIncludedSuffix);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)artifactName);
                    $continuation.L$5 = source;
                    $continuation.L$6 = sourceURL;
                    $continuation.L$7 = shaSource;
                    $continuation.Z$0 = jreIncluded;
                    $continuation.I$0 = attempts$iv;
                    $continuation.J$0 = $v$c$kotlin-time-Duration$-initialDelay$0$iv;
                    $continuation.I$1 = $i$f$retryWithBackoff-dWUq8MI;
                    $continuation.I$2 = attempt$iv;
                    $continuation.label = 3;
                    v5 = DelayKt.delay-VtjQ1oo((long)Duration.times-UwyO8pc((long)$v$c$kotlin-time-Duration$-initialDelay$0$iv, (double)Math.pow(2.0, attempt$iv)), (Continuation)$continuation);
                    if (v5 == var29_8) {
                        return var29_8;
                    }
                    ** GOTO lbl173
                }
                case 3: {
                    attempt$iv = $continuation.I$2;
                    $i$f$retryWithBackoff-dWUq8MI = $continuation.I$1;
                    $v$c$kotlin-time-Duration$-initialDelay$0$iv = $continuation.J$0;
                    attempts$iv = $continuation.I$0;
                    jreIncluded = $continuation.Z$0;
                    shaSource = (String)$continuation.L$7;
                    sourceURL = (URI)$continuation.L$6;
                    source = (String)$continuation.L$5;
                    artifactName = (String)$continuation.L$4;
                    withJreIncludedSuffix = (String)$continuation.L$3;
                    arch = (Arch)$continuation.L$2;
                    os = (OS)$continuation.L$1;
                    $v$c$com-jetbrains-toolbox-BuildNumber$-build$0 = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl173:
                    // 2 sources

                    ++attempt$iv;
                    ** GOTO lbl26
                }
            }
            v4 = shaContent = null;
        }
        if (shaContent == null || Intrinsics.areEqual(shaContent, (Object)"AGENT_NOT_FOUND")) {
            it = var12_15 = null;
            $i$a$-also-DownloadableToolboxAgentDistributionProvider$resolveDownloadableClient$2 = false;
            v6 = this.snackbarManager;
            if (v6 != null) {
                v6.toolboxAgentBuildUnavailable($v$c$com-jetbrains-toolbox-BuildNumber$-build$0);
            }
            return var12_15;
        }
        it = var12_16 = new DistributionInfo(sourceURL, shaContent);
        $i$a$-also-DownloadableToolboxAgentDistributionProvider$resolveDownloadableClient$3 = false;
        Logger.INSTANCE.debug("Resolved agent distribution: " + it);
        return var12_16;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object getAgentDistribution(@NotNull OS os, @NotNull Arch arch, boolean jreIncluded, @NotNull Continuation<? super DistributionInfo> $completion) {
        return this.resolveDownloadableClient-r68XsIY(this.buildNumber, os, arch, jreIncluded, $completion);
    }

    @Nullable
    public Object getJreDistribution(@NotNull OS os, @NotNull Arch arch, @NotNull Continuation<? super DistributionInfo> $completion) {
        return this.jbrDistributionProvider.getJbrDistribution(os, arch);
    }

    @Nullable
    public Object getMinimalJreMajor(@NotNull OS os, @NotNull Arch arch, @NotNull Continuation<? super Integer> $completion) {
        return DownloadableToolboxAgentDistributionProvider.getMinimalJreMajor$suspendImpl(this, os, arch, $completion);
    }

    static /* synthetic */ Object getMinimalJreMajor$suspendImpl(DownloadableToolboxAgentDistributionProvider $this, OS os, Arch arch, Continuation<? super Integer> $completion) {
        return Boxing.boxInt((int)$this.jbrDistributionProvider.getMinimalMajor());
    }

    @Nullable
    public Object getAgentBuild(@NotNull OS os, @NotNull Arch arch, @NotNull Continuation<? super String> $completion) {
        return this.buildNumber;
    }

    public /* synthetic */ DownloadableToolboxAgentDistributionProvider(DownloadManager downloadManager, SnackbarManager snackbarManager, String buildNumber, JbrDistributionProvider jbrDistributionProvider, boolean isOfflineMode, DefaultConstructorMarker $constructor_marker) {
        this(downloadManager, snackbarManager, buildNumber, jbrDistributionProvider, isOfflineMode);
    }

    public static final /* synthetic */ Object access$resolveDownloadableClient-r68XsIY(DownloadableToolboxAgentDistributionProvider $this, String string, OS os, Arch arch, boolean jreIncluded, Continuation $completion) {
        return $this.resolveDownloadableClient-r68XsIY(string, os, arch, jreIncluded, (Continuation<? super DistributionInfo>)$completion);
    }

    static {
        Object[] objectArray = new String[]{"--structured-logging", "agent"};
        commonArgs = CollectionsKt.listOf((Object[])objectArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getCommonArgs() {
            return commonArgs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MacOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Arch.values().length];
            try {
                nArray[Arch.X64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

